<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_blog_style = explode('_', alisha_williams_get_theme_option('blog_style'));
$alisha_williams_columns = empty($alisha_williams_blog_style[1]) ? 2 : max(2, $alisha_williams_blog_style[1]);
$alisha_williams_post_format = get_post_format();
$alisha_williams_post_format = empty($alisha_williams_post_format) ? 'standard' : str_replace('post-format-', '', $alisha_williams_post_format);
$alisha_williams_animation = alisha_williams_get_theme_option('blog_animation');
$post_date_day  = apply_filters('trx_addons_filter_get_post_date', get_the_date('d'));
$post_date_month  = apply_filters('trx_addons_filter_get_post_date', get_the_date('M'));

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($alisha_williams_columns).' post_format_'.esc_attr($alisha_williams_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!alisha_williams_is_off($alisha_williams_animation) ? ' data-animation="'.esc_attr(alisha_williams_get_animation_classes($alisha_williams_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$alisha_williams_image_hover = alisha_williams_get_theme_option('image_hover');
	if ( has_post_thumbnail() ) {
	?>
	<div class="post_featured_content">
	<?php	
	// Featured image
	alisha_williams_show_post_featured(array(
		'thumb_size' => alisha_williams_get_thumb_size(strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false || $alisha_williams_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $alisha_williams_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $alisha_williams_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
	<div class="post_featured_date">
		<div class="post_featured_date_container">
			<div class="post_featured_date_day"><?php echo esc_attr($post_date_day) ?></div>
			<div class="post_featured_date_month"><?php echo esc_attr($post_date_month) ?></div>
		</div>
	</div></div>
	<?php	
	}
	?>
</article>