<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_blog_style = explode('_', alisha_williams_get_theme_option('blog_style'));
$alisha_williams_columns = empty($alisha_williams_blog_style[1]) ? 2 : max(2, $alisha_williams_blog_style[1]);
$alisha_williams_post_format = get_post_format();
$alisha_williams_post_format = empty($alisha_williams_post_format) ? 'standard' : str_replace('post-format-', '', $alisha_williams_post_format);
$alisha_williams_animation = alisha_williams_get_theme_option('blog_animation');
$alisha_williams_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($alisha_williams_columns).' post_format_'.esc_attr($alisha_williams_post_format) ); ?>
	<?php echo (!alisha_williams_is_off($alisha_williams_animation) ? ' data-animation="'.esc_attr(alisha_williams_get_animation_classes($alisha_williams_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($alisha_williams_image[1]) && !empty($alisha_williams_image[2])) echo intval($alisha_williams_image[1]) .'x' . intval($alisha_williams_image[2]); ?>"
	data-src="<?php if (!empty($alisha_williams_image[0])) echo esc_url($alisha_williams_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$alisha_williams_image_hover = 'icon';
	if (in_array($alisha_williams_image_hover, array('icons', 'zoom'))) $alisha_williams_image_hover = 'dots';
	alisha_williams_show_post_featured(array(
		'hover' => $alisha_williams_image_hover,
		'thumb_size' => alisha_williams_get_thumb_size( strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false || $alisha_williams_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. alisha_williams_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => false,
									'seo' => false,
									'share' => true,
									'counters' => 'comments',
									'echo' => false
									))
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'alisha-williams') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>