<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_post_format = get_post_format();
$alisha_williams_post_format = empty($alisha_williams_post_format) ? 'standard' : str_replace('post-format-', '', $alisha_williams_post_format);
$alisha_williams_animation = alisha_williams_get_theme_option('blog_animation');
$post_date_day  = apply_filters('trx_addons_filter_get_post_date', get_the_date('d'));
$post_date_month  = apply_filters('trx_addons_filter_get_post_date', get_the_date('M'));

$post_format = str_replace('post-format-', '', get_post_format());

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($alisha_williams_post_format) ); ?>
	<?php echo (!alisha_williams_is_off($alisha_williams_animation) ? ' data-animation="'.esc_attr(alisha_williams_get_animation_classes($alisha_williams_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}
	if ( has_post_thumbnail() ) {
	?>
	<div class="post_featured_content">
	<?php
	// Featured image
	alisha_williams_show_post_featured(array( 'thumb_size' => alisha_williams_get_thumb_size( strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	?>
	<div class="post_featured_date">
		<div class="post_featured_date_container">
			<div class="post_featured_date_day"><?php echo esc_attr($post_date_day) ?></div>
			<div class="post_featured_date_month"><?php echo esc_attr($post_date_month) ?></div>
		</div>
	</div></div>
	<?php
	}

	if ( !has_post_thumbnail() && in_array($post_format, array('gallery', 'audio', 'video'))) {
		// Featured image
		alisha_williams_show_post_featured(array( 'thumb_size' => alisha_williams_get_thumb_size( strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));
	}


	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header">
			<?php
			do_action('alisha_williams_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action('alisha_williams_action_before_post_meta'); 

			// Post meta
			alisha_williams_show_post_meta(array(
				'categories' => true,
				'date' => false,
				'edit' => false,
				'seo' => false,
				'share' => false,
				'counters' => 'comments'	//comments,likes,views - comma separated in any combination
				)
			);
			?>
		</div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (alisha_williams_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'alisha-williams' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'alisha-williams' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$alisha_williams_show_learn_more = !in_array($alisha_williams_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($alisha_williams_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($alisha_williams_post_format == 'quote') {
					if (($quote = alisha_williams_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						alisha_williams_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php
			// More button
			if ( $alisha_williams_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'alisha-williams'); ?></a></p><?php
			}

		}
	?></div><!-- .entry-content -->
</article>