<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

$alisha_williams_blog_style = explode('_', alisha_williams_get_theme_option('blog_style'));
$alisha_williams_columns = empty($alisha_williams_blog_style[1]) ? 2 : max(2, $alisha_williams_blog_style[1]);
$alisha_williams_expanded = !alisha_williams_sidebar_present() && alisha_williams_is_on(alisha_williams_get_theme_option('expand_content'));
$alisha_williams_post_format = get_post_format();
$alisha_williams_post_format = empty($alisha_williams_post_format) ? 'standard' : str_replace('post-format-', '', $alisha_williams_post_format);
$alisha_williams_animation = alisha_williams_get_theme_option('blog_animation');
$post_date_day  = apply_filters('trx_addons_filter_get_post_date', get_the_date('d'));
$post_date_month  = apply_filters('trx_addons_filter_get_post_date', get_the_date('M'));
$post_format = str_replace('post-format-', '', get_post_format());

?><div class="<?php alisha_williams_show_layout($alisha_williams_blog_style[0] == 'classic' ? 'column' : 'masonry_item masonry_item'); ?>-1_<?php echo esc_attr($alisha_williams_columns); ?>"><article id="post-<?php the_ID(); ?>"
	<?php post_class( 'post_item post_format_'.esc_attr($alisha_williams_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($alisha_williams_columns)
					. ' post_layout_'.esc_attr($alisha_williams_blog_style[0]) 
					. ' post_layout_'.esc_attr($alisha_williams_blog_style[0]).'_'.esc_attr($alisha_williams_columns)
					); ?>
	<?php echo (!alisha_williams_is_off($alisha_williams_animation) ? ' data-animation="'.esc_attr(alisha_williams_get_animation_classes($alisha_williams_animation)).'"' : ''); ?>><div class="post_classic_container">
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}
	if ( has_post_thumbnail() ) {
	?>
	<div class="post_featured_content">
	<?php
	// Featured image
	alisha_williams_show_post_featured( array( 'thumb_size' => alisha_williams_get_thumb_size($alisha_williams_blog_style[0] == 'classic'
													? (strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false 
															? ( $alisha_williams_columns > 2 ? 'big' : 'huge' )
															: (	$alisha_williams_columns > 2
																? ($alisha_williams_expanded ? 'med' : 'small')
																: ($alisha_williams_expanded ? 'big' : 'med')
																)
														)
													: (strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false 
															? ( $alisha_williams_columns > 2 ? 'masonry-big' : 'full' )
															: (	$alisha_williams_columns <= 2 && $alisha_williams_expanded ? 'masonry-big' : 'masonry')
														)
								) ) );
	?>
	<div class="post_featured_date">
		<div class="post_featured_date_container">
			<div class="post_featured_date_day"><?php echo esc_attr($post_date_day) ?></div>
			<div class="post_featured_date_month"><?php echo esc_attr($post_date_month) ?></div>
		</div>
	</div></div>
	<?php
	}
	if ( !has_post_thumbnail() && in_array($post_format, array('gallery', 'audio', 'video'))) {
		// Featured image
		alisha_williams_show_post_featured(array( 'thumb_size' => alisha_williams_get_thumb_size( strpos(alisha_williams_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));
	}
	if ( !in_array($alisha_williams_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('alisha_williams_action_before_post_meta'); 

			// Post meta
			alisha_williams_show_post_meta(array(
				'categories' => true,
				'date' => false,
				'edit' => false,
				'seo' => false,
				'share' => false,
				'counters' => 'comments',
				)
			);

			do_action('alisha_williams_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$alisha_williams_show_learn_more = true;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($alisha_williams_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($alisha_williams_post_format == 'quote') {
				if (($quote = alisha_williams_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					alisha_williams_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($alisha_williams_post_format, array('link', 'aside', 'status', 'quote'))) {
			alisha_williams_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $alisha_williams_show_learn_more ) {
			?><p><a class="sc_button sc_button_underline sc_button_size_normal" href="<?php the_permalink(); ?>"><?php esc_html_e('Learn More', 'alisha-williams'); ?></a></p><?php
		}
		?>
	</div></div><!-- .entry-content -->

</article></div>