<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage ALISHA_WILLIAMS
 * @since ALISHA_WILLIAMS 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WPBakery Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$alisha_williams_content = '';
$alisha_williams_blog_archive_mask = '%%CONTENT%%';
$alisha_williams_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $alisha_williams_blog_archive_mask);
if ( have_posts() ) {
	the_post(); 
	if (($alisha_williams_content = apply_filters('the_content', get_the_content())) != '') {
		if (($alisha_williams_pos = strpos($alisha_williams_content, $alisha_williams_blog_archive_mask)) !== false) {
			$alisha_williams_content = preg_replace('/(\<p\>\s*)?'.$alisha_williams_blog_archive_mask.'(\s*\<\/p\>)/i', $alisha_williams_blog_archive_subst, $alisha_williams_content);
		} else
			$alisha_williams_content .= $alisha_williams_blog_archive_subst;
		$alisha_williams_content = explode($alisha_williams_blog_archive_mask, $alisha_williams_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) alisha_williams_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$alisha_williams_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$alisha_williams_args = alisha_williams_query_add_posts_and_cats($alisha_williams_args, '', alisha_williams_get_theme_option('post_type'), alisha_williams_get_theme_option('parent_cat'));
$alisha_williams_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($alisha_williams_page_number > 1) {
	$alisha_williams_args['paged'] = $alisha_williams_page_number;
	$alisha_williams_args['ignore_sticky_posts'] = true;
}
$alisha_williams_ppp = alisha_williams_get_theme_option('posts_per_page');
if ((int) $alisha_williams_ppp != 0)
	$alisha_williams_args['posts_per_page'] = (int) $alisha_williams_ppp;
// Make a new query
query_posts( $alisha_williams_args );
// Set a new query as main WP Query
$GLOBALS['wp_the_query'] = $GLOBALS['wp_query'];

// Set query vars in the new query!
if (is_array($alisha_williams_content) && count($alisha_williams_content) == 2) {
	set_query_var('blog_archive_start', $alisha_williams_content[0]);
	set_query_var('blog_archive_end', $alisha_williams_content[1]);
}

get_template_part('index');
?>