/*!
* Scrollbox v4.0.0
* (c) 2013-2017, Max Invis1ble
* Licensed under MIT (https://opensource.org/licenses/mit-license.php)
*/
function _classCallCheck(a,b){if(!(a instanceof b))throw new TypeError("Cannot call a class as a function")}var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a},Scrollbox=function(a){var b="scrollbox",c="4.0.0",d=b,e=a.fn[b],f={OVERFLOWED:b+"-overflowed",RAIL:b+"-rail",BAR:b+"-bar",HORIZONTAL_RAIL:b+"-horizontal-rail",VERTICAL_RAIL:b+"-vertical-rail",HORIZONTAL_BAR:b+"-horizontal-bar",VERTICAL_BAR:b+"-vertical-bar",WRAPPER:b+"-wrapper",RAIL_SHOWN:b+"-rail-in",BAR_SHOWN:b+"-bar-in",BAR_CAPTURED:b+"-bar-captured"},g={LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom"},h={distanceToReach:{x:0,y:0},wheelSensitivity:20,momentum:{acceleration:1600,thresholdTime:500},startAt:{x:g.LEFT,y:g.TOP},templates:{horizontalBar:"<div></div>",verticalBar:"<div></div>",horizontalRail:"<div></div>",verticalRail:"<div></div>",wrapper:"<div></div>"}},i={REACH_LEFT:"reach"+g.LEFT+"."+b,REACH_RIGHT:"reach"+g.RIGHT+"."+b,REACH_TOP:"reach"+g.TOP+"."+b,REACH_BOTTOM:"reach"+g.BOTTOM+"."+b},j=function(){function b(c,d){_classCallCheck(this,b),this._config=d,this._$element=a(c),this._$horizontalRail=a(d.templates.horizontalRail).addClass(f.RAIL+" "+f.HORIZONTAL_RAIL),this._$verticalRail=a(d.templates.verticalRail).addClass(f.RAIL+" "+f.VERTICAL_RAIL),this._$horizontalBar=a(d.templates.horizontalBar).addClass(f.BAR+" "+f.HORIZONTAL_BAR),this._$verticalBar=a(d.templates.verticalBar).addClass(f.BAR+" "+f.VERTICAL_BAR),this._syncElementSize(),this._isHorizontalBarCaptured=!1,this._isVerticalBarCaptured=!1,this._horizontalBarTouchId=null,this._verticalBarTouchId=null,this._elementTouchId=null,this._previousPosition={x:null,y:null},this._swipeStartPosition={x:null,y:null},this._swipeStartedAt=null,this._hasCommonListeners=!1,this._init()}return b.getVersion=function(){return c},b.getDefault=function(){return h},b.prototype.scrollTo=function(a,b,c){g.LEFT===a?a=0:g.RIGHT===a?a=this._maxScrollLeft:void 0===a&&(a=this._currentPosition.x),g.TOP===b?b=0:g.BOTTOM===b?b=this._maxScrollTop:void 0===b&&(b=this._currentPosition.y),this.scrollBy(a-this._currentPosition.x,b-this._currentPosition.y,c)},b.prototype.scrollBy=function(a,b,c){var d=this;if(void 0===a&&(a=0),void 0===b&&(b=0),0===a&&0===b)return void this._checkIsReached();var e=this._currentPosition.x+a,f=this._currentPosition.y+b,g=void 0,h=void 0;return this._$element.stop(!0,!1),g=e>=this._maxScrollLeft?this._maxScrollLeft:e<=0?0:e,h=f>=this._maxScrollTop?this._maxScrollTop:f<=0?0:f,void 0===c?(this._$element.scrollLeft(g),this._$element.scrollTop(h),void(this._currentPosition={x:g,y:h})):(c.progress=function(a){(null===d._currentPosition||g!==e&&g===d._currentPosition.x&&h!==f&&h===d._currentPosition.y)&&a.stop()},void this._$element.animate({scrollLeft:e,scrollTop:f},c))},b.prototype.update=function(){this._sync(),this._checkIsReached()},b.prototype.destroy=function(){this._hasCommonListeners&&this._removeCommonListeners(),this._$element.removeClass(f.OVERFLOWED).unwrap().removeData(d),this._$horizontalRail.remove(),this._$horizontalBar.remove(),this._$verticalRail.remove(),this._$verticalBar.remove(),this._config=null,this._$horizontalRail=null,this._$horizontalBar=null,this._$verticalRail=null,this._$verticalBar=null,this._$wrapper=null,this._previousPosition=null,this._currentPosition=null,this._swipeStartPosition=null,this._swipeStartedAt=null,this._isReachEventTriggered=null,this._hasCommonListeners=null,this._elementOuterWidth=null,this._elementOuterHeight=null,this._maxScrollLeft=null,this._maxScrollTop=null},b.prototype._init=function(){this._$wrapper=this._$element.addClass(f.OVERFLOWED).wrap(this._config.templates.wrapper).parent().addClass(f.WRAPPER).append(this._$horizontalRail).append(this._$horizontalBar).append(this._$verticalRail).append(this._$verticalBar),this._syncCurrentPosition(),this._sync(),this.scrollTo(this._config.startAt.x,this._config.startAt.y)},b.prototype._sync=function(){var a,b=this._elementOuterWidth<this._$element[0].scrollWidth,c=this._elementOuterHeight<this._$element[0].scrollHeight,d=this._$horizontalBar.hasClass(f.BAR_SHOWN),e=this._$verticalBar.hasClass(f.BAR_SHOWN);this._syncElementSize(),this._maxScrollLeft=this._$element[0].scrollWidth-this._elementOuterWidth,this._maxScrollTop=this._$element[0].scrollHeight-this._elementOuterHeight,this._$horizontalRail.width(this._elementOuterWidth),this._$verticalRail.height(this._elementOuterHeight),b?(this._updateHorizontalBarSize(),this._updateHorizontalBarPosition(),d||(this._addListenersToHorizontalScroll(),this._$horizontalBar.addClass(f.BAR_SHOWN),this._$horizontalRail.addClass(f.RAIL_SHOWN))):d&&(this._removeListenersFromHorizontalScroll(),this._$horizontalBar.removeClass(f.BAR_SHOWN),this._$horizontalRail.removeClass(f.RAIL_SHOWN)),c?(this._updateVerticalBarSize(),this._updateVerticalBarPosition(),e||(this._addListenersToVerticalScroll(),this._$verticalBar.addClass(f.BAR_SHOWN),this._$verticalRail.addClass(f.RAIL_SHOWN))):e&&(this._removeListenersFromVerticalScroll(),this._$verticalBar.removeClass(f.BAR_SHOWN),this._$verticalRail.removeClass(f.RAIL_SHOWN)),!this._hasCommonListeners&&b&&!d||c&&!e?this._addCommonListeners():this._hasCommonListeners&&!b&&d&&!c&&e&&this._removeCommonListeners(),this._isReachEventTriggered=(a={},a[g.LEFT]=!1,a[g.RIGHT]=!1,a[g.TOP]=!1,a[g.BOTTOM]=!1,a)},b.prototype._addCommonListeners=function(){this._$wrapper.on("mousewheel",a.proxy(this,"_onWheel")),this._$element.on({scroll:a.proxy(this,"_onElementScroll"),touchstart:a.proxy(this,"_onElementTouchStart"),touchmove:a.proxy(this,"_onElementTouchMove"),touchend:a.proxy(this,"_onElementTouchEnd")}),a(document).on({mouseup:a.proxy(this,"_onDocumentMouseUp"),mousemove:a.proxy(this,"_onDocumentMouseMove")}),this._hasCommonListeners=!0},b.prototype._addListenersToHorizontalScroll=function(){this._$horizontalBar.on({mousedown:a.proxy(this,"_onHorizontalBarMouseDown"),touchstart:a.proxy(this,"_onHorizontalBarTouchStart"),touchmove:a.proxy(this,"_onHorizontalBarTouchMove"),touchend:a.proxy(this,"_onHorizontalBarTouchEnd")})},b.prototype._addListenersToVerticalScroll=function(){this._$verticalBar.on({mousedown:a.proxy(this,"_onVerticalBarMouseDown"),touchstart:a.proxy(this,"_onVerticalBarTouchStart"),touchmove:a.proxy(this,"_onVerticalBarTouchMove"),touchend:a.proxy(this,"_onVerticalBarTouchEnd")})},b.prototype._removeCommonListeners=function(){this._$wrapper.off("mousewheel",this._onWheel),this._$element.off({scroll:this._onElementScroll,touchstart:this._onElementTouchStart,touchmove:this._onElementTouchMove,touchend:this._onElementTouchEnd}),a(document).off({mouseup:this._onDocumentMouseUp,mousemove:this._onDocumentMouseMove}),this._hasCommonListeners=!1},b.prototype._removeListenersFromHorizontalScroll=function(){this._$horizontalBar.off({mousedown:this._onHorizontalBarMouseDown,touchstart:this._onHorizontalBarTouchStart,touchmove:this._onHorizontalBarTouchMove,touchend:this._onHorizontalBarTouchEnd})},b.prototype._removeListenersFromVerticalScroll=function(){this._$verticalBar.off({mousedown:this._onVerticalBarMouseDown,touchstart:this._onVerticalBarTouchStart,touchmove:this._onVerticalBarTouchMove,touchend:this._onVerticalBarTouchEnd})},b.prototype._onElementScroll=function(a){a.preventDefault(),this._syncCurrentPosition(),this._updateHorizontalBarPosition(),this._updateVerticalBarPosition(),this._checkIsReached()},b.prototype._onElementTouchStart=function(a){var b=a.originalEvent.targetTouches;b.length&&(this._$element.is(":animated")&&this._$element.stop(!0,!1),this._elementTouchId=b[0].identifier,this._swipeStartPosition={x:b[0].pageX,y:b[0].pageY},this._previousPosition={x:b[0].pageX,y:b[0].pageY},this._swipeStartedAt=Date.now())},b.prototype._onWheel=function(a){a.preventDefault(),this.scrollBy(-a.deltaX*this._config.wheelSensitivity,-a.deltaY*this._config.wheelSensitivity)},b.prototype._onHorizontalBarMouseDown=function(a){1===a.which&&(a.preventDefault(),this._captureHorizontalBar(a.pageX))},b.prototype._onVerticalBarMouseDown=function(a){1===a.which&&(a.preventDefault(),this._captureVerticalBar(a.pageY))},b.prototype._onDocumentMouseMove=function(a){this._isHorizontalBarCaptured&&(a.preventDefault(),this._dragToX(a.pageX)),this._isVerticalBarCaptured&&(a.preventDefault(),this._dragToY(a.pageY))},b.prototype._onDocumentMouseUp=function(a){(this._isHorizontalBarCaptured||this._isVerticalBarCaptured)&&1===a.which&&(a.preventDefault(),this._releaseHorizontalBar(),this._releaseVerticalBar())},b.prototype._onHorizontalBarTouchStart=function(a){var b=a.originalEvent.targetTouches;b.length&&(a.preventDefault(),this._horizontalBarTouchId=b[0].identifier,this._captureHorizontalBar(b[0].pageX))},b.prototype._onVerticalBarTouchStart=function(a){var b=a.originalEvent.targetTouches;b.length&&(a.preventDefault(),this._verticalBarTouchId=b[0].identifier,this._captureVerticalBar(b[0].pageY))},b.prototype._onElementTouchMove=function(b){var c=this;a.each(b.originalEvent.targetTouches,function(a,d){if(d.identifier===c._elementTouchId)return b.preventDefault(),c._swipe(d.pageX,d.pageY),!1})},b.prototype._onHorizontalBarTouchMove=function(b){var c=this;a.each(b.originalEvent.targetTouches,function(a,d){if(d.identifier===c._horizontalBarTouchId)return b.preventDefault(),c._dragToX(d.pageX),!1})},b.prototype._onVerticalBarTouchMove=function(b){var c=this;a.each(b.originalEvent.targetTouches,function(a,d){if(d.identifier===c._verticalBarTouchId)return b.preventDefault(),c._dragToY(d.pageY),!1})},b.prototype._onElementTouchEnd=function(b){var c=this;a.each(b.originalEvent.changedTouches,function(a,b){if(b.identifier===c._elementTouchId){var d=Date.now()-c._swipeStartedAt;if(d<=c._config.momentum.thresholdTime){var e=c._swipeStartPosition.x-b.pageX,f=c._swipeStartPosition.y-b.pageY,g=Math.abs(e/d),h=Math.abs(f/d),i=g*g*2*c._config.momentum.acceleration,j=h*h*2*c._config.momentum.acceleration;e<0&&(i*=-1),f<0&&(j*=-1),c.scrollBy(i,j,{duration:Math.max(g*c._config.momentum.acceleration,h*c._config.momentum.acceleration),easing:"momentum"})}return c._swipeStartPosition={x:null,y:null},c._elementTouchId=null,c._swipeStartedAt=null,!1}})},b.prototype._onHorizontalBarTouchEnd=function(b){var c=this;a.each(b.originalEvent.changedTouches,function(a,d){if(d.identifier===c._horizontalBarTouchId)return b.preventDefault(),c._releaseHorizontalBar(),c._horizontalBarTouchId=null,!1})},b.prototype._onVerticalBarTouchEnd=function(b){var c=this;a.each(b.originalEvent.changedTouches,function(a,d){if(d.identifier===c._verticalBarTouchId)return b.preventDefault(),c._releaseVerticalBar(),c._verticalBarTouchId=null,!1})},b.prototype._onDocumentTouchEnd=function(b){var c=this,d=b.originalEvent.changedTouches;null!==this._horizontalBarTouchId&&a.each(d,function(a,d){if(d.identifier===c._horizontalBarTouchId)return b.preventDefault(),c._releaseHorizontalBar(),c._horizontalBarTouchId=null,!1}),null!==this._verticalBarTouchId&&a.each(d,function(a,d){if(d.identifier===c._verticalBarTouchId)return b.preventDefault(),c._releaseVerticalBar(),c._verticalBarTouchId=null,!1})},b.prototype._captureHorizontalBar=function(a){this._isHorizontalBarCaptured=!0,this._previousPosition.x=a,this._$horizontalBar.addClass(f.BAR_CAPTURED)},b.prototype._captureVerticalBar=function(a){this._isVerticalBarCaptured=!0,this._previousPosition.y=a,this._$verticalBar.addClass(f.BAR_CAPTURED)},b.prototype._dragToX=function(a){this.scrollBy((a-this._previousPosition.x)*this._maxScrollLeft/(this._elementOuterWidth-this._horizontalBarWidth),0),this._previousPosition.x=a},b.prototype._dragToY=function(a){this.scrollBy(0,(a-this._previousPosition.y)*this._maxScrollTop/(this._elementOuterHeight-this._verticalBarHeight)),this._previousPosition.y=a},b.prototype._swipe=function(a,b){this.scrollBy(this._previousPosition.x-a,this._previousPosition.y-b),this._previousPosition={x:a,y:b}},b.prototype._releaseHorizontalBar=function(){this._isHorizontalBarCaptured=!1,this._$horizontalBar.removeClass(f.BAR_CAPTURED)},b.prototype._releaseVerticalBar=function(){this._isVerticalBarCaptured=!1,this._$verticalBar.removeClass(f.BAR_CAPTURED)},b.prototype._updateHorizontalBarSize=function(){this._$horizontalBar.width(this._elementOuterWidth*this._elementOuterWidth/this._$element[0].scrollWidth),this._horizontalBarWidth=this._$horizontalBar.outerWidth()},b.prototype._updateVerticalBarSize=function(){this._$verticalBar.height(this._elementOuterHeight*this._elementOuterHeight/this._$element[0].scrollHeight),this._verticalBarHeight=this._$verticalBar.outerHeight()},b.prototype._updateHorizontalBarPosition=function(){this._$horizontalBar.css("left",(this._elementOuterWidth-this._horizontalBarWidth)*(this._currentPosition.x/this._maxScrollLeft))},b.prototype._updateVerticalBarPosition=function(){this._$verticalBar.css("top",(this._elementOuterHeight-this._verticalBarHeight)*(this._currentPosition.y/this._maxScrollTop))},b.prototype._checkIsReached=function(){!this._isReachEventTriggered[g.LEFT]&&this._currentPosition.x-this._config.distanceToReach.x<=0&&(this._$element.trigger(i.REACH_LEFT),this._isReachEventTriggered[g.LEFT]=!0),!this._isReachEventTriggered[g.RIGHT]&&this._currentPosition.x+this._config.distanceToReach.x>=this._maxScrollLeft&&(this._$element.trigger(i.REACH_RIGHT),this._isReachEventTriggered[g.RIGHT]=!0),!this._isReachEventTriggered[g.TOP]&&this._currentPosition.y-this._config.distanceToReach.y<=0&&(this._$element.trigger(i.REACH_TOP),this._isReachEventTriggered[g.TOP]=!0),!this._isReachEventTriggered[g.BOTTOM]&&this._currentPosition.y+this._config.distanceToReach.y>=this._maxScrollTop&&(this._$element.trigger(i.REACH_BOTTOM),this._isReachEventTriggered[g.BOTTOM]=!0)},b.prototype._syncElementSize=function(){this._elementOuterWidth=this._$element.outerWidth(),this._elementOuterHeight=this._$element.outerHeight()},b.prototype._syncCurrentPosition=function(){this._currentPosition={x:this._$element.scrollLeft(),y:this._$element.scrollTop()}},b._jQueryInterface=function(c){for(var e=this,f=arguments.length,g=Array(f>1?f-1:0),h=1;h<f;h++)g[h-1]=arguments[h];return this.each(function(){var f=a(e),h=f.data(d);if(h||(h=new b(e,a.extend(!0,{},b.getDefault(),f.data(),"object"===(void 0===c?"undefined":_typeof(c))&&c)),f.data(d,h)),"string"==typeof c){var i;if("function"!=typeof h[c])throw Error('No method named "'+c+'"');(i=h)[c].apply(i,g)}})},b}();return a.fn[b]=j._jQueryInterface,a.fn[b].Constructor=j,a.fn[b].noConflict=function(){return a.fn[b]=e,j._jQueryInterface},a.easing.momentum||(a.easing.momentum=function(a,b,c,d,e){return b==e?c+d:d*(-Math.pow(2,-10*b/e)+1)+c}),j}(jQuery);
//# sourceMappingURL=scrollbox.min.js.map