<?php do_action( 'airtech_before_header' ); ?>
<header class="header_area menu_four">
    <div class="top_bar">
        <div class="container">
            <div class="d-flex justify-content-between">
                <div class="left">
		        <?php if ( true == get_theme_mod( 'enable_phone4', true ) ) { ?>
						<h5>
							<i class="<?php echo wp_kses(get_theme_mod( 'phone_icon4', 'fa fa-phone' ), airtech_blv_allowed_tags()); ?>"></i>
							<?php echo wp_kses(get_theme_mod( 'phone_title4', '' ), airtech_blv_allowed_tags()); ?>
							<a href="<?php echo esc_url(get_theme_mod( 'phone_link4', '' )); ?>">
								<?php echo wp_kses(get_theme_mod( 'phone_label4', '' ), airtech_blv_allowed_tags()); ?>
							</a>
						</h5>
					</div>
		        <?php } ?>
				<div class="right">
					<?php echo do_shortcode( wp_kses_post(get_theme_mod('right_content4'))); ?>
				</div>
            </div>
        </div>
    </div>
    <div class="main_menu">
        <div class="container">
			<nav class="navbar navbar-expand-lg navbar-light bg-light">
                <!-- Logo -->
                <?php if ( true == get_theme_mod( 'cust_logo', true ) ) {
					echo airtech_logo( array('2','logo2') );
                } else { ?>
                <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
				<?php } ?>
				<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php esc_html_e( 'Toggle navigation', 'airtech' ); ?>">
					<span></span>
				</button>
				<div class="collapse navbar-collapse" id="navbarSupportedContent">
					<!-- The WordPress Menu goes here -->
				    <?php
		            if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'primary-menu' ) ) {
	                wp_nav_menu(
	                array(
	                    'depth'             => 3,
	                    'theme_location'    => 'primary-menu',
	                    'container'         => false,
	                    'menu_class'        => 'nav navbar-nav ml-auto',
	                    'fallback_cb'       => '',
	                    'menu_id'           => '',
						'walker'            => new Airtech_WP_Bootstrap_Navwalker(),
		                ) );
		            } else {
		                esc_html_e( 'Please assign primary menu in wp-admin->Appearance->Menus', 'airtech' );
		            } ?>
	                <?php if ( true == get_theme_mod( 'enable_search4', true ) ) { ?>
						<ul class="nav navbar-nav navbar-right">
							<li class="search"><a class="popup-with-zoom-anim" href="#hdr-search"><i class="icon icon-Search"></i></a></li>
						</ul>
	                <?php } ?>
				</div>
			</nav>
		</div>
    </div>
</header>