<?php do_action( 'airtech_before_header' ); ?>
<header class="header_area menu_three">
    <div class="contact_info">
        <div class="container">
            <div class="info_inner d-flex justify-content-end">
		        <?php if ( true == get_theme_mod( 'enable_emergency3', true ) ) { ?>
			        <a href="<?php echo esc_url(get_theme_mod( 'emergency_phone_link3', '' )); ?>">
				        <?php $emergency_img = get_theme_mod( 'phone_img3', '' );
				              if( is_array($emergency_img) ) {
					              if ( is_ssl() ) { $emergency_img['url'] = str_replace( 'http://', 'https://', $emergency_img['url'] ); }
				        ?>
	                    <img src="<?php echo esc_url($emergency_img['url']); ?>" <?php echo airtech_fw_img_alt($emergency_img['id']); ?> />
					    <?php } ?>
				        <?php echo wp_kses(get_theme_mod( 'emergency_ph_title3', '' ), airtech_blv_allowed_tags()); ?>
			        </a>
		        <?php } ?>
		        <?php if ( true == get_theme_mod( 'enable_email3', true ) ) { ?>
			        <a href="<?php echo esc_url(get_theme_mod( 'email_link3', '' )); ?>">
				        <?php $emergency_img = get_theme_mod( 'email_img3', '' );
				              if( is_array($emergency_img) ) {
					              if ( is_ssl() ) { $emergency_img['url'] = str_replace( 'http://', 'https://', $emergency_img['url'] ); }
				        ?>
	                    <img src="<?php echo esc_url($emergency_img['url']); ?>" <?php echo airtech_fw_img_alt($emergency_img['id']); ?> />
					    <?php } ?>
				        <?php echo wp_kses(get_theme_mod( 'email_title3', '' ), airtech_blv_allowed_tags()); ?>
			        </a>
		        <?php } ?>
		        <?php if ( true == get_theme_mod( 'enable_apmt3', true ) ) { ?>
			        <a href="<?php echo esc_url(get_theme_mod( 'appntm_link3', '' )); ?>">
				        <?php $emergency_img = get_theme_mod( 'appntm_img3', '' );
				              if( is_array($emergency_img) ) {
					              if ( is_ssl() ) { $emergency_img['url'] = str_replace( 'http://', 'https://', $emergency_img['url'] ); }
				        ?>
	                    <img src="<?php echo esc_url($emergency_img['url']); ?>" <?php echo airtech_fw_img_alt($emergency_img['id']); ?> />
					    <?php } ?>
				        <?php echo wp_kses(get_theme_mod( 'appntm_title3', '' ), airtech_blv_allowed_tags()); ?>
			        </a>
		        <?php } ?>
            </div>
        </div>
    </div>
    <div class="main_menu">
        <div class="container">
			<nav class="navbar navbar-expand-lg navbar-light bg-light">
                <!-- Logo -->
                <?php if ( true == get_theme_mod( 'cust_logo', true ) ) {
					echo airtech_logo( array('2','logo2') );
                } else { ?>
                <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a>
				<?php } ?>
				<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php esc_html_e( 'Toggle navigation', 'airtech' ); ?>">
					<span></span>
				</button>
				<div class="collapse navbar-collapse" id="navbarSupportedContent">
					<!-- The WordPress Menu goes here -->
				    <?php
		            if ( function_exists( 'has_nav_menu' ) && has_nav_menu( 'primary-menu' ) ) {
	                wp_nav_menu(
	                array(
	                    'depth'             => 3,
	                    'theme_location'    => 'primary-menu',
	                    'container'         => false,
	                    'menu_class'        => 'nav navbar-nav ml-auto',
	                    'fallback_cb'       => '',
	                    'menu_id'           => '',
						'walker'            => new Airtech_WP_Bootstrap_Navwalker(),
		                ) );
		            } else {
		                esc_html_e( 'Please assign primary menu in wp-admin->Appearance->Menus', 'airtech' );
		            } ?>
	                <?php if ( true == get_theme_mod( 'enable_search3', true ) ) { ?>
						<ul class="nav navbar-nav navbar-right">
							<li class="search"><a class="popup-with-zoom-anim" href="#hdr-search"><i class="icon icon-Search"></i></a></li>
						</ul>
	                <?php } ?>
				</div>
			</nav>
		</div>
    </div>
</header>