<?php
/*
 * Template file for posts shortcode.
 * $temptt_t_vars is an array of custom parameters set for given post shortcode.
 */
$spl_field1 = $spl_field2 = $spl_field3 = '';
$temptt_spl_vars2 = json_decode($temptt_t_vars['temptt_var1'], true);
if( !empty($temptt_spl_vars2) ) {
	extract( $temptt_spl_vars2 );
}
?>

<section class="main_service_area pad_top">
    <div class="container">
        <div class="main_title">
            <h2><?php echo wp_kses($spl_field1, airtech_blv_allowed_tags()); ?></h2>
            <p><?php echo wp_kses($spl_field2, airtech_blv_allowed_tags()); ?></p>
        </div>

        <div class="row main_service_inner">
	<?php
		// Posts are found
		if ( $posts->have_posts() ) {
			while ( $posts->have_posts() ) :
				$posts->the_post();
				global $post;
				?>

            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="m_service_item">
	                <?php if ( has_post_thumbnail() ) : ?>
                    <div class="service_img">
	                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail();?>
		                </a>
                    </div>
					<?php endif; ?>
                    <div class="service_text">
                        <?php the_title( '<h4 class="entry-title">', '</h4>' );?>
                        <p><?php airtech_excerpt_charlength('80'); ?></p>
                        <a class="more_btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'airtech'); ?></a>
                    </div>
                </div>
            </div>

				<?php
			endwhile;
		}
		// Posts not found
		else {
			echo '<h4>' . __( 'Posts not found', 'airtech' ) . '</h4>';
		}
	?>
        </div>
    </div>
</section>
