<?php
/**
 * Airtech WooCommerce hooks
 *
 * @package airtech
 */

/**
 * Sidebar
 *
 */
add_action( 'airtech_shop_sidebar', 'airtech_get_shop_sidebar', 10 );
add_action( 'airtech_product_sidebar', 'airtech_get_product_sidebar', 10 );

/**
 * Homepage
 *
 * @see  airtech_product_categories()
 * @see  airtech_recent_products()
 * @see  airtech_featured_products()
 * @see  airtech_popular_products()
 * @see  airtech_on_sale_products()
 * @see  airtech_best_selling_products()
 */
add_action( 'homepage', 'airtech_product_categories', 20 );
add_action( 'homepage', 'airtech_recent_products', 30 );
add_action( 'homepage', 'airtech_featured_products', 40 );
add_action( 'homepage', 'airtech_popular_products', 50 );
add_action( 'homepage', 'airtech_on_sale_products', 60 );
add_action( 'homepage', 'airtech_best_selling_products', 70 );

/**
 * Layout
 *
 * @see  airtech_before_content()
 * @see  airtech_after_content()
 * @see  woocommerce_breadcrumb()
 * @see  airtech_shop_messages()
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
add_action( 'woocommerce_before_main_content', 'airtech_before_content', 10 );
add_action( 'woocommerce_after_main_content', 'airtech_after_content', 10 );
add_action( 'airtech_content_top', 'airtech_shop_messages', 15 );

add_action( 'woocommerce_after_shop_loop', 'airtech_sorting_wrapper', 9 );
add_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 30 );
add_action( 'woocommerce_after_shop_loop', 'airtech_sorting_wrapper_close', 31 );

add_action( 'woocommerce_before_shop_loop', 'airtech_sorting_wrapper', 9 );
add_action( 'woocommerce_before_shop_loop', 'airtech_sorting_wrapper_close', 31 );


// Legacy WooCommerce columns filter.
if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '3.3', '<' ) ) {
	add_filter( 'loop_shop_columns', 'airtech_loop_columns' );
	add_action( 'woocommerce_before_shop_loop', 'airtech_product_columns_wrapper', 40 );
	add_action( 'woocommerce_after_shop_loop', 'airtech_product_columns_wrapper_close', 40 );
}

/**
 * Products
 *
 * @see airtech_upsell_display()
 */
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
add_action( 'woocommerce_after_single_product_summary', 'airtech_upsell_display', 15 );


add_action( 'woocommerce_after_single_product_summary', 'airtech_single_product_pagination', 30 );
add_action( 'airtech_after_footer', 'airtech_sticky_single_add_to_cart', 999 );

/**
 * Header
 *
 * @see airtech_product_search()
 * @see airtech_header_cart()
 */

/**
 * Cart fragment
 *
 * @see airtech_cart_link_fragment()
 */
if ( defined( 'WC_VERSION' ) && version_compare( WC_VERSION, '2.3', '>=' ) ) {
	add_filter( 'woocommerce_add_to_cart_fragments', 'airtech_cart_link_fragment' );
} else {
	add_filter( 'add_to_cart_fragments', 'airtech_cart_link_fragment' );
}

/**
 * Integrations
 *
 * @see airtech_woocommerce_brands_archive()
 * @see airtech_woocommerce_brands_single()
 * @see airtech_woocommerce_brands_homepage_section()
 */
if ( class_exists( 'WC_Brands' ) ) {
	add_action( 'woocommerce_archive_description', 'airtech_woocommerce_brands_archive', 5 );
	add_action( 'woocommerce_single_product_summary', 'airtech_woocommerce_brands_single', 4 );
	add_action( 'homepage', 'airtech_woocommerce_brands_homepage_section', 80 );
}
