<?php
/**
 * Airtech WooCommerce Customizer Class
 *
 * @package  airtech
 * @since    2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Airtech_WooCommerce_Customizer' ) ) :

	/**
	 * The Airtech Customizer class
	 */
	class Airtech_WooCommerce_Customizer extends Airtech_Customizer {

		/**
		 * Setup class.
		 *
		 * @since 2.4.0
		 * @return void
		 */
		public function __construct() {
			add_action( 'customize_register', array( $this, 'customize_register' ), 10 );
			add_action( 'wp_enqueue_scripts', array( $this, 'add_customizer_css' ), 130 );
			add_filter( 'airtech_setting_default_values', array( $this, 'setting_default_values' ) );
		}

		/**
		 * Returns an array of the desired default Airtech Options
		 *
		 * @param array $defaults array of default options.
		 * @since 2.4.0
		 * @return array
		 */
		public function setting_default_values( $defaults = array() ) {
			$defaults['airtech_sticky_add_to_cart'] = false;
			$defaults['airtech_product_pagination'] = false;

			return $defaults;
		}

		/**
		 * Add postMessage support for site title and description for the Theme Customizer along with several other settings.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 * @since 2.4.0
		 */
		public function customize_register( $wp_customize ) {

			/**
			 * Product Page
			 */
			$wp_customize->add_section(
				'airtech_single_product_page', array(
					'title'    => __( 'Product Page', 'airtech' ),
					'priority' => 60,
				)
			);

			$wp_customize->add_setting(
				'airtech_product_pagination', array(
					'default'           => apply_filters( 'airtech_default_product_pagination', false ),
					'sanitize_callback' => 'wp_validate_boolean',
				)
			);

			$wp_customize->add_setting(
				'airtech_sticky_add_to_cart', array(
					'default'           => apply_filters( 'airtech_default_sticky_add_to_cart', false ),
					'sanitize_callback' => 'wp_validate_boolean',
				)
			);

			$wp_customize->add_control(
				'airtech_sticky_add_to_cart', array(
					'type'        => 'checkbox',
					'section'     => 'airtech_single_product_page',
					'label'       => __( 'Sticky Add-To-Cart', 'airtech' ),
					'description' => __( 'A small content bar at the top of the browser window which includes relevant product information and an add-to-cart button. It slides into view once the standard add-to-cart button has scrolled out of view.', 'airtech' ),
					'priority'    => 10,
				)
			);

			$wp_customize->add_control(
				'airtech_product_pagination', array(
					'type'        => 'checkbox',
					'section'     => 'airtech_single_product_page',
					'label'       => __( 'Product Pagination', 'airtech' ),
					'description' => __( 'Displays next and previous links on product pages. A product thumbnail is displayed with the title revealed on hover.', 'airtech' ),
					'priority'    => 20,
				)
			);
		}

		/**
		 * Get Customizer css.
		 *
		 * @see get_airtech_theme_mods()
		 * @since 2.4.0
		 * @return string $styles the css
		 */
		public function get_css() {
			$airtech_theme_mods = $this->get_airtech_theme_mods();
			$brighten_factor       = apply_filters( 'airtech_brighten_factor', 25 );
			$darken_factor         = apply_filters( 'airtech_darken_factor', -25 );

			$styles = '

			';

			return apply_filters( 'airtech_customizer_woocommerce_css', $styles );
		}

		/**
		 * Add CSS in <head> for styles handled by the theme customizer
		 *
		 * @since 2.4.0
		 * @return void
		 */
		public function add_customizer_css() {
			wp_add_inline_style( 'airtech-woocommerce-style', $this->get_css() );
		}

	}

endif;

return new Airtech_WooCommerce_Customizer();
