<?php
/**
 * Airtech hooks
 *
 * @package airtech
 */

/**
 * General
 *
 * @see  airtech_header_widget_region()
 * @see  airtech_get_sidebar()
 */
add_action( 'airtech_before_content', 'airtech_header_widget_region', 10 );
add_action( 'airtech_before_content', 'airtech_create_sc', 12 );
add_action( 'airtech_sidebar', 'airtech_get_sidebar', 10 );

/**
 * Header ( hookable to airtech_header )s
 *
 * @see airtech_header_container                 - 0
 * @see airtech_skip_links                       - 5
 * @see airtech_social_icons                     - 10
 * @see airtech_site_branding                    - 20
 * @see airtech_secondary_navigation             - 30
 * @see airtech_product_search                   - 40
 * @see airtech_header_container_close           - 41
 * @see airtech_primary_navigation_wrapper       - 42
 * @see airtech_primary_navigation               - 50
 * @see airtech_header_cart                      - 60
 * @see airtech_primary_navigation_wrapper_close - 68
 * @see  airtech_primary_navigation()
 */
add_action( 'airtech_header', 'airtech_header_container', 0 );
add_action( 'airtech_header', 'airtech_skip_links', 5 );
add_action( 'airtech_header', 'airtech_site_branding', 20 );
add_action( 'airtech_header', 'airtech_primary_navigation', 30 );
add_action( 'airtech_header', 'airtech_header_container_close', 41 );


/**
 * Footer
 *
 * @see  airtech_footer_widgets()
 * @see  airtech_credit()
 */
add_action( 'airtech_footer', 'airtech_footer_widgets', 10 );

/**
 * Homepage
 *
 * @see  airtech_homepage_content()
 */
add_action( 'homepage', 'airtech_homepage_content', 10 );

/**
 * Posts
 *
 * @see  airtech_post_header()
 * @see  airtech_post_meta()
 * @see  airtech_post_content()
 * @see  airtech_paging_nav()
 * @see  airtech_single_post_header()
 * @see  airtech_post_nav()
 * @see  airtech_display_comments()
 */
add_action( 'airtech_loop_after', 'airtech_paging_nav', 10 );

/**
 * Pages
 *
 * @see  airtech_page_header()
 * @see  airtech_page_content()
 * @see  airtech_display_comments()
 */
add_action( 'airtech_page', 'airtech_page_content', 20 );
add_action( 'airtech_page_after', 'airtech_display_comments', 10 );

