<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* Theme Metaboxes ! */
/* Powered by metabox */
/*-----------------------------------------------------------------------------------*/


if ( defined( 'RWMB_VER' ) ) {
	add_filter( 'rwmb_meta_boxes', 'airtech_meta_boxes' );

	function airtech_meta_boxes($meta_boxes) {
		//global $meta_boxes;

		$prefix = '_blv_';

		/* Pages metaboxes starts */
		$meta_boxes[] = array(
			'id'      => 'pages_options',
			'title'   => esc_html_x( 'Page Options', 'backend', 'airtech'),
			'post_types'   => array( 'page', 'tt_project' ),
			//'context' => 'normal',
			'fields'  => array(
array(
    'name'            => 'Header type',
    'id'              => $prefix . 'single_hdr_type',
    'type'            => 'select',
	'desc'		=> esc_html_x( 'You can select particular header type for this particular page here. Default displays the header type selected in customiser instead. If you want to see available headers, please go to appearance/customiser/airtech header/general', 'backend', 'airtech'),
    // Array of 'value' => 'Label' pairs
    'options'         => array(
        'nochange'      => 'As set in Customiser',
        'default'       => 'Header1',
        'header2'       => 'Header2',
        'header3'       => 'Header3',
        'header4'       => 'Header4',
    ),
),
				array(
    'id'        => $prefix . 'enable_hero',
    'name'      => 'Enable Hero on this page?',
	'desc'		=> esc_html_x( 'Hero is the area appears below header. You can control it globally from Appearance/Customise and override that setting here. Note that if turned off globally it will not display even if you select Yes here.', 'backend', 'airtech'),
    'type'      => 'switch',
    'style'     => 'rounded',
    'std'       => '1',
    'on_label'  => esc_html_x( 'Yes', 'backend', 'airtech'),
    'off_label' => esc_html_x( 'No', 'backend', 'airtech'),
),
array(
    'id'               => $prefix . 'single_bgimage',
    'name'             => 'Background Image',
    'type'             => 'image_upload',
    'force_delete'     => false,
    'max_file_uploads' => 1,
    'max_status'       => 'false',
    'image_size'       => 'thumbnail',
),
array(
    'id'          => $prefix . 'cust_title',
    'name'        => 'Custom Title',
    'label_description' => '(Optional)',
    'desc'        => 'By default, Hero area displays page title, but you can enter custom title here if you want.',
    'type'        => 'text',
),
array(
    'id'        => $prefix . 'enable_notitle',
    'name'      => 'Enable blank title on Hero for this page?',
	'desc'		=> esc_html_x( 'For some reason you may want to keep Hero area for aesthetics but do not want Title displayed in it, if so enable this please. If you are not sure, keep it off.', 'backend', 'airtech'),
    'type'      => 'switch',
    'style'     => 'rounded',
    'std'       => '0',
    'on_label'  => esc_html_x( 'Yes', 'backend', 'airtech'),
    'off_label' => esc_html_x( 'No', 'backend', 'airtech'),
),
array(
    'id'        => $prefix . 'enable_breadcrumb',
    'name'      => 'Enable Breadcrumb on this page?',
	'desc'		=> esc_html_x( 'You can control it globally from Appearance/Customise also please note it only works if you have Breadcrumb Trail plugin active.', 'backend', 'airtech'),
    'type'      => 'switch',
    'style'     => 'rounded',
    'std'       => '1',
    'on_label'  => esc_html_x( 'Yes', 'backend', 'airtech'),
    'off_label' => esc_html_x( 'No', 'backend', 'airtech'),
),
			)
		);
		/* Pages metaboxes starts */

		/* Testimonial metaboxes starts */
		$meta_boxes[] = array(
			'id'      => 'cases_info',
			'title'   => esc_html_x( 'Additional Information', 'backend', 'airtech'),
			'post_types'   => array( 'bdthemes-cases' ),
			//'context' => 'normal',
			'fields'  => array(
				array(
					'name'		=> esc_html_x( 'Company Name/Address', 'backend', 'airtech'),
					'id'		=> $prefix . 'tm_company_name',
					'desc'		=> esc_html_x( 'Please type client company name for example: BdThemes Limited.', 'backend', 'airtech'),
					'clone'		=> false,
					'type'		=> 'text',
					'std'		=> '',
					'placeholder' => esc_html_x('Bolvo.com', 'backend', 'airtech' ),
					//'hidden' => array('bdthemes_show_faq_icon', '=', 'no'),
				),
				array(
					'name'		=> 'Rating',
					'id'		=> $prefix . "tm_rating",
					'type'		=> 'select',
					'options'	=> array(
						'1' => esc_html_x('1 Star', 'backend', 'airtech'),
						'2' => esc_html_x('2 Stars', 'backend', 'airtech'),
						'3' => esc_html_x('3 Stars', 'backend', 'airtech'),
						'4' => esc_html_x('4 Stars', 'backend', 'airtech'),
						'5' => esc_html_x('5 Stars', 'backend', 'airtech'),
					),
					'multiple' => false,
					'std'      => array( '' ),
					'desc'     => 'Select your client rating what he/she gives you.',
				),
			)
		);
		/* Testimonial metaboxes starts */

		return $meta_boxes;
	}
}