<?php
/**
 * Airtech functions.
 *
 * @package airtech
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/*-----------------------------------------------------------------------------------*/
/* Getting the ID of the page                                                     */
/*-----------------------------------------------------------------------------------*/

if( !function_exists('airtech_get_the_id') ) {
	function airtech_get_the_id() {
		global $wp_query;
		$tt_post_id = '';
		if ( is_404() || is_search() ) {
			return '';
		}
		if ( isset( $wp_query->post->ID ) ) {
			$tt_post_id = $wp_query->post->ID;
		}
		if ( is_home() ) {
			$tt_post_id = get_option( 'page_for_posts' );
		}
		if ( class_exists( 'woocommerce' ) ) {
			if ( is_shop() ) {
				$tt_post_id = get_option( 'woocommerce_shop_page_id' );
			}
			if ( is_account_page() ) {
				$tt_post_id = get_option( 'woocommerce_myaccount_page_id' );
			}
			if ( is_checkout() ) {
				$tt_post_id = get_option( 'woocommerce_checkout_page_id' );
			}
			if ( is_cart() ) {
				$tt_post_id = get_option( 'woocommerce_cart_page_id' );
			}
		}

		return $tt_post_id;

	}
}

/*-----------------------------------------------------------------------------------*/
/* Allowed tags                                                                      */
/*-----------------------------------------------------------------------------------*/

if(!( function_exists('airtech_blv_allowed_tags') )){
	function airtech_blv_allowed_tags(){
		return array(
			'time' => array(
				'datetime' => array(),
				'class'    => array(),
			),
		    'img' => array(
		        'src' => array(),
		        'alt' => array(),
		        'class' => array(),
		        'style' => array(),
		    ),
		    'a' => array(
		        'href' => array(),
		        'title' => array(),
		        'class' => array(),
		        'target' => array(),
		        'rel' => array()
		    ),
		    'i' => array(
		        'href' => array(),
		        'title' => array(),
		        'class' => array(),
		        'target' => array(),
		    ),
		    'br' => array(),
		    'div' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'span' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h1' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h2' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h3' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h4' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h5' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'h6' => array(
		        'class' => array(),
		        'style' => array(),
		    ),
		    'style' => array(),
		    'em' => array(),
		    'strong' => array(),
		    'p' => array(
		    	'class' => array(),
		        'style' => array(),
		    ),
		);
	}
}

function airtech_blv_css_allow($allowed_attr) {

    if (!is_array($allowed_attr)) {
        $allowed_attr = array();
    }

    $allowed_attr[] = 'display';
    $allowed_attr[] = 'background-image';
    $allowed_attr[] = 'url';

    return $allowed_attr;
} add_filter('safe_style_css','airtech_blv_css_allow');


/* Add Elementor support for CPT */
function airtech_add_cpt_support() {

    //if exists, assign to $cpt_support var
	$cpt_support = get_option( 'elementor_cpt_support' );

	//check if option DOESN'T exist in db
	if( ! $cpt_support ) {
	    $cpt_support = [ 'page', 'post', 'tt_project' ]; //create array of our default supported post types
	    update_option( 'elementor_cpt_support', $cpt_support ); //write it to the database
	}

	//if it DOES exist, but tt_project is NOT defined
	else if( ! in_array( 'tt_project', $cpt_support ) ) {
	    $cpt_support[] = 'tt_project'; //append to array
	    update_option( 'elementor_cpt_support', $cpt_support ); //update database
	}

	//otherwise do nothing, portfolio already exists in elementor_cpt_support option
}
add_action( 'after_switch_theme', 'airtech_add_cpt_support' );

/*-----------------------------------------------------------------------------------*/
/* Check if WC is active
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'airtech_is_woocommerce_activated' ) ) {
	/**
	 * Query WooCommerce activation
	 */
	function airtech_is_woocommerce_activated() {
		return class_exists( 'WooCommerce' ) ? true : false;
	}
}


/*-----------------------------------------------------------------------------------*/
/* Check if Elementor active on given page
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'airtech_is_elementor_page' ) ) {
	function airtech_is_elementor_page( $page_id = '' ) {

		global $post; $is_elementor_page = false;

		if( is_search() || is_archive() || is_404() ) return false; // nothing left to do.

		$page_id = ( '' != $page_id ) ? $page_id : $post->ID ;

		// Check if Elementor installed and activated
		if ( did_action( 'elementor/loaded' ) && ! empty( $page_id ) ) {
			$is_elementor_page = \Elementor\Plugin::$instance->db->is_built_with_elementor($page_id);
		}
		return $is_elementor_page;
	}
}



/*-----------------------------------------------------------------------------------*/
/* Post/page title
/*-----------------------------------------------------------------------------------*/
// returns title based on the requirement.

if (!function_exists( 'airtech_fw_post_title')) {
function airtech_fw_post_title( $tag='' ){

	global $post; $page_id = $is_elementor_page = $single_item_layout = $tt_lay_content = $tt_lay_sidebar = $single_data2 = '';
	if( empty($tag)) $tag = 'h3';

		// Check if Elementor active on this page
		$is_elementor_page = airtech_is_elementor_page($post->ID);


		/* if its fresh install and bvl framework is enabled. dont show title as it appears in hero */
		if ( !$is_elementor_page  ) {
				return '<div class="pt_100"></div>';
		}

		/* if elementor active on this page, we do not need title display */
		if ( $is_elementor_page && is_singular() ) {
				return '';
		}

	return the_title( '<header class="entry-header"><'.$tag.' class="entry-title ">', '</'.$tag.'></header>' );
}
}

/**
 * Call a shortcode function by tag name.
 *
 * @since  1.4.6
 *
 * @param string $tag     The shortcode whose function to call.
 * @param array  $atts    The attributes to pass to the shortcode function. Optional.
 * @param array  $content The shortcode's content. Default is null (none).
 *
 * @return string|bool False on failure, the result of the shortcode on success.
 */
function airtech_do_shortcode( $tag, array $atts = array(), $content = null ) {
	global $shortcode_tags;

	if ( ! isset( $shortcode_tags[ $tag ] ) ) {
		return false;
	}

	return call_user_func( $shortcode_tags[ $tag ], $atts, $content, $tag );
}

/**
 * Get the content background color
 * Accounts for the Airtech Designer and Airtech Powerpack content background option.
 *
 * @since  1.6.0
 * @return string the background color
 */
function airtech_get_content_background_color() {
	if ( class_exists( 'Airtech_Designer' ) ) {
		$content_bg_color = get_theme_mod( 'sd_content_background_color' );
		$content_frame    = get_theme_mod( 'sd_fixed_width' );
	}

	if ( class_exists( 'Airtech_Powerpack' ) ) {
		$content_bg_color = get_theme_mod( 'sp_content_frame_background' );
		$content_frame    = get_theme_mod( 'sp_content_frame' );
	}

	$bg_color = str_replace( '#', '', get_theme_mod( 'background_color' ) );

	if ( class_exists( 'Airtech_Powerpack' ) || class_exists( 'Airtech_Designer' ) ) {
		if ( $content_bg_color && ( 'true' === $content_frame || 'frame' === $content_frame ) ) {
			$bg_color = str_replace( '#', '', $content_bg_color );
		}
	}

	return '#' . $bg_color;
}

/**
 * Apply inline style to the Airtech header.
 *
 * @uses  get_header_image()
 * @since  2.0.0
 */
function airtech_header_styles() {
	$is_header_image = get_header_image();
	$header_bg_image = '';

	if ( $is_header_image ) {
		$header_bg_image = 'url(' . esc_url( $is_header_image ) . ')';
	}

	$styles = array();

	if ( '' !== $header_bg_image ) {
		$styles['background-image'] = $header_bg_image;
	}

	$styles = apply_filters( 'airtech_header_styles', $styles );

	foreach ( $styles as $style => $value ) {
		echo esc_attr( $style . ': ' . $value . '; ' );
	}
}

/**
 * Apply inline style to the Airtech homepage content.
 *
 * @uses  get_the_post_thumbnail_url()
 * @since  2.2.0
 */
function airtech_homepage_content_styles() {
	$featured_image   = get_the_post_thumbnail_url( get_the_ID() );
	$background_image = '';

	if ( $featured_image ) {
		$background_image = 'url(' . esc_url( $featured_image ) . ')';
	}

	$styles = array();

	if ( '' !== $background_image ) {
		$styles['background-image'] = $background_image;
	}

	$styles = apply_filters( 'airtech_homepage_content_styles', $styles );

	foreach ( $styles as $style => $value ) {
		echo esc_attr( $style . ': ' . $value . '; ' );
	}
}

/**
 * Adjust a hex color brightness
 * Allows us to create hover styles for custom link colors
 *
 * @param  strong  $hex   hex color e.g. #111111.
 * @param  integer $steps factor by which to brighten/darken ranging from -255 (darken) to 255 (brighten).
 * @return string        brightened/darkened hex color
 * @since  1.0.0
 */
function airtech_adjust_color_brightness( $hex, $steps ) {
	// Steps should be between -255 and 255. Negative = darker, positive = lighter.
	$steps = max( -255, min( 255, $steps ) );

	// Format the hex color string.
	$hex = str_replace( '#', '', $hex );

	if ( 3 === strlen( $hex ) ) {
		$hex = str_repeat( substr( $hex, 0, 1 ), 2 ) . str_repeat( substr( $hex, 1, 1 ), 2 ) . str_repeat( substr( $hex, 2, 1 ), 2 );
	}

	// Get decimal values.
	$r = hexdec( substr( $hex, 0, 2 ) );
	$g = hexdec( substr( $hex, 2, 2 ) );
	$b = hexdec( substr( $hex, 4, 2 ) );

	// Adjust number of steps and keep it inside 0 to 255.
	$r = max( 0, min( 255, $r + $steps ) );
	$g = max( 0, min( 255, $g + $steps ) );
	$b = max( 0, min( 255, $b + $steps ) );

	$r_hex = str_pad( dechex( $r ), 2, '0', STR_PAD_LEFT );
	$g_hex = str_pad( dechex( $g ), 2, '0', STR_PAD_LEFT );
	$b_hex = str_pad( dechex( $b ), 2, '0', STR_PAD_LEFT );

	return '#' . $r_hex . $g_hex . $b_hex;
}

/**
 * Sanitizes choices (selects / radios)
 * Checks that the input matches one of the available choices
 *
 * @param array $input the available choices.
 * @param array $setting the setting object.
 * @since  1.3.0
 */
function airtech_sanitize_choices( $input, $setting ) {
	// Ensure input is a slug.
	$input = sanitize_key( $input );

	// Get list of choices from the control associated with the setting.
	$choices = $setting->manager->get_control( $setting->id )->choices;

	// If the input is a valid key, return it; otherwise, return the default.
	return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}

/**
 * Checkbox sanitization callback.
 *
 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$checked`
 * as a boolean value, either TRUE or FALSE.
 *
 * @param bool $checked Whether the checkbox is checked.
 * @return bool Whether the checkbox is checked.
 * @since  1.5.0
 */
function airtech_sanitize_checkbox( $checked ) {
	return ( ( isset( $checked ) && true === $checked ) ? true : false );
}

/**
 * Airtech Sanitize Hex Color
 * @return null.
 * @param string $color The color as a hex.
 */
function airtech_sanitize_hex_color( $color ) {
	_deprecated_function( 'airtech_sanitize_hex_color', '2.0', 'sanitize_hex_color' );

	if ( '' === $color ) {
		return '';
	}

	// 3 or 6 hex digits, or the empty string.
	if ( preg_match( '|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
		return $color;
	}

	return null;
}


/**
 * Load custom logo.
 */
if ( ! function_exists( 'airtech_logo' ) ) {
function airtech_logo ( $args='' ) {
	$logo_url = $type = ''; $class = 'main';
	if( is_array($args) ) {
		$type   = $args['0'];
		$class  = $args['1'];
	}
	$logo_url = get_theme_mod( 'logo_url', '' );
	$logo_url2 = get_theme_mod( 'logo_url2', '' );

	if ( '2' == $type ) {
		$logo = esc_url( AIRTECH_THEME_DIRURI . 'assets/images/logo-2.png' ); // default logo from theme image folder.
	} else {
		$logo = esc_url( AIRTECH_THEME_DIRURI . 'assets/images/logo.png' ); // default logo from theme image folder.
	}
	if ( !empty( $logo_url ) ) { $logo = $logo_url ; }
	if ( ( '2' == $type ) && !empty( $logo_url2 ) ) { $logo = $logo_url2 ; }
	if ( is_ssl() ) { $logo = str_replace( 'http://', 'https://', $logo ); }
	ob_start();
?>

	<a class="logo <?php echo esc_attr($class); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'description' ) ); ?>">
		<img src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" />
	</a>
<?php
	return ob_get_clean();
} // End airtech_fw_logo()
}

/**
 * Preloader.
 */
if ( ! function_exists( 'airtech_tt_preloader' ) ) {
function airtech_tt_preloader () {

	if ( true == get_theme_mod( 'enable_preloader', true) ) {
		return '
		<div id="loader-wrapper">
		 <div class="tt-loading-center">
		  <div class="tt-loading-center-absolute">
		   <div class="tt-object object_four"></div>
		   <div class="tt-object object_three"></div>
		   <div class="tt-object object_two"></div>
		   <div class="tt-object object_one"></div>
		  </div>
		 </div>
		</div>
		';
	}

} // End airtech_tt_preloader()
}

/**
 * Top bar.
 */
if ( ! function_exists( 'airtech_topbar' ) ) {
function airtech_topbar () {
	$output = $right_output = $left_output = '';

	if ( false == get_theme_mod( 'top_bar', true ) ) return ''; // user dont want it.

	$left_output = get_theme_mod( 'top_bar_left', '' );

	$right_output = get_theme_mod( 'top_bar_right', '' );

	$output = '
        	<div class="header_top">
        		<div class="container">
        			<div class="justify-content-between d-flex">
        				<div class="left_side">
							'.$left_output.'
						</div>
						<div class="right_side">
							'.$right_output.'
						</div>
        			</div>
        		</div>
        	</div>
	';
	return do_shortcode($output); // Already sanitized by customiser framework.
} // End airtech_topbar()
}

/**
 * header right section.
 */
if ( ! function_exists( 'airtech_header_right' ) ) {
function airtech_header_right() {
	$output = $right_output = $left_output = $emergency_img = $appntm_img = '';
	ob_start(); ?>
		<?php if ( true == get_theme_mod( 'enable_hdr_right', false ) ) { ?>
        <div class="right">
	        <?php if ( true == get_theme_mod( 'enable_apmt', true ) ) { ?>
            <div class="media">
                <div class="d-flex">
                    <a href="<?php echo esc_url(get_theme_mod( 'appntm_link', '' )); ?>">
				        <?php $appntm_img = get_theme_mod( 'appntm_img', '' );
					         if( is_array($appntm_img) ) {
						         if ( is_ssl() ) { $appntm_img['url'] = str_replace( 'http://', 'https://', $appntm_img['url'] ); }
				        ?>
								 <img src="<?php echo esc_url($appntm_img['url']); ?>" <?php echo airtech_fw_img_alt($appntm_img['id']); ?> />
					    <?php } ?>
			        </a>
                </div>
                <div class="media-body">
                    <a href="<?php echo esc_url(get_theme_mod( 'appntm_link', '' )); ?>">
				        <h3><?php echo wp_kses(get_theme_mod( 'appntm_title', '' ), airtech_blv_allowed_tags()); ?></h3>
			        </a>
                </div>
            </div>
	        <?php } ?>
	        <?php if ( true == get_theme_mod( 'enable_emergency', true ) ) { ?>
            <div class="media">
                <div class="d-flex">
			        <?php $emergency_img = get_theme_mod( 'emergency_img', '' );
			              if( is_array($emergency_img) ) {
				            if ( is_ssl() ) { $emergency_img['url'] = str_replace( 'http://', 'https://', $emergency_img['url'] ); }

			        ?>
		                    <img src="<?php echo esc_url($emergency_img['url']); ?>" <?php echo airtech_fw_img_alt($emergency_img['id']); ?> />
				    <?php } ?>
                </div>
                <div class="media-body">
                    <h4><?php echo wp_kses(get_theme_mod( 'emergency_title', '' ), airtech_blv_allowed_tags()); ?></h4>
                    <a href="<?php echo esc_url(get_theme_mod( 'emergency_phone_link', '' )); ?>">
				        <h5><?php echo esc_html(get_theme_mod( 'emergency_ph_title', '' )); ?></h5>
			        </a>
                </div>
            </div>
	        <?php } ?>
        </div>
		<?php } ?>
	<?php $output = ob_get_clean();
	echo wp_kses_post($output); // Already sanitized by customiser framework.
} // End airtech_header_right()
}

/**
 * header 3 top section.
 */
if ( ! function_exists( 'airtech_header_3top' ) ) {
function airtech_header_3top() {
	$output = $right_output = $left_output = $emergency_img = $appntm_img = '';
	ob_start(); ?>
		<?php if ( true == get_theme_mod( 'enable_hdr_right', false ) ) { ?>
        <div class="right">
	        <?php if ( true == get_theme_mod( 'enable_apmt', true ) ) { ?>
            <div class="media">
                <div class="d-flex">
                    <a href="<?php echo esc_url(get_theme_mod( 'appntm_link', '' )); ?>">
				        <?php $appntm_img = get_theme_mod( 'appntm_img', '' );
				              if( is_array($appntm_img) ) {
						         if ( is_ssl() ) { $appntm_img['url'] = str_replace( 'http://', 'https://', $appntm_img['url'] ); }
				        ?>
	                    <img src="<?php echo esc_url($appntm_img['url']); ?>" <?php echo airtech_fw_img_alt($appntm_img['id']); ?> />
					    <?php } ?>
			        </a>
                </div>
                <div class="media-body">
                    <a href="<?php echo esc_url(get_theme_mod( 'appntm_link', '' )); ?>">
				        <h3><?php echo wp_kses(get_theme_mod( 'appntm_title', '' ), airtech_blv_allowed_tags()); ?></h3>
			        </a>
                </div>
            </div>
	        <?php } ?>
	        <?php if ( true == get_theme_mod( 'enable_emergency', true ) ) { ?>
            <div class="media">
                <div class="d-flex">
			        <?php $emergency_img = get_theme_mod( 'emergency_img', '' );
			              if( is_array($emergency_img) ) {
				            if ( is_ssl() ) { $emergency_img['url'] = str_replace( 'http://', 'https://', $emergency_img['url'] ); }
			        ?>
                    <img src="<?php echo esc_url($emergency_img['url']); ?>" <?php echo airtech_fw_img_alt($emergency_img['id']); ?> />
				    <?php } ?>
                </div>
                <div class="media-body">
                    <h4><?php echo wp_kses(get_theme_mod( 'emergency_title', '' ), airtech_blv_allowed_tags()); ?></h4>
                    <a href="<?php echo esc_url(get_theme_mod( 'emergency_phone_link', '' )); ?>">
				        <h5><?php echo esc_html(get_theme_mod( 'emergency_ph_title', '' )); ?></h5>
			        </a>
                </div>
            </div>
	        <?php } ?>
        </div>
		<?php } ?>
	<?php $output = ob_get_clean();
	echo wp_kses_post($output); // Already sanitized by customiser framework.
} // End airtech_header_3top()
}

/**
 * Hero area.
 */
if ( ! function_exists( 'airtech_heroarea' ) ) {
function airtech_heroarea () {
	$page_id = $hero_bg_right = $single_cust_title = $single_enab_hero = $single_enab_breadcrumb = $single_enab_notitle = $single_enab_hero = $output = $right_output = $left_output = '';
	$enable_breadcrumb = '1';
	$single_bgimage = array();
	// Grab data from customiser.
	if ( false == get_theme_mod( 'enable_hero', true ) ) return ''; // user dont want it globally.

	// Grab single page values.
	$page_id = airtech_get_the_id();
	if ( function_exists( 'rwmb_meta' ) ) {
	    $single_enab_hero           = rwmb_meta( '_blv_enable_hero', $page_id );
	    $single_bgimage             = rwmb_meta( '_blv_single_bgimage', $page_id );
	    $single_cust_title          = rwmb_meta( '_blv_cust_title', $page_id );
	    $single_enab_breadcrumb     = rwmb_meta( '_blv_enable_breadcrumb', $page_id );
	    $single_enab_notitle        = rwmb_meta( '_blv_enable_notitle', $page_id );
	}

	if ( '0' === $single_enab_hero ) return ''; // user dont want it on page level.

	// Preparing the page title.
	// if title is not entered , grab the default page title.
	if( '' == $single_cust_title ) $single_cust_title = get_the_title($page_id);

	// if this is post, show Blog as title. we dont want double entry for title.
	if( is_singular('post') || ( is_home() && ! is_front_page()) ) $single_cust_title = esc_html__( 'Blog', 'airtech' );

	// if this is single product, show Products as title. we dont want double entry for title.
	if( is_singular('product') ) $single_cust_title = esc_html__( 'Products', 'airtech' );

	// user wants hero section without title.
	if( $single_enab_notitle ) $single_cust_title = '';

	// Grab data from customiser.
	if ( false == get_theme_mod( 'enable_breadcrumb', true ) ) $enable_breadcrumb = false; // user dont want it globally.
	if ( '0' === $single_enab_breadcrumb ) $enable_breadcrumb = false; // user dont want it on particular page.

	// Creation of BG image css moved to customiser css generator.

	/* Note that BG image is displayed using custom inlined css. */
	ob_start(); ?>

        <section class="breadcrumb_area">
        	<div class="container">
        		<div class="breadcrumb_inner">
			        <?php $hero_bg_right = get_theme_mod( 'hero_bg_right', '' ); ?>
			        <?php if( is_array($hero_bg_right)) {
						if ( is_ssl() ) { $hero_bg_right['url'] = str_replace( 'http://', 'https://', $hero_bg_right['url'] ); }
				        ?>
        			<img src="<?php echo esc_url($hero_bg_right['url']); ?>" <?php echo airtech_fw_img_alt($hero_bg_right['id']); ?> />
			        <?php } ?>
			        <?php if( !empty($single_cust_title)) { ?>
						<h2><?php echo wp_kses($single_cust_title, airtech_blv_allowed_tags()); ?></h2>
					<?php  } ?>
					<?php
					// Breadcrumb
						 if( function_exists('breadcrumb_trail') && !(is_home() || is_front_page()) && $enable_breadcrumb ){ ?>
								<?php breadcrumb_trail(array('show_browse' => false)); ?>
					<?php
						 }
					?>
        		</div>
        	</div>
        </section>

	<?php
	$generic_hero = ob_get_clean();
	echo wp_kses_post($generic_hero);

} // End airtech_heroarea()
}

/**
 * Hero area BG
 */
if ( ! function_exists( 'airtech_heroarea_bg' ) ) {
function airtech_heroarea_bg () {
	$page_id = $hero_bg_right = $single_cust_title = $single_bgimage = $single_enab_hero = $single_enab_breadcrumb = $single_enab_notitle = $single_enab_hero = $output = $right_output = $left_output = '';
	$enable_breadcrumb = '1';

	// if this is post, show Blog as title. we dont want double entry for title.
		if( is_singular('post') || (is_home() && ! is_front_page()) ) $single_cust_title = esc_html__( 'Blog', 'airtech' );
        if( is_post_type_archive('product')) $single_cust_title = esc_html__( 'Our Products', 'airtech' );
		if ( is_home() && is_front_page() ) { return ''; } /* no need for hero section on default blog home page */
        if( is_archive() && ! is_post_type_archive('product') ){
			$single_cust_title = get_the_archive_title();
			$single_cust_desc = get_the_archive_description();
        }
		if ( is_search() ) {
			$single_cust_title = sprintf( esc_attr__( 'Search Results for: %s', 'airtech' ), '<span>' . get_search_query() . '</span>' );
		}

	// Handling breadcrumb.
	// Grab data from customiser.
	if ( false == get_theme_mod( 'enable_breadcrumb', true ) ) $enable_breadcrumb = false; // user dont want it globally.

	/* Note that BG image is displayed using custom inlined css. */
	ob_start(); ?>

        <section class="breadcrumb_area blv-breadcrumb">
        	<div class="container">
        		<div class="breadcrumb_inner">
			        <?php $hero_bg_right = get_theme_mod( 'hero_bg_right', '' ); ?>
			        <?php if( is_array($hero_bg_right)) {
						if ( is_ssl() ) { $hero_bg_right['url'] = str_replace( 'http://', 'https://', $hero_bg_right['url'] ); }
				        ?>
        			<img src="<?php echo esc_url($hero_bg_right['url']); ?>" <?php echo airtech_fw_img_alt($hero_bg_right['id']); ?> />
			        <?php } ?>
			        <?php if( !empty($single_cust_title)) { ?>
						<h2><?php echo wp_kses($single_cust_title, airtech_blv_allowed_tags()); ?></h2>
					<?php  } ?>
			        <?php if( !empty($single_cust_desc)) { ?>
						<p><?php echo wp_kses($single_cust_desc, airtech_blv_allowed_tags()); ?></p>
					<?php  } ?>
					<?php
					// Breadcrumb
						 if( function_exists('breadcrumb_trail') && !(is_home() || is_front_page()) && $enable_breadcrumb ){ ?>
								<?php breadcrumb_trail(array('show_browse' => false)); ?>
					<?php
						 }
					?>
        		</div>
        	</div>
        </section>

	<?php
	$generic_hero = ob_get_clean();
	echo wp_kses_post($generic_hero);

} // End airtech_heroarea_bg()
}

add_action( 'airtech_heroarea', 'airtech_heroarea_trigger', 1 );
if( !function_exists('airtech_heroarea_trigger')) {
	function airtech_heroarea_trigger( ) {

		if ( is_singular() ) {
			add_action( 'airtech_heroarea', 'airtech_heroarea', 2 );
		}
		else {
			add_action( 'airtech_heroarea', 'airtech_heroarea_bg', 2 );
		}

	}
}

/*-----------------------------------------------------------------------------------*/
/* Header Type
/*-----------------------------------------------------------------------------------*/

if (!function_exists( 'airtech_get_hdr_type')) {
	function airtech_get_hdr_type() {

		$single_data2 = $tt_post_id = $hdr_type = $single_hdr_type = '';
		// grab value from themeoptions
		$hdr_type = get_theme_mod( 'header_layout', 'default' );
		// override if set on particular page.
		$single_hdr_type = airtech_meta_value( '_blv_single_hdr_type', 'default' );

		if ( $single_hdr_type == 'default' || $single_hdr_type == 'header2' || $single_hdr_type == 'header3' || $single_hdr_type == 'header4' || $single_hdr_type == 'header5' ) {
			$hdr_type = $single_hdr_type;
		}

		return $hdr_type;
	}
}

/*-----------------------------------------------------------------------------------*/
/* return meta value
/*-----------------------------------------------------------------------------------*/
if (!function_exists( 'airtech_meta_value')) {
	function airtech_meta_value( $key = '', $args ='' ) {

	$page_id = $var_value = '';

	if( '' != $key ) {
		// Grab single page values.
		$page_id = airtech_get_the_id();
		if ( function_exists( 'rwmb_meta' ) ) {
			$var_value = rwmb_meta( $key, $args, $post_id = $page_id );
		}
		return $var_value;
	}
	}
}

/*-----------------------------------------------------------------------------------*/
/* Fetch ALT tags for images
/*-----------------------------------------------------------------------------------*/
// returns title based on the requirement.

if (!function_exists( 'airtech_fw_img_alt')) {
function airtech_fw_img_alt( $imgid = '', $postid = '' ){
	$alt = '';
	if( '' == $imgid && '' != $postid ) // if only post id is given, fetch imgid from it.
	$imgid = get_post_thumbnail_id( $postid );

	if($imgid) $alt = get_post_meta( $imgid, '_wp_attachment_image_alt', true);

	return 'alt="'.wp_specialchars_decode($alt).'"';
}
}

/*-----------------------------------------------------------------------------------*/
/* return value from customiser of single page, as set by user.
/* pass the param for metabox and customiser.                   */
/*-----------------------------------------------------------------------------------*/
if (!function_exists( 'airtech_fetch_single_or_global')) {
	function airtech_fetch_single_or_global( $single_data = '', $global_data = '', $single_enable = '', $global_enable = '' ) {

	$output = $single_data = $single_data_value = $single_enable = $single_enable_value = $global_data = $global_data_value = $global_enable = $global_enable_value = '';

	// Grab single page values.
	$page_id = airtech_get_the_id();
	if ( function_exists( 'rwmb_meta' ) ) {
	    $single_enable_value = rwmb_meta( $single_enable, $page_id );
	    $single_data_value = rwmb_meta( $single_data, $page_id );
	}

	if ( '0' === $single_enable_value ) return ''; // user dont want it on page level. Nothing left to do.

	// Grab customiser value.
		$$global_enable_value = get_theme_mod( $global_enable, '' );
		$global_data_value = get_theme_mod( $global_data, '' );

	if ( true === $global_enable_value ) return ''; // user dont want it globally. Nothing left to do.

	$output = ( '' != $single_data_value ) ? $single_data_value : $global_data_value;

	return $output;

	}
}

/*-----------------------------------------------------------------------------------*/
/* return excerpt with given charlent.                                               */
/*-----------------------------------------------------------------------------------*/
// source https://codex.wordpress.org/Function_Reference/get_the_excerpt
if (!function_exists( 'airtech_excerpt_charlength')) {
	function airtech_excerpt_charlength( $charlength ) {
		$excerpt = get_the_excerpt();
		$charlength ++;

		if ( mb_strlen( $excerpt ) > $charlength ) {
			$subex   = mb_substr( $excerpt, 0, $charlength - 5 );
			$exwords = explode( ' ', $subex );
			$excut   = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
			if ( $excut < 0 ) {
				echo mb_substr( $subex, 0, $excut );
			} else {
				echo esc_html($subex);
			}
			echo '...';
		} else {
			echo esc_html($excerpt);
		}
	}
}


/*-----------------------------------------------------------------------------------*/
/* Add date and time to contact form 7 (CF7)                                         */
/*-----------------------------------------------------------------------------------*/

add_action( 'wpcf7_init', 'airtech_cf7_time' );
function airtech_cf7_time() {
    wpcf7_add_form_tag( 'airtech_time', 'airtech_cf7_time_output' );
}

function airtech_cf7_time_output( $tag ) {
    return '<input type="text" name="form-time" class="form-control datetimepicker-input" data-target="#datetimepicker3" data-toggle="datetimepicker" />';
}

add_action( 'wpcf7_init', 'airtech_cf7_date' );
function airtech_cf7_date() {
    wpcf7_add_form_tag( 'airtech_date', 'airtech_cf7_date_output' );
}

function airtech_cf7_date_output( $tag ) {
    return '<input type="text" name="form-date" class="form-control datetimepicker-input" data-target="#datetimepicker4" data-toggle="datetimepicker" />';
}


/*-----------------------------------------------------------------------------------*/
/* Fixing the font size for the tag cloud widget.                                    */
/*-----------------------------------------------------------------------------------*/
add_filter( 'widget_tag_cloud_args', 'airtech_tag_cloud_args' );
if (!function_exists( 'airtech_tag_cloud_args')) {
	function airtech_tag_cloud_args($args) {
	$args['number'] = 10; //adding a 0 will display all tags
	$args['largest'] = 15; //largest tag
	$args['smallest'] = 15; //smallest tag
	$args['unit'] = 'px'; //tag font unit
	$args['format'] = 'list'; //ul with a class of wp-tag-cloud
	return $args;
	}
}

/*-----------------------------------------------------------------------------------*/
/* Adding custom widget styles.                          */
/*-----------------------------------------------------------------------------------*/
add_action('wp_print_footer_scripts','airtech_add_widget_styles', 999) ;
function airtech_add_widget_styles() {
	ob_start();
	do_action('bolvo_get_widget_styles');
	$widget_out = ob_get_clean();
	$widget_out = preg_replace('/<!--(.*)-->/Uis', '', $widget_out);/* removing comments */
	$widget_out = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '   ', '    '), '', $widget_out); /* removing blank spaces tabs etc*/
	if( ''!= $widget_out )
	set_theme_mod('airtech_widget_css', $widget_out);
}


/*-----------------------------------------------------------------------------------*/
/* Renaming projects to services cpt                                 */
/*-----------------------------------------------------------------------------------*/
if (!function_exists( 'airtech_prj_to_services')) {
add_filter('tt_project_cpt_args','airtech_prj_to_services', 100) ;
function airtech_prj_to_services($prj_args) {
	$prj_args['labels']['name']                 = esc_attr__( 'Services', 'airtech' );
	$prj_args['labels']['singular_name']        = esc_attr__( 'Services', 'airtech' );
	$prj_args['labels']['add_new']              = esc_attr__( 'Add Services', 'airtech' );
	$prj_args['labels']['add_new_item']         = esc_attr__( 'Add Services', 'airtech' );
	$prj_args['labels']['edit']                 = esc_attr__( 'Edit', 'airtech' );
	$prj_args['labels']['edit_item']            = esc_attr__( 'Edit Services', 'airtech' );
	$prj_args['labels']['new_item']             = esc_attr__( 'New Services', 'airtech' );
	$prj_args['labels']['view']                 = esc_attr__( 'View Services', 'airtech' );
	$prj_args['labels']['view_item']            = esc_attr__( 'View Services', 'airtech' );
	$prj_args['labels']['search_items']         = esc_attr__( 'Search Services', 'airtech' );
	$prj_args['labels']['not_found']            = esc_attr__( 'No Services found', 'airtech' );
	$prj_args['labels']['not_found_in_trash']   = esc_attr__( 'No Services found in Trash', 'airtech' );
	$prj_args['labels']['parent']               = esc_attr__( 'Parent Services', 'airtech' );

	$prj_args['rewrite']['slug'] = 'service' ;
	unset($prj_args['exclude_from_search']);
	unset($prj_args['show_in_admin_bar']);
	unset($prj_args['show_in_nav_menus']);
	unset($prj_args['publicly_queryable']);
	unset($prj_args['query_var']);
	$prj_args['show_ui'] = true;
	return $prj_args;
}
}
