<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* Theme essentials! */
/*-----------------------------------------------------------------------------------*/
//setting some required settings to avoid multiple redirects caused by plugins
if(  is_admin() ) {
	update_option( 'ultimate_vc_addons_redirect', false );
	update_option( 'revslider-notices', false );
	set_transient( '_redux_activation_redirect', false, 30 );
	remove_action( 'init', 'vc_page_welcome_redirect' );
}

/**
 * Add default options and show Options Panel after activate
 * @since  4.0.0
 */
global $pagenow;
if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
	// Flush rewrite rules.
	flush_rewrite_rules();
	// check if its first ever install of theme
	$tt_update_log = get_option( 'temptt_theme_components');
	if( ! is_array($tt_update_log) ) {
		add_action( 'init', 'airtech_fw_theme_components', 1 );
		add_action( 'init', 'airtech_fw_user_manage_cpt', 2 ); // Trigger first run of this fn.
		airtech_tt_activate_redirect();
	} // only redirect if its first time activation
}

// Adding redirect
function airtech_tt_activate_redirect() {

	header( 'Location: ' . esc_url(admin_url( 'themes.php?page=tgmpa-install-plugins' )) );

} // End airtech_tt_activate_redirect()


// Adding versions
add_action( 'current_screen', 'airtech_tt_update_version' );
function airtech_tt_update_version( $current_screen ) {
	if ( 'appearance_page_tgmpa-install-plugins' == $current_screen->base ) {
		if( function_exists( 'airtech_tt_firstInst_notice' )) add_action( 'admin_notices', 'airtech_tt_firstInst_notice' ); // add notice.
	}
	if ( 'toplevel_page__templatation' == $current_screen->base ) {

		$airtech_fw_theme = wp_get_theme();
		$airtech_fw_this_theme_ver = $airtech_fw_theme->get( 'Version' );
		$theme_update_log = get_option( 'airtech_tt_updates_log');

        if ( ! $theme_update_log ) $theme_update_log = array();

		// First update
		if ( ! in_array('1.0', $theme_update_log) ) {
			array_unshift($theme_update_log, '1.0');
			update_option( 'airtech_tt_updates_log', $theme_update_log);
		}

		if ( ! in_array($airtech_fw_this_theme_ver, $theme_update_log) ) {
			array_unshift($theme_update_log, $airtech_fw_this_theme_ver);
			update_option( 'airtech_tt_updates_log', $theme_update_log);
		}

	}
}


if ( ! function_exists( 'airtech_fw_version' ) ) {
	function airtech_fw_version() {
		$data = airtech_get_theme_version_data();
		echo "\n<!-- Theme version -->\n";
		if ( isset( $data['is_child'] ) && true == $data['is_child'] ) {
			echo '<meta name="generator" content="' . esc_attr( $data['child_theme_name'] . ' ' . $data['child_theme_version'] ) . '" />' . "\n";
		}
		echo '<meta name="generator" content="' . esc_attr( $data['theme_name'] . ' ' . $data['theme_version'] ) . '" />' . "\n";
	} // End airtech_fw_version()
}

// Add Generator meta tags
if ( ! is_admin()  ) {
	add_action( 'wp_head', 'airtech_fw_version', 10 );
}

/**
 * Get the version data for the currently active theme.
 */
if ( ! function_exists( 'airtech_get_theme_version_data' ) ) {
function airtech_get_theme_version_data () {
	$response = array(
					'theme_version' => '',
					'theme_name' => '',
					'is_child' => is_child_theme(),
					'child_theme_version' => '',
					'child_theme_name' => ''
					);

	if ( function_exists( 'wp_get_theme' ) ) {
		$theme_data = wp_get_theme();
		if ( true == $response['is_child'] ) {
			$response['theme_version'] = $theme_data->parent()->Version;
			$response['theme_name'] = $theme_data->parent()->Name;

			$response['child_theme_version'] = $theme_data->Version;
			$response['child_theme_name'] = $theme_data->Name;
		} else {
			$response['theme_version'] = $theme_data->Version;
			$response['theme_name'] = $theme_data->Name;
		}
	}

	return $response;
} // End airtech_get_theme_version_data()
}


if( !function_exists( 'airtech_tt_firstInst_notice' )) {
	function airtech_tt_firstInst_notice() {

			 print '<div class="updated notice is-dismissible tt-admin1"><span class="tt-admin2"> ' .
		     esc_html__( 'Thanks for Activating Airtech WordPress theme.', 'airtech' ) . '</span>'
			 . '<br /> <br />' .

		     esc_html__( 'Theme requires few bundled plugins to function on its full power. Please Install and Activate plugins below.', 'airtech' )

			 . '<br />' .

		     esc_html__( 'You can choose not to install any particular plugin if you do not need it. eg woocommerce ', 'airtech' )

			 . '<br /> <br />' .

			 '<span class="tt-admin2"> ' .
		     esc_html__( 'After plugins are activated, Click Dashboard on left top, then go to Theme Options menu for further setup.', 'airtech' ) . '</span>'

		     . '</div>';
	}
}


/**
 * Initialize theme required features & components.
 * This is the base setting for required CPTs, based on these settings customer sees options to disable/rename rewrite for cpts in themeoptions.
 */
if(!( function_exists('airtech_fw_theme_components') )){

	function airtech_fw_theme_components() {

		$theme_components = array(
			'portfolio_cpt'             => '0',
			'team_cpt'                  => '0',
			'client_cpt'                => '0',
			'testimonial_cpt'           => '0',
			'project_cpt'               => '1',
			'common_shortcodes'         => '1',
			'post_shortcodes'           => '1',
			'tt_widget_recentpost'      => '0',
			'tt_dashboard_panel'        => '1',
			'temptt_metabox'            => '1', /* metabox plugin */
			'temptt_hfe'                => '1', /* Add content elementor */
			'temptt_add_content'        => '1', /* HFE plugin */
			'temptt_kirki'              => '1', /* Kirki */
			'temptt_bt_ep'              => '1', /* EP plugin */
			'temptt_bt_t'               => '1', /* testimony plugin */
			'temptt_bt_p'               => '0', /* Portfolio plugin */
			'temptt_themename'          => 'Airtech', /* as in Stylesheet */
			'temptt_author'             => 'blv',  /* if blv or da */
			'temptt_tf_link'            => 'airtech-wordpress-theme/24428877', /* format : itemslug/itemID */
			'temptt_pcode_check_no'     => '0', /* whether to implement purchase code verification. put 0 to enable pcode verification */
			'temptt_ult_addons'         => '1',  /* to include Elementor mods or not. */
		);
		// Let filter modify it
		$theme_components = apply_filters( 'temptt_theme_components', $theme_components );
		update_option('temptt_theme_components', $theme_components);
	}
	// only trigger on first install
	global $pagenow;
}

/**
 * Let user disable CPT as per his needs.
 */
if(!( function_exists('airtech_fw_user_manage_cpt') )){

	function airtech_fw_user_manage_cpt() {

		// Fetch from DB.
		$theme_components = get_option('temptt_theme_components');

		if( !$theme_components ) return;

		// User settings.
		$theme_user_cpts = array(
/*			'portfolio_cpt'             => get_option( 'portfolio_cpt', $theme_components['portfolio_cpt'] ),
			'testimonial_cpt'           => get_option( 'testimonial_cpt', $theme_components['testimonial_cpt'] ),
			'team_cpt'                  => get_option( 'team_cpt', $theme_components['team_cpt'] ),
			'client_cpt'                => get_option( 'client_cpt', $theme_components['client_cpt'] ),
			'project_cpt'               => get_option( 'project_cpt', $theme_components['project_cpt'] ),*/
		);

		// Overwrite theme defaults with new user settings.
		$new_theme_components = wp_parse_args( $theme_user_cpts, $theme_components );

		// Save
		update_option('temptt_theme_components_user', $new_theme_components);

	}
}

// admin styles.
if ( ! function_exists( 'airtech_tt_admin_styles' ) ) {
	function airtech_tt_admin_styles() {

		wp_enqueue_style( 'airtech-admin-css', get_template_directory_uri() . '/assets/css/tt-admin.css' );

	} add_action('admin_enqueue_scripts', 'airtech_tt_admin_styles', 200);
}
