<?php
/**
 * Airtech setup
 *
 * @package airtech
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Controls_Manager;
add_filter('bolvo_add_contents_fields', 'airtech_theme_contents_fields');

function airtech_theme_contents_fields() {

		$contents_type_fields = [
			'label' => sprintf( esc_html__( '%1$s Add Content', 'airtech' ), ucfirst(get_template() ) ),
			'controls' => [
				'posts_per_page' => [
					'label' => esc_html__( 'Number of posts displayed', 'airtech' ),
					'type' => Controls_Manager::TEXT,
					'default' => '5',
					'description' => esc_html__( 'The number of posts you want to show.', 'airtech' ),
					'label_block' => true,
				],
				'post_type' => [
					'label' => esc_html__( 'Content Type', 'airtech' ),
					'type' => Controls_Manager::SELECT,
					'description' =>esc_html__( 'Not all content type will be listed here. We list only those we have template in this theme for.', 'airtech' ),
					'default'  => 'post',
					'options'  => [
						 'post'                 => esc_html__(' Posts', 'airtech'),
						 'tt_project'           => esc_html__(' Gallery/Services', 'airtech'),
					],
				],

				'orderby' => [
					'label' => esc_html__( 'Order by', 'airtech' ),
					'type' => Controls_Manager::SELECT,
					'description' =>esc_html__( 'Order this content by...', 'airtech' ),
					'default'  => 'date',
					'options'  => [
						  'date'            =>      esc_html__(' Date', 'airtech'),
						  'ID'              =>      esc_html__(' Post ID', 'airtech'),
						  'author'          =>      esc_html__(' Author', 'airtech'),
						  'title'           =>      esc_html__(' Title', 'airtech'),
						  'name'            =>      esc_html__(' Post name (post slug)', 'airtech'),
						  'modified'        =>      esc_html__(' Last modified date', 'airtech'),
						  'rand'            =>      esc_html__(' Random order', 'airtech'),
						  'comment_count'   =>      esc_html__(' Number of comments', 'airtech'),
					],
				],

				'order' => [
					'label' => esc_html__( 'Order', 'airtech' ),
					'type' => Controls_Manager::SELECT,
					'default'  => 'DESC',
					'options'  => [
						  'DESC'            =>      esc_html__(' DESC', 'airtech'),
						  'ASC'             =>      esc_html__(' ASC', 'airtech'),
					],
				],

				'tt_id' => [
					'label' => esc_html__( 'Post Ids', 'airtech' ),
					'type' => Controls_Manager::TEXT,
					'default' => '',
					'description' => esc_html__( 'If you want to display particular posts, enter their IDs comma separated. eg 101,202,300. Recommended: Leave blank', 'airtech' ),
					'label_block' => true,
				],

				'tt_template' => [
					'label' => esc_html__( 'Display Template', 'airtech' ),
					'type' => Controls_Manager::SELECT,
					'description' => esc_html__( 'There are prebuilt templates to display certain content in this theme. You are requested not to edit this.', 'airtech' ),
					'default'  => 'default',
					'options'  => [
						'default'           =>  esc_html__(' Default', 'airtech'),
						'gallery-masonry'   =>  esc_html__(' Gallery Masonry', 'airtech'),
						'gallery-page'   =>  esc_html__(' Gallery Page', 'airtech'),
						'service-list'      =>  esc_html__(' Service List', 'airtech'),
					],
				],

				'enable_filter' => [
					'label' => esc_html__( 'Enable Filter ?', 'airtech' ),
					'type' => Controls_Manager::SWITCHER,
					'description' => esc_html__( 'If set to yes, the gallery is filterable by the category. Not applicable to all cases.', 'airtech' ),
					'default' => 'true',
					'prefix_class' => 'elementor-',
					'label_on' => 'Yes',
					'label_off' => 'No',
					'return_value' => 'true',
					'condition' => [
						'tt_template' => [ 'gallery-masonry', 'gallery-page' ],
					],
				],

				'enable_all_btn' => [
					'label' => esc_html__( 'Enable ALL button ?', 'airtech' ),
					'type' => Controls_Manager::SWITCHER,
					'description' => esc_html__( 'If set to yes, All link appears first that displays all items. Not applicable to all cases.', 'airtech' ),
					'default' => 'true',
					'prefix_class' => 'elementor-',
					'label_on' => 'Yes',
					'label_off' => 'No',
					'return_value' => 'true',
					'condition' => [
						'tt_template' => [ 'gallery-masonry', 'gallery-page' ],
					],
				],

				'spl_field1' => [
					'label' => esc_html__( 'Title (Optional)', 'airtech' ),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'airtech' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'gallery-masonry', 'service-list' ],
					],
				],

				'spl_field2' => [
					"label" => esc_html__("Description (Optional)",'airtech'),
					'type' => Controls_Manager::TEXTAREA,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'airtech' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'service-list' ],
					],
				],

				'spl_field3' => [
					"label" => esc_html__("Description (Optional)",'airtech'),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'airtech' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'none' ],
					],
				],

				'spl_field4' => [
					'label' => esc_html__( 'Title (Optional)', 'airtech' ),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'airtech' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'none' ],
					],
				],

				'spl_field5' => [
					'label' => esc_html__( 'Title (Optional)', 'airtech' ),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'airtech' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'none' ],
					],
				],

				'spl_field6' => [
					'label' => esc_html__( 'Title (Optional)', 'airtech' ),
					'type' => Controls_Manager::TEXT,
					'description' => esc_html__( 'Enter the title for the entire block. Leave blank to disable.', 'airtech' ),
					'label_block' => true,
					'condition' => [
						'tt_template' => [ 'none' ],
					],
				],

			],
		];

		return $contents_type_fields;

}
