<?php
/**
 * Airtech Customizer functionality
 *
 * @package WordPress
 * @subpackage Airtech
 * @since Airtech 1.0
 */



/* Kirki starts */

if( class_exists( 'Kirki' )) {
	Kirki::add_config( 'airtech_cust_config', array(
		'capability'  => 'edit_theme_options',
		'option_type' => 'theme_mod',
	) );

	Kirki::add_panel( 'js_panel1', array(
		'title'       => esc_html__( 'Airtech General Settings', 'airtech' ),
		'description' => esc_html__( 'Airtech Theme Settings. Please note that Elementor page builder powers the complete look of theme now, including header/footer. Refer documentation for more details. These settings here applies only to base elements, like Blog list page.', 'airtech' ),
	) );

	Kirki::add_section( 'js_section31', array(
		'title'       => esc_html__( 'General', 'airtech' ),
		'panel'       => 'js_panel1',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_scrolltop',
		'label'       => esc_html__( 'Enable scroll to top.', 'airtech' ),
		'section'     => 'js_section31',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_preloader',
		'label'       => esc_html__( 'Enable preloader. Its an animation that appears when page loads.', 'airtech' ),
		'section'     => 'js_section31',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_section( 'js_section1', array(
		'title'       => esc_html__( 'Typography(Font & Color)', 'airtech' ),
		'panel'       => 'js_panel1',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info1',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => '<div class=blv-cust-heading2>' . esc_html__( 'Important : Please note that Elementor page builder powers the most of the look of the theme, including header/footer. Refer documentation or contact support for more details. These settings here applies only to base theme elements, eg Blog list page.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_typography',
		'label'       => esc_html__( 'Enable custom typography. Disable it to load theme defaults.', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info2',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Body & Paragraph Text', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'typography',
		'settings'    => 'body_font',
		'label'       => esc_html__( 'Body & Paragraph Text', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => [
			'font-family'    => '',
			'variant'        => '',
			'font-size'      => '',
			'line-height'    => '',
			'letter-spacing' => '',
			'color'          => '',
			'text-transform' => 'none',
			'text-align'     => 'left',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.entry-content > p',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info3',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Post Title', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );


	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'typography',
		'settings'    => 'post_heading',
		'label'       => esc_html__( 'Post Title', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => [
			'font-family'    => '',
			'variant'        => '',
			'font-size'      => '',
			'line-height'    => '',
			'letter-spacing' => '',
			'color'          => '',
			'text-transform' => 'none',
			'text-align'     => 'left',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.entry-title, .entry-title a',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info5',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Widget Title', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );


	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'typography',
		'settings'    => 'wdgt_title',
		'label'       => esc_html__( 'Widget Title', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => [
			'font-family'    => '',
			'variant'        => '',
			'font-size'      => '',
			'line-height'    => '',
			'letter-spacing' => '',
			'color'          => '',
			'text-transform' => 'none',
			'text-align'     => 'left',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '#secondary .widget .widget-title',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info7',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Widget Links', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );


	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'typography',
		'settings'    => 'wdgt_links',
		'label'       => esc_html__( 'Widget Links', 'airtech' ),
		'section'     => 'js_section1',
		'default'     => [
			'font-family'    => '',
			'variant'        => '',
			'font-size'      => '',
			'line-height'    => '',
			'letter-spacing' => '',
			'color'          => '',
			'text-transform' => 'none',
			'text-align'     => 'left',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.site-content .widget-area .widget a',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_typography',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	/* Base color starts */
	Kirki::add_section( 'js_section2', array(
		'title'       => esc_html__( 'Colors', 'airtech' ),
		'panel'       => 'js_panel1',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info6',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '<div class=blv-cust-heading2>' . esc_html__( 'Important : Please note that Elementor page builder powers the look of most of the theme now, including header/footer. Refer documentation or contact support for more details. These settings here applies only to base theme elements, eg Blog list page.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_colors',
		'label'       => esc_html__( 'Enable custom colors. Disable it to load theme defaults.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'color',
		'settings'    => 'blv_color1',
		'label'       => __( 'Main Color. Blue by default in this theme.', 'airtech' ),
		'description' => esc_html__( 'Used as main color in theme. Clear the values to reset to theme default color.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '',
		'choices'     => [
			'alpha' => true,
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'color',
		'settings'    => 'blv_color2',
		'label'       => __( 'Main Color Lighter', 'airtech' ),
		'description' => esc_html__( 'Somewhat light version of main color.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '',
		'choices'     => [
			'alpha' => true,
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'color',
		'settings'    => 'blv_color3',
		'label'       => __( 'Main Color Lightest', 'airtech' ),
		'description' => esc_html__( 'Even more light version of Main color.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '',
		'choices'     => [
			'alpha' => true,
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'color',
		'settings'    => 'blv_color4',
		'label'       => __( 'Main Secondary Color. Red by default in this theme.', 'airtech' ),
		'description' => esc_html__( 'The reverse color of Main color. Clear the values to reset to theme default color.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '',
		'choices'     => [
			'alpha' => true,
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'color',
		'settings'    => 'blv_accent_color',
		'label'       => __( 'Base Accent Color', 'airtech' ),
		'description' => esc_html__( 'Used as main color in base theme eg for blog. In most cases, it will be same as Main color set above. Click on Default button to reset to theme default color.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => '',
		'choices'     => [
			'alpha' => true,
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'background',
		'settings'    => 'blv_footer_widgets',
		'label'       => __( 'Footer Background. It might not work because Elementor is controlling it, please go to Appearance/header&footer section or check documentation. ', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => [
			'background-color'      => '#0b1529',
			'background-image'      => '',
			'background-repeat'     => '',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.footer_widgets',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'background',
		'settings'    => 'blv_footer_copyright',
		'label'       => __( 'Extreme Footer Background. It might not work because Elementor is controlling it, please go to Appearance/header&footer section or check documentation.', 'airtech' ),
		'section'     => 'js_section2',
		'default'     => [
			'background-color'      => '#091222',
			'background-image'      => '',
			'background-repeat'     => '',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.footer_copyright',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_colors',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	/* Base color ends */


	/* Airtech Header */
	Kirki::add_panel( 'js_panel2', array(
		'title'       => esc_html__( 'Airtech Header', 'airtech' ),
	) );

	/* General setting starts */
	Kirki::add_section( 'js_p2_s0', array(
		'title'       => esc_html__( 'General Settings', 'airtech' ),
		'panel'       => 'js_panel2',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'radio-image',
		'settings'    => 'header_layout',
		'label'       => esc_html__( 'Select Header Type', 'airtech' ),
		'description' => esc_html__( 'Airtech theme comes with 4 Headers, you can select your choice here, please note that you can also override this setting on page level basis for page settings.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => 'default',
		'priority'    => 10,
		'choices'     => [
			'default'   => get_template_directory_uri() . '/inc/customizer/img/airtechhdr1.png',
			'header2'   => get_template_directory_uri() . '/inc/customizer/img/airtechhdr2.png',
			'header3'   => get_template_directory_uri() . '/inc/customizer/img/airtechhdr3.png',
			'header4'   => get_template_directory_uri() . '/inc/customizer/img/airtechhdr4.png',
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'hdr_sticky',
		'label'       => esc_html__( 'Enable Sticky menu.', 'airtech' ),
		'description'       => esc_html__( 'If enabled, the menu sticks on top when you scroll down the page.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'hdr_sticky_mob',
		'label'       => esc_html__( 'Enable Sticky menu on mobile.', 'airtech' ),
		'description'       => esc_html__( 'If enabled, the Sticky menu turns off only on mobile, need to have sticky menu above enabled.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'hdr_sticky',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );


	/* Header 1 right starts */
	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info41',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Manage right side of header.', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_hdr_right',
		'label'       => esc_html__( 'Enable header right section.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_apmt',
		'label'       => esc_html__( 'Enable Appointment section.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'appntm_img',
		'label'       => esc_html__( 'Appointment Image', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'choices'     => [
			'save_as' => 'array',
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_apmt',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'appntm_title',
		'label'       => esc_html__( 'Appointment Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_apmt',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'text',
		'settings'    => 'appntm_link',
		'label'       => esc_html__( 'Appointment Link', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_apmt',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_emergency',
		'label'       => esc_html__( 'Enable Emergency Phone section.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'emergency_img',
		'label'       => esc_html__( 'Emergency Image', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'choices'     => [
			'save_as' => 'array',
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_emergency',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'emergency_title',
		'label'       => esc_html__( 'Emergency Section Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_emergency',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'emergency_ph_title',
		'label'       => esc_html__( 'Phone Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_emergency',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'emergency_phone_link',
		'label'       => esc_html__( 'Phone link', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('default','header2')
			],
			[
				'setting'  => 'enable_hdr_right',
				'operator' => '==',
				'value'    => true,
			],
			[
				'setting'  => 'enable_emergency',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	/* Header 1 right ends */

	/* Header 3 top starts */
	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info42',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Manage top side of header.', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_emergency3',
		'label'       => esc_html__( 'Enable Phone section. You can use it for other similar purpose too.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'phone_img3',
		'label'       => esc_html__( 'Phone Image', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'choices'     => [
			'save_as' => 'array',
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_emergency3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'emergency_ph_title3',
		'label'       => esc_html__( 'Phone Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_emergency3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'emergency_phone_link3',
		'label'       => esc_html__( 'Phone link', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_emergency3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_email3',
		'label'       => esc_html__( 'Enable Email section. You can use it for other similar purpose too.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'email_img3',
		'label'       => esc_html__( 'Email Image', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'choices'     => [
			'save_as' => 'array',
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_email3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'email_title3',
		'label'       => esc_html__( 'Email Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_email3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'email_link3',
		'label'       => esc_html__( 'Email link', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_email3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_apmt3',
		'label'       => esc_html__( 'Enable Appointment section.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'appntm_img3',
		'label'       => esc_html__( 'Appointment Image', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'choices'     => [
			'save_as' => 'array',
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_apmt3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'appntm_title3',
		'label'       => esc_html__( 'Appointment Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_apmt3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'text',
		'settings'    => 'appntm_link3',
		'label'       => esc_html__( 'Appointment Link', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			],
			[
				'setting'  => 'enable_apmt3',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_search3',
		'label'       => esc_html__( 'Enable Search.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header3')
			]
		],
	] );

	/* Header 3 top ends */


	/* Header 4 top starts */
	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info43',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Manage top side of header.', 'airtech' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_phone4',
		'label'       => esc_html__( 'Enable Teaser text/Phone section.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'phone_icon4',
		'label'       => esc_html__( 'Phone icon. Find all options here https://fontawesome.com/cheatsheet e.g. : fa fa-phone', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => 'fa fa-phone',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			],
			[
				'setting'  => 'enable_phone4',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'phone_title4',
		'label'       => esc_html__( 'Phone Section Title', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			],
			[
				'setting'  => 'enable_phone4',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'phone_label4',
		'label'       => esc_html__( 'Phone Label', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			],
			[
				'setting'  => 'enable_phone4',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'phone_link4',
		'label'       => esc_html__( 'Phone link', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			],
			[
				'setting'  => 'enable_phone4',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'editor',
		'settings'    => 'right_content4',
		'label'       => esc_html__( 'Right side content. Basic html is ok.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_search4',
		'label'       => esc_html__( 'Enable Search.', 'airtech' ),
		'section'     => 'js_p2_s0',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'header_layout',
				'operator' => 'in',
				'value'    => array('header4')
			]
		],
	] );

	/* Header 4 top ends */

	/* Logo section starts */
	Kirki::add_section( 'js_p2_s2', array(
		'title'       => esc_html__( 'Logo', 'airtech' ),
		'panel'       => 'js_panel2',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info4',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p2_s2',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Logo Settings.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'cust_logo',
		'label'       => esc_html__( 'Use Logo. If disabled, the Site Title entered in Site Identity will appear instead.', 'airtech' ),
		'section'     => 'js_p2_s2',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'logo_url',
		'label'       => esc_html__( 'Upload Logo', 'airtech' ),
		'section'     => 'js_p2_s2',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'cust_logo',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'slider',
		'settings'    => 'logo_width',
		'label'       => esc_html__( 'If you want high resolution logo,  please upload double size logo and then select 50 here. Then the logo will be resized to its 50% width.', 'airtech' ),
		'section'     => 'js_p2_s2',
		'default'     => '85',
		'choices'     => [
			'min'  => 20,
			'max'  => 100,
			'step' => 1,
		],
		'active_callback' => [
			[
				'setting'  => 'cust_logo',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'logo_url2',
		'label'       => esc_html__( 'Upload Secondary Logo. Used on light tone header.', 'airtech' ),
		'section'     => 'js_p2_s2',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'cust_logo',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'slider',
		'settings'    => 'logo_width2',
		'label'       => esc_html__( 'If you want high resolution secondary logo,  please upload double size logo and then select 50 here. Then the logo will be resized to its 50% width.', 'airtech' ),
		'section'     => 'js_p2_s2',
		'default'     => '85',
		'choices'     => [
			'min'  => 20,
			'max'  => 100,
			'step' => 1,
		],
		'active_callback' => [
			[
				'setting'  => 'cust_logo',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	/* Logo section ends */


	/* Menubar starts */
	Kirki::add_section( 'js_p2_s4', array(
		'title'       => esc_html__( 'Menubar Right', 'airtech' ),
		'panel'       => 'js_panel2',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info42',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p2_s4',
		'default'     => '<div class=blv-cust-heading>' . esc_html__( 'Manage right side of Menu.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_menu_btn',
		'label'       => esc_html__( 'Enable menu button.', 'airtech' ),
		'section'     => 'js_p2_s4',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'textarea',
		'settings'    => 'hdr_btn_text',
		'label'       => esc_html__( 'Button Text', 'airtech' ),
		'section'     => 'js_p2_s4',
		'default'     => 'Service Request',
		'active_callback' => [
			[
				'setting'  => 'enable_menu_btn',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'text',
		'settings'    => 'hdr_btn_link',
		'label'       => esc_html__( 'Button Link', 'airtech' ),
		'section'     => 'js_p2_s4',
		'default'     => '#',
		'active_callback' => [
			[
				'setting'  => 'enable_menu_btn',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );
	/* Menubar ends */


	/* Airtech content panel starts. */
	Kirki::add_panel( 'js_panel3', array(
		'title'       => esc_html__( 'Airtech Content Settings', 'airtech' ),
		'description' => esc_html__( 'Airtech Content Settings. Please note that Elementor page builder powers the complete look of theme now, including header/footer. Refer documentation for more details. These settings here applies only to base elements, like Blog list page.', 'airtech' ),
	) );

/* Hero section starts*/
	Kirki::add_section( 'js_p3_s1', array(
		'title'       => esc_html__( 'Hero / Breadcrumb', 'airtech' ),
		'panel'       => 'js_panel3',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_hero',
		'label'       => esc_html__( 'Enable Hero area globally.', 'airtech' ),
		'description'       => esc_html__( 'This is a section that appears after header. You can also control it for particular page in page settings. Note: This setting only applies to Posts, Pages, or Cpts', 'airtech' ),
		'section'     => 'js_p3_s1',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'hero_bg',
		'label'       => esc_html__( 'Default Background Image for Hero area.', 'airtech' ),
		'description'       => esc_html__( 'You can also upload it for particular page in page settings. ', 'airtech' ),
		'section'     => 'js_p3_s1',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'enable_hero',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'image',
		'settings'    => 'hero_bg_right',
		'label'       => esc_html__( 'Default Image for right side of Hero area.', 'airtech' ),
		'section'     => 'js_p3_s1',
		'default'     => '',
		'choices'     => [
			'save_as' => 'array',
		],
		'active_callback' => [
			[
				'setting'  => 'enable_hero',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_breadcrumb',
		'label'       => esc_html__( 'Enable Breadcrumb.', 'airtech' ),
		'description'       => esc_html__( 'You can also control it for particular page in page settings. Note: Breadcrumb Trail plugin must be active for this to work.', 'airtech' ),
		'section'     => 'js_p3_s1',
		'default'     => '1',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
		'active_callback' => [
			[
				'setting'  => 'enable_hero',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

/* Sidebar section starts*/
	Kirki::add_section( 'js_p3_s2', array(
		'title'       => esc_html__( 'Sidebar Settings', 'airtech' ),
		'panel'       => 'js_panel3',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_sidebar_style',
		'label'       => esc_html__( 'Enable custom style. Disable it to load theme defaults.', 'airtech' ),
		'section'     => 'js_p3_s2',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'background',
		'settings'    => 'blv_sidebar_bg',
		'label'       => __( 'Sidebar Backgorund', 'airtech' ),
		'section'     => 'js_p3_s2',
		'default'     => [
			'background-color'      => '',
			'background-image'      => '',
			'background-repeat'     => '',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.widget-area',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_sidebar_style',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	/* Airtech content panel ends. */

	/* Airtech footer panel starts. */
	Kirki::add_panel( 'js_panel4', array(
		'title'       => esc_html__( 'Airtech Footer Settings', 'airtech' ),
	) );

	/* Airtech footer Content starts. */
	Kirki::add_section( 'js_p4_s2', array(
		'title'       => esc_html__( 'Footer Content', 'airtech' ),
		'panel'       => 'js_panel4',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info8',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p4_s2',
		'default'     => '<div class=blv-cust-heading2>' . esc_html__( 'In this theme, footer is created using Elementor to provide full freedom to user. However, if you want to use footer widgets the default WordPress way, you can disable below button, and then Add widgets by going to Appearance/widgets in Footer Column widgets.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_cust_ftr',
		'label'       => esc_html__( 'Use Elementor powered footer ?', 'airtech' ),
		'description' => esc_html__( 'Note that there must be Footer section defined in Elementor to make it work. For more info, follow below instructions please.', 'airtech' ),
		'section'     => 'js_p4_s2',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info9',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p4_s2',
        'default'     => '<div class=blv-cust-heading4>' . sprintf( esc_html__( 'Elementor powered footer is disabled, please %s to go to Widgets section to add widgets in Footer columns', 'airtech' ), '<a href="' . esc_url( admin_url( 'customize.php?autofocus[panel]=widgets' ) ).'">'.esc_html__( 'Click Here', 'airtech' ).'</a>' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'enable_cust_ftr',
				'operator' => '==',
				'value'    => false,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info10',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p4_s2',
        'default'     => '<div class=blv-cust-heading3>' . sprintf( esc_html__( 'Elementor powered footer is enabled, please go to wp-admin/Appearance/Header Footer Builder to customise footer.', 'airtech' ), '<a href="' . esc_url( admin_url( 'customize.php?autofocus[panel]=widgets' ) ).'">'.esc_html__( 'Click Here', 'airtech' ).'</a>' ) . '</div>',
		'active_callback' => [
			[
				'setting'  => 'enable_cust_ftr',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );


	Kirki::add_section( 'js_p4_s1', array(
		'title'       => esc_html__( 'Footer Styles', 'airtech' ),
		'panel'       => 'js_panel4',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info14',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p4_s1',
		'default'     => '<div class=blv-cust-heading2>' . esc_html__( 'Custom style below works only if you disabled Elementor powered footer in Footer content section.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_ftr_style',
		'label'       => esc_html__( 'Enable custom style. Disable it to load theme defaults.', 'airtech' ),
		'section'     => 'js_p4_s1',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'background',
		'settings'    => 'blv_footer_bg',
		'label'       => __( 'Footer Background', 'airtech' ),
		'section'     => 'js_p4_s1',
		'default'     => [
			'background-color'      => '',
			'background-image'      => '',
			'background-repeat'     => '',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.site-footer,.footer-inner',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_ftr_style',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'background',
		'settings'    => 'blv_footer_info_bg',
		'label'       => __( 'Footer Info Background', 'airtech' ),
		'description' => __( 'This area appears after footer, that contains copyright info.', 'airtech' ),
		'section'     => 'js_p4_s1',
		'default'     => [
			'background-color'      => '',
			'background-image'      => '',
			'background-repeat'     => '',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.footer-info',
			],
		],
		'active_callback' => [
			[
				'setting'  => 'enable_ftr_style',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	/* Airtech footer info starts. */
	Kirki::add_section( 'js_p4_s3', array(
		'title'       => esc_html__( 'Footer Info', 'airtech' ),
		'panel'       => 'js_panel4',
	) );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info15',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p4_s3',
		'default'     => '<div class=blv-cust-heading3>' . esc_html__( 'This section works only if you disabled Elementor powered footer in Footer content section. Otherwise please go to wp-admin/Appearance/Header Footer Builder to edit.', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'custom',
		'settings'    => 'js_info11',
		'label'       => esc_html__( '', 'airtech' ),
		'section'     => 'js_p4_s3',
		'default'     => '<div class=blv-cust-heading2>' . esc_html__( 'This section comes after footer widgets, that contains copyright info', 'airtech' ) . '</div>',
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_ftr_left',
		'label'       => esc_html__( 'Enable custom footer left text.', 'airtech' ),
		'description'  => esc_html__( 'Enable this to enter custom text on footer copyright text, otherwise default text appears. If you do not want to display anything just enable it and then keep text editor value blank below.', 'airtech' ),
		'section'     => 'js_p4_s3',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'editor',
		'settings'    => 'enable_ftr_left_text',
		'label'       => esc_html__( 'Footer Left content', 'airtech' ),
		'section'     => 'js_p4_s3',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'enable_ftr_left',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'switch',
		'settings'    => 'enable_ftr_right',
		'label'       => esc_html__( 'Enable custom footer right text.( Recommended: Disabled )', 'airtech' ),
		'description'  => esc_html__( 'Enable this to enter custom text on footer right text, otherwise default text appears. We will be thankful to you if you do not enable it. If you do not want to display anything just enable it and then keep text editor value blank below.', 'airtech' ),
		'section'     => 'js_p4_s3',
		'default'     => '0',
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'airtech' ),
			'off' => esc_html__( 'Disable', 'airtech' ),
		],
	] );

	Kirki::add_field( 'airtech_cust_config', [
		'type'        => 'editor',
		'settings'    => 'enable_ftr_right_text',
		'label'       => esc_html__( 'Footer Right content', 'airtech' ),
		'section'     => 'js_p4_s3',
		'default'     => '',
		'active_callback' => [
			[
				'setting'  => 'enable_ftr_right',
				'operator' => '==',
				'value'    => true,
			]
		],
	] );


}
