<?php
/**
 * Airtech setup
 *
 * @package airtech
 */

/**
 * Assign the Airtech version to a var
 */
$theme              = wp_get_theme( 'airtech' );
$airtech_version = $theme['Version'];

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 980; /* pixels */
}

define('AIRTECH_THEME_DIR', trailingslashit( get_template_directory() ));
define('AIRTECH_THEME_DIRURI', trailingslashit( get_template_directory_uri() ));

$airtech = (object) array(
	'version'    => $airtech_version,

	/**
	 * Initialize all the things.
	 */
	'main'       => require get_template_directory() . '/inc/class-theme.php',
	'customizer' => require get_template_directory() . '/inc/customizer/class-theme-customizer.php',
);

require get_template_directory() . '/inc/theme-functions.php';
require get_template_directory() . '/inc/theme-template-hooks.php';
require get_template_directory() . '/inc/theme-template-functions.php';
require get_template_directory() . '/inc/theme-elementor-hooks.php';

if ( class_exists( 'Jetpack' ) ) {
	$airtech->jetpack = require get_template_directory() . '/inc/jetpack/class-theme-jetpack.php';
}

if ( airtech_is_woocommerce_activated() ) {
	$airtech->woocommerce            = require get_template_directory() . '/inc/woocommerce/class-theme-woocommerce.php';
	$airtech->woocommerce_customizer = require get_template_directory() . '/inc/woocommerce/class-theme-woocommerce-customizer.php';

	require get_template_directory() . '/inc/woocommerce/class-theme-woocommerce-adjacent-products.php';

	require get_template_directory() . '/inc/woocommerce/theme-woocommerce-template-hooks.php';
	require get_template_directory() . '/inc/woocommerce/theme-woocommerce-template-functions.php';
	require get_template_directory() . '/inc/woocommerce/theme-woocommerce-functions.php';
}


add_filter( 'breadcrumb_trail_inline_style', '__return_false' );
