<?php
/**
 * Airtech Customizer Class
 *
 * @package  airtech
 * @since    2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Airtech_Customizer' ) ) :

	/**
	 * The Airtech Customizer class
	 */
	class Airtech_Customizer {

		/**
		 * Setup class.
		 *
		 * @since 1.0
		 */
		public function __construct() {
			add_action( 'customize_register', array( $this, 'customize_register' ), 10 );
			add_filter( 'body_class', array( $this, 'layout_class' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'add_customizer_css' ), 130 );
			add_action( 'customize_controls_print_styles', array( $this, 'customizer_custom_control_css' ) );
			add_action( 'customize_register', array( $this, 'edit_default_customizer_settings' ), 99 );
			add_action( 'enqueue_block_editor_assets', array( $this, 'block_editor_customizer_css' ) );
			add_action( 'init', array( $this, 'default_theme_mod_values' ), 10 );
		}

		/**
		 * Returns an array of the desired default Airtech Options
		 *
		 * @return array
		 */
		public function get_airtech_default_setting_values() {
			return apply_filters(
				'airtech_setting_default_values', $args = array(
					'airtech_layout'                  => 'right',
					'background_color'                => 'ffffff',
				)
			);
		}

		/**
		 * Adds a value to each Airtech setting if one isn't already present.
		 *
		 * @uses get_airtech_default_setting_values()
		 */
		public function default_theme_mod_values() {
			foreach ( $this->get_airtech_default_setting_values() as $mod => $val ) {
				add_filter( 'theme_mod_' . $mod, array( $this, 'get_theme_mod_value' ), 10 );
			}
		}

		/**
		 * Get theme mod value.
		 *
		 * @param string $value Theme modification value.
		 * @return string
		 */
		public function get_theme_mod_value( $value ) {
			$key = substr( current_filter(), 10 );

			$set_theme_mods = get_theme_mods();

			if ( isset( $set_theme_mods[ $key ] ) ) {
				return $value;
			}

			$values = $this->get_airtech_default_setting_values();

			return isset( $values[ $key ] ) ? $values[ $key ] : $value;
		}

		/**
		 * Set Customizer setting defaults.
		 * These defaults need to be applied separately as child themes can filter airtech_setting_default_values
		 *
		 * @param  array $wp_customize the Customizer object.
		 * @uses   get_airtech_default_setting_values()
		 */
		public function edit_default_customizer_settings( $wp_customize ) {
			foreach ( $this->get_airtech_default_setting_values() as $mod => $val ) {
					$wp_customize->get_setting( $mod )->default = $val;
			}
		}

		/**
		 * Add postMessage support for site title and description for the Theme Customizer along with several other settings.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 * @since  1.0.0
		 */
		public function customize_register( $wp_customize ) {

			// Move background color setting alongside background image.
			$wp_customize->get_control( 'background_color' )->section  = 'background_image';
			$wp_customize->get_control( 'background_color' )->priority = 20;

			// Change background image section title & priority.
			$wp_customize->get_section( 'background_image' )->title    = __( 'Body Background', 'airtech' );
			$wp_customize->get_section( 'background_image' )->priority = 30;

			// Selective refresh.
			if ( function_exists( 'add_partial' ) ) {
				$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
				$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

				$wp_customize->selective_refresh->add_partial(
					'custom_logo', array(
						'selector'        => '.site-branding',
						'render_callback' => array( $this, 'get_site_logo' ),
					)
				);

				$wp_customize->selective_refresh->add_partial(
					'blogname', array(
						'selector'        => '.site-title.beta a',
						'render_callback' => array( $this, 'get_site_name' ),
					)
				);

				$wp_customize->selective_refresh->add_partial(
					'blogdescription', array(
						'selector'        => '.site-description',
						'render_callback' => array( $this, 'get_site_description' ),
					)
				);
			}

			/**
			 * Custom controls
			 */
			require_once dirname( __FILE__ ) . '/class-theme-customizer-control-radio-image.php';
			require_once dirname( __FILE__ ) . '/class-theme-customizer-control-arbitrary.php';


			/**
			 * Layout
			 */
			$wp_customize->add_section(
				'airtech_layout', array(
					'title'    => __( 'Layout', 'airtech' ),
					'panel'       => 'js_panel1',
					'priority' => 50,
				)
			);

			$wp_customize->add_setting(
				'airtech_layout', array(
					'default'           => apply_filters( 'airtech_default_layout', $layout = is_rtl() ? 'left' : 'right' ),
					'sanitize_callback' => 'airtech_sanitize_choices',
				)
			);

			$wp_customize->add_control(
				new Airtech_Custom_Radio_Image_Control(
					$wp_customize, 'airtech_layout', array(
						'settings' => 'airtech_layout',
						'section'  => 'airtech_layout',
						'label'    => __( 'General Layout', 'airtech' ),
						'priority' => 1,
						'choices'  => array(
							'right' => get_template_directory_uri() . '/assets/images/customizer/controls/2cr.png',
							'left'  => get_template_directory_uri() . '/assets/images/customizer/controls/2cl.png',
						),
					)
				)
			);

		}

		/**
		 * Get all of the Airtech theme mods.
		 *
		 * @return array $airtech_theme_mods The Airtech Theme Mods.
		 */
		public function get_airtech_theme_mods() {
			$airtech_theme_mods = array(
				'background_color'            => airtech_get_content_background_color(),
			);

			return apply_filters( 'airtech_theme_mods', $airtech_theme_mods );
		}

		/**
		 * Get Customizer css.
		 *
		 * @see get_airtech_theme_mods()
		 * @return array $styles the css
		 */
		public function get_css() {
			$airtech_theme_mods = $this->get_airtech_theme_mods();
			$brighten_factor       = apply_filters( 'airtech_brighten_factor', 25 );
			$darken_factor         = apply_filters( 'airtech_darken_factor', -25 );

			$styles = '

			';

			return apply_filters( 'airtech_customizer_css', $styles );
		}

		/**
		 * Get Gutenberg Customizer css.
		 *
		 * @see get_airtech_theme_mods()
		 * @return array $styles the css
		 */
		public function gutenberg_get_css() {
			$airtech_theme_mods = $this->get_airtech_theme_mods();
			$darken_factor         = apply_filters( 'airtech_darken_factor', -25 );

			// Gutenberg.
			$styles = '
			';

			return apply_filters( 'airtech_gutenberg_customizer_css', $styles );
		}

		/**
		 * Enqueue dynamic colors to use editor blocks.
		 *
		 * @since 2.4.0
		 */
		public function block_editor_customizer_css() {
			$airtech_theme_mods = $this->get_airtech_theme_mods();

			$styles = '
			';

			$styles .= $this->gutenberg_get_css();

			wp_add_inline_style( 'airtech-editor-block-styles', apply_filters( 'airtech_gutenberg_block_editor_customizer_css', $styles ) );
		}

		/**
		 * Add CSS in <head> for styles handled by the theme customizer
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function add_customizer_css() {
			wp_add_inline_style( 'airtech-styles', $this->get_css() );
			wp_add_inline_style( 'airtech-styles', $this->add_blv_custom_css() );
			wp_add_inline_style( 'airtech-gutenberg-blocks', $this->gutenberg_get_css() );
		}


		/**
		 * Get custom css.
		 *
		 * @see get_airtech_theme_mods()
		 * @return array $styles the css
		 */
		public function add_blv_custom_css() {

			$single_bgimage = $global_herobg_css = $widget_css = $single_herobgg = $single_herobg = $single_herobg_css = $global_herobg = $global_herobg_css = $logo_w = $logo_w2 = $cust_colors = $blv_color1_values = $blv_color2_values = $blv_color3_values = $blv_color4_values =  $blv_gen_values = '';

			// Prepare css for customiser pages hero section.
			$global_herobg     = get_theme_mod( 'hero_bg', '' );
			if ( ! is_singular() && '' != $global_herobg ) {
				$global_herobg_css = "
                .breadcrumb_area{
                        background-image:  url('" . esc_url( $global_herobg ) . "');
                }";

			}

			// Prepare css for normal pages hero section.
			$single_herobgg = airtech_meta_value( '_blv_single_bgimage', array( 'limit' => 1) );
			if( is_array($single_herobgg)) {
				$single_herobg = reset( $single_herobgg );
				if ( ! isset( $single_herobg['full_url'] ) || empty( $single_herobg['full_url'] ) ) {
					$single_herobg['full_url'] = '';
				}
				if ( isset( $single_herobg['full_url'] ) ) {
					$single_bgimage = ( '' != $single_herobg['full_url'] ) ? $single_herobg['full_url'] : $global_herobg;
				}
			}
			if( '' != $single_bgimage ) {
				$single_herobg_css = "
                .breadcrumb_area{
                        background-image:  url('" . esc_url( $single_bgimage ) . "');
                }";
			}

			// Prepare logo 1 width css.
			$retina_logo_w = get_theme_mod( 'logo_width', '80' );
			if ( ! empty( $retina_logo_w ) && is_numeric( $retina_logo_w ) ) {
			$logo_w = "
	                .logo.main img{
	                        width:  " . esc_html( $retina_logo_w ) . '%'.";
	                }
					";
			}

			// Prepare logo 2 width css.
			$retina_logo_w2 = get_theme_mod( 'logo_width2', '80' );
			if ( ! empty( $retina_logo_w ) && is_numeric( $retina_logo_w ) ) {
			$logo_w2 = "
	                .header_area .logo2 img{
	                        width:  " . esc_html( $retina_logo_w ) . '%'.";
	                }
					";
			}

			// Prepare css for widget addons.
			$widget_css = get_theme_mod( 'airtech_widget_css', '' );
			$widget_css = trim( preg_replace( '#<style[^>]*>(.*)</style>#is', '$1', $widget_css ) );


			// Prepare css for theme colors.
			if( get_theme_mod( 'enable_colors', '0' ) ) {

				$blv_color1 = get_theme_mod( 'blv_color1', '' );
				if ( ! empty( $blv_color1 ) ) {

					$blv_color1_values = '

					.center_title_big h2, .single_title.blue h2, .main_title h2, .single_border_title h2, .slider_text_box .slider_box h4, .choose_contract_area .contract_part .contract_text h4, .choose_contract_area .contract_part .contract_text .nav li a, .finance_area .finance_inner h2, .free_estimate h3, .tips_list_inner p, .tips_artical h4, .tips_artical .nav li a, .rp_box_item h4, .experience_inner .experience_text h3, .ab_text_inner .ab_text_item h3, .ab_text_inner .ab_text_item_two h3, .ab_list h4, .ab_list .nav li a, .service_raw_text h4, .service_raw_text p, .m_service_item .service_text h4, .s_details_inner .s_details_main h4, .s_details_main h4, .maintence_column .maintence_text h4, .maintence_column .maintence_text .nav li a, .repair_service_area .rp_text h6, .blog_item .blog_text h4, .r_title h3, .single_title h3, .faq_title h3, .search_area .search_box_inner h3, .main_menu .navbar .nav.navbar-nav li.submenu .dropdown-menu li a, .main_menu .navbar .nav.navbar-nav li.submenu .dropdown-menu .submenu .dropdown-menu li a, .slider_text_box .slider_box h6, .experience_inner .experience_text h5, .request_service_box
					{
						color: ' . $blv_color1 . ';
					}
					.c_details_inner, .gallery_area.blue_gallery, .box_testi .title, .free_consultation .title_top, .new_blog_area, .scrollup,.replacement_area
					{
						background-color: ' . $blv_color1 . ';
					}
					.question_form_area .contact_us_form .form-group input:not(.submit_btn), .question_form_area .contact_us_form .form-group textarea, .logo_part, .logo_part:before, .free_consultation .title_top:before, .tt-object
					{
						border-color: ' . $blv_color1 . ';
					}
					.main_menu .navbar {
					    background: ' . $blv_color1 . ' !important;
					}
					.logo_part {
					    background: ' . airtech_adjust_color_brightness($blv_color1, -25). ';
					    border-color: ' . airtech_adjust_color_brightness($blv_color1, -25). ';
					}

';

				}

				$blv_color2 = get_theme_mod( 'blv_color2', '' );
				if ( ! empty( $blv_color2 ) ) {

					$blv_color2_values = '

					.blog_item .blog_text .nav li a i, .blog_item .blog_text .nav li a:hover, .text_item_box i, .g_fillter .nav li.is-checked, .g_fillter .nav li:hover, .g_fillter .nav li.active, .home_banner_inner .left_text h5, .breadcrumb_area .nav li a, .slider-home5 .bdt-slideshow-content-wrapper .bdt-slideshow-title span, .b_testi h5, .text_item_box i
					{
					    color: ' . $blv_color2 . ';
					}

					contact_wd, .contact_wd .text, .award_box .col-lg-4:last-child, .g_fillter .nav li:before, .header_area.navbar_fixed .main_menu, .main_menu .navbar, .contract_discount a, .repair_system_area .center_title_big:before, .emergency_call_area, .emergency_call_area .right h5
					{
						background-color: ' . $blv_color2 . ';
					}

					.contact_wd .text:after
					{
						border-color: ' . $blv_color2 . ';
					}
					.main_menu .navbar:before, .main_menu .navbar .nav.navbar-nav li a:after { display: none; }
					';

				}

				$blv_color3 = get_theme_mod( 'blv_color3', '' );
				if ( ! empty( $blv_color3 ) ) {

					$blv_color3_values = '

					.contact_widget .footer_address p, .contact_widget .footer_address p a, .link_widget .nav li a, .company_text .company_text_part p, .logo_part .logo_inner .right .media .media-body h4
					{
						 color: ' . $blv_color3 . ';
					}
					';

				}

				$blv_color4 = get_theme_mod( 'blv_color4', '' );
				if ( ! empty( $blv_color4 ) ) {

					$blv_color4_values = '

					.main_menu .navbar .nav.navbar-nav li.submenu .dropdown-menu li:hover a,  .ab_bar_btn, .more_btn, .more_btn:hover, .specials_inner .coupons_list .nav li a:hover, .free_es_item .media .media-body h4, .ab_list .nav li a:hover , .maintence_column .maintence_text .nav li:hover a, .award_box .col-lg-4:nth-child(2), .benefit_service .nav li a:hover, .blog_item:hover .blog_text h4, .categories_widget .list li:hover a, .single_element_text p a, .s_comment_list .s_comment_list_inner .media .media-body .date_rep a:last-child, .s_comment_area .s_comment_inner .contact_us_form .form-group .submit_btn:hover, .ap_title span, .modal-message .modal-dialog .modal-content .modal-header h2, .link_widget .nav li:hover a, .footer_copyright a:hover,.footer_copyright .right a:hover, .finance_area .finance_inner .big,.slider-home2 .bdt-slideshow-content-wrapper .bdt-slideshow-text a, .slider_text_box .slider_box h5, .b_testi h3, .more_btn,  .main_btn:hover, .submit_btn:hover, .slider-home2 .bdt-slideshow-content-wrapper .bdt-slideshow-text a, .slider_text_box .slider_box h5, .free_consultation .contact_us_form .form-group .submit_btn:hover, .replacement_area .media .media-body h5 a
					{
					color: ' . $blv_color4 . ';
					}

					.main_menu .navbar .nav.navbar-nav li.submenu .dropdown-menu li a:before, .main_menu .navbar .nav.navbar-nav li.submenu .dropdown-menu .submenu .dropdown-menu li:hover a, .ab_bar_btn:before, .rp_box_item:hover .icon i, .family_area .family_air_text .main_btn:hover, .list_wd .nav li:hover a, .list_wd .nav li.active a, .service_slider_area .service_slider .service_arrow .owl-prev:hover, .service_slider_area .service_slider .service_arrow .owl-next:hover, .tags_widget .list li:hover a, .team_item .team_img:before, .youtube_video a, .youtube_video a:after, .single_border_title h2:before, .main_menu .navbar .nav.navbar-nav.navbar-right li.request_btn a, .contract_discount h4, .box_testi .title h4, .gallery_item a:before, .single_border_title h2:before, .main_btn, .submit_btn, .schedule_box, .schedule_box .contact_us_form .form-group input:not(.submit_btn), .schedule_box .contact_us_form .form-group textarea, .contract_discount h4 , .box_testi .title h4, .free_consultation .contact_us_form .form-group .submit_btn, .our_moto_area.moto_video .left_side a .our_moto_area.moto_video .left_side a:after, .award_box .col-lg-4:nth-child(2)
					{
						background-color: ' . $blv_color4 . ';
					}

					.list_wd .nav , .service_slider_area .service_slider .service_arrow .owl-prev:hover, .service_slider_area .service_slider .service_arrow .owl-next:hover, .tags_widget .list li:hover a, .youtube_video a:before, .main_menu .navbar .nav.navbar-nav.navbar-right li.request_btn a:before, box_testi .title h4:before, .main_btn, .main_btn:hover, .submit_btn, .submit_btn:hover, .schedule_box .contact_us_form .form-group input:not(.submit_btn), .schedule_box .contact_us_form .form-group textarea, .box_testi .title h4:before, .free_consultation .contact_us_form .form-group .submit_btn, .replacement_area, .our_moto_area.moto_video .left_side a:before, .m_service_item, .c_testi_slider .item .b_testi
					{
							border-color: ' . $blv_color4 . ';
					}
					';

				}
				$blv_gen_values = '
					.team_item .team_img:hover:before, .gallery_item a:hover:before{
						opacity:.9;
					}
					.our_moto_area.moto_video .left_side a:after, .youtube_video a:before{
						opacity:.8;
					}

					';
				$cust_colors  = $blv_color1_values . $blv_color2_values . $blv_color3_values . $blv_color4_values . $blv_gen_values;
				// Output styles
				if ( isset( $cust_colors ) && $cust_colors != '' ) {
					$cust_colors = strip_tags( $cust_colors );
					// Remove space after colons
					$cust_colors = str_replace( ': ', ':', $cust_colors );
					// Remove whitespace
					$cust_colors = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '   ', '    ' ), '', $cust_colors );
				}
			}

			// Generating final output.
			$styles = $global_herobg_css . $single_herobg_css . $widget_css . $logo_w . $logo_w2 . $cust_colors;

			return apply_filters( 'airtech_custom_css', $styles );
		}
		/**
		 * Layout classes
		 * Adds 'right-sidebar' and 'left-sidebar' classes to the body tag
		 *
		 * @param  array $classes current body classes.
		 * @return string[]          modified body classes
		 * @since  1.0.0
		 */
		public function layout_class( $classes ) {
			$left_or_right = get_theme_mod( 'airtech_layout' );

			$classes[] = $left_or_right . '-sidebar';

			return $classes;
		}

		/**
		 * Add CSS for custom controls
		 *
		 * This function incorporates CSS from the Kirki Customizer Framework
		 *
		 * The Kirki Customizer Framework, Copyright Aristeides Stathopoulos (@aristath),
		 * is licensed under the terms of the GNU GPL, Version 2 (or later)
		 *
		 * @link https://github.com/reduxframework/kirki/
		 * @since  1.5.0
		 */
		public function customizer_custom_control_css() {
			?>
			<style>
			.customize-control-radio-image input[type=radio] {
				display: none;
			}

			.customize-control-radio-image label {
				display: block;
				width: 48%;
				float: left;
				margin-right: 4%;
			}

			.customize-control-radio-image label:nth-of-type(2n) {
				margin-right: 0;
			}

			.customize-control-radio-image img {
				opacity: .5;
			}

			.customize-control-radio-image input[type=radio]:checked + label img,
			.customize-control-radio-image img:hover {
				opacity: 1;
			}

			</style>
			<?php
		}

		/**
		 * Get site logo.
		 *
		 * @since 2.1.5
		 * @return string
		 */
		public function get_site_logo() {
			return airtech_site_title_or_logo( false );
		}

		/**
		 * Get site name.
		 *
		 * @since 2.1.5
		 * @return string
		 */
		public function get_site_name() {
			return get_bloginfo( 'name', 'display' );
		}

		/**
		 * Get site description.
		 *
		 * @since 2.1.5
		 * @return string
		 */
		public function get_site_description() {
			return get_bloginfo( 'description', 'display' );
		}

		/**
		 * Check if current page is using the Homepage template.
		 *
		 * @since 2.3.0
		 * @return bool
		 */
		public function is_homepage_template() {
			$template = get_post_meta( get_the_ID(), '_wp_page_template', true );

			if ( ! $template || 'template-homepage.php' !== $template || ! has_post_thumbnail( get_the_ID() ) ) {
				return false;
			}

			return true;
		}

		/**
		 * Setup the WordPress core custom header feature.
		 *
		 * @deprecated 2.4.0
		 * @return void
		 */
		public function custom_header_setup() {
			if ( function_exists( 'wc_deprecated_function' ) ) {
				wc_deprecated_function( __FUNCTION__, '2.4.0' );
			} else {
				_deprecated_function( __FUNCTION__, '2.4.0' );
			}
		}

		/**
		 * Get Customizer css associated with WooCommerce.
		 *
		 * @deprecated 2.4.0
		 * @return void
		 */
		public function get_woocommerce_css() {
			if ( function_exists( 'wc_deprecated_function' ) ) {
				wc_deprecated_function( __FUNCTION__, '2.3.1' );
			} else {
				_deprecated_function( __FUNCTION__, '2.3.1' );
			}
		}

		/**
		 * Assign Airtech styles to individual theme mods.
		 *
		 * @deprecated 2.3.1
		 * @return void
		 */
		public function set_airtech_style_theme_mods() {
			if ( function_exists( 'wc_deprecated_function' ) ) {
				wc_deprecated_function( __FUNCTION__, '2.3.1' );
			} else {
				_deprecated_function( __FUNCTION__, '2.3.1' );
			}
		}
	}

endif;

return new Airtech_Customizer();
