<?php
/**
 * The header.
 *
 * @package airtech
 */

?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2.0">
<link rel="profile" href="//gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
<?php do_action( 'airtech_head' ); ?>
</head>

<body <?php body_class(); ?>>

<?php if( function_exists('airtech_tt_preloader')) echo airtech_tt_preloader(); ?>

<?php

	$hdr_type = airtech_get_hdr_type();
	// load appropriate header template
	if( empty($hdr_type) || $hdr_type == 'default' )      get_template_part( 'template-parts/header1' );
	if( $hdr_type == 'header2' )                          get_template_part( 'template-parts/header2' );
	if( $hdr_type == 'header3' )                          get_template_part( 'template-parts/header3' );
	if( $hdr_type == 'header4' )                          get_template_part( 'template-parts/header4' );

?>

	<?php do_action( 'airtech_heroarea' ); ?>

	<div id="content" class="site-content" tabindex="-1">
		<div class="<?php echo ( is_singular('page') && airtech_is_elementor_page() ) ? 'liquid' : 'col-full';?> ">

		<?php do_action( 'airtech_content_top' );

