<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package airtech
 */

?>

		</div><!-- .col-full -->
	</div><!-- #content -->

	<?php if ( '1' == get_theme_mod('enable_cust_ftr', '0') && ( function_exists( 'hfe_footer_enabled' ) && true == hfe_footer_enabled()) ): ?>
		<?php echo hfe_render_footer(); ?>
	<?php else: ?>

	<?php do_action( 'airtech_before_footer' ); ?>

	<footer id="colophon" class="site-footer" role="contentinfo">

				<?php
				/**
				 * Functions hooked in to airtech_footer action
				 *
				 * @hooked airtech_footer_widgets - 10
				 * @hooked airtech_credit         - 20
				 */
				do_action( 'airtech_footer' );
				?>

		<div class="footer-info">
			<div class="col-full">
				<div class="row-1 col-2 fix">

	                <div class="block ftr-left">
					<?php if( '1' == get_theme_mod('enable_ftr_left', '0' )) {
						echo do_shortcode( wp_kses(get_theme_mod('enable_ftr_left_text'), airtech_blv_allowed_tags()));
						} else {
							bloginfo(); ?> &copy; <?php echo date( 'Y' ) . esc_html__( ' All Rights Reserved.', 'airtech' );
					} ?>
	                </div>
	                <div class="block ftr-right">
					<?php if( '1' == get_theme_mod('enable_ftr_right', '0' )) {
						echo do_shortcode( wp_kses(get_theme_mod('enable_ftr_right_text'), airtech_blv_allowed_tags()));
						} else {
							sprintf( esc_html__( 'Powered by %s', 'airtech' ), '<a href="' . esc_url( 'https://bolvo.com' ).'">'.esc_html__( 'Bolvo.com', 'airtech' ).'</a>' );
					} ?>
	                </div>

				</div><!-- .row-1 col-2 fix -->
			</div><!-- .col-full -->
		</div><!-- .footer-inner -->
	</footer><!-- #colophon -->

	<?php do_action( 'airtech_after_footer' ); ?>

	<?php endif; ?>

<?php if ( (true == get_theme_mod( 'enable_search3', true)) || (true == get_theme_mod( 'enable_search4', true ) )) { ?>
<!--================Search Box Area =================-->
<div class="search_area zoom-anim-dialog mfp-hide" id="hdr-search">
    <div class="search_box_inner">
        <h3><?php echo esc_attr_x( 'Search', 'label', 'airtech' ) ?></h3>
        <div class="input-group">
	        <input type="hidden" name="post_type" value="post">
	        <input type="search" class="search-field form-control"
	            placeholder="<?php echo esc_attr_x( 'Search ...', 'placeholder', 'airtech' ) ?>"
	            value="<?php echo get_search_query() ?>" name="s"
	            title="<?php echo esc_attr_x( 'Search for:', 'label', 'airtech' ) ?>" />

            <span class="input-group-btn">
                <button class="btn btn-default" type="button"><i class="icon icon-Search"></i></button>
            </span>
        </div>
    </div>
</div>
<!--================End Search Box Area =================-->
<?php }?>
<?php if ( true == get_theme_mod( 'enable_scrolltop', true)) { ?>
<a href="#" class="scrollup"></a>
<?php } ?>
<?php wp_footer(); ?>

</body>
</html>