<?php
$config = accu_kirki_config();

ACCU_Kirki::add_section( 'dt_site_layout_section', array(
	'title' => esc_html__( 'Site Layout', 'accu' ),
	'priority' => 20
) );

	# site-layout
	ACCU_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'site-layout',
		'label'    => esc_html__( 'Site Layout', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'default'  => accu_defaults('site-layout'),
		'choices' => array(
			'boxed' =>  ACCU_THEME_URI.'/kirki/assets/images/site-layout/boxed.png',
			'wide' => ACCU_THEME_URI.'/kirki/assets/images/site-layout/wide.png',
		)
	));

	# site-boxed-layout
	ACCU_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'site-boxed-layout',
		'label'    => esc_html__( 'Customize Boxed Layout?', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'default'  => '1',
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'accu' ),
			'off' => esc_attr__( 'No', 'accu' )
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
		)			
	));

	# body-bg-type
	ACCU_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-type',
		'label'    => esc_html__( 'Background Type', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'multiple' => 1,
		'default'  => 'none',
		'choices'  => array(
			'pattern' => esc_attr__( 'Predefined Patterns', 'accu' ),
			'upload' => esc_attr__( 'Set Pattern', 'accu' ),
			'none' => esc_attr__( 'None', 'accu' ),
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-pattern
	ACCU_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'body-bg-pattern',
		'label'    => esc_html__( 'Predefined Patterns', 'accu' ),
		'description'    => esc_html__( 'Add Background for body', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'choices' => array(
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg',
			ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg'=> ACCU_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg',
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'pattern' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)						
	));

	# body-bg-image
	ACCU_Kirki::add_field( $config, array(
		'type' => 'image',
		'settings' => 'body-bg-image',
		'label'    => esc_html__( 'Background Image', 'accu' ),
		'description'    => esc_html__( 'Add Background Image for body', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'upload' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-position
	ACCU_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-position',
		'label'    => esc_html__( 'Background Position', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-position' )
		),
		'default' => 'center',
		'multiple' => 1,
		'choices' => accu_image_positions(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload') ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-repeat
	ACCU_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-repeat',
		'label'    => esc_html__( 'Background Repeat', 'accu' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-repeat' )
		),
		'default' => 'repeat',
		'multiple' => 1,
		'choices' => accu_image_repeats(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload' ) ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));	