<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => constant('ACCU_THEME_NAME').' '.esc_html__('Options', 'accu'),
  'menu_type'       => 'theme', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'cs-framework',
  'ajax_save'       => true,
  'show_reset_all'  => false,
  'framework_title' => sprintf( esc_html__('Designthemes Framework %sby Designthemes%s', 'accu'), '<small>', '</small>')
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();

$options[]      = array(
  'name'        => 'general',
  'title'       => esc_html__('General', 'accu'),
  'icon'        => 'fa fa-gears',

  'fields'      => array(

	array(
	  'type'    => 'subheading',
	  'content' => esc_html__( 'General Options', 'accu' ),
	),
	
	array(
		'id'	=> 'header',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Header', 'accu'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_headers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Header', 'accu'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select default header.','accu'),
	),
	
	array(
		'id'	=> 'footer',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Footer', 'accu'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_footers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Footer', 'accu'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select defaultfooter.','accu'),
	),

	array(
	  'id'  	 => 'use-fixed-footer',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Fixed Footer', 'accu'),
	  'info'	 => esc_html__('YES! to use fixed footer.', 'accu')
	),

	array(
	  'id'  	 => 'use-site-loader',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Site Loader', 'accu'),
	  'info'	 => esc_html__('YES! to use site loader.', 'accu')
	),	

	array(
	  'id'  	 => 'enable-stylepicker',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Style Picker', 'accu'),
	  'info'	 => esc_html__('YES! to show the style picker.', 'accu')
	),		

	array(
	  'id'  	 => 'show-pagecomments',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Globally Show Page Comments', 'accu'),
	  'info'	 => esc_html__('YES! to show comments on all the pages. This will globally override your "Allow comments" option under your page "Discussion" settings.', 'accu'),
	  'default'  => true,
	),

	array(
	  'id'  	 => 'showall-pagination',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Show all pages in Pagination', 'accu'),
	  'info'	 => esc_html__('YES! to show all the pages instead of dots near the current page.', 'accu')
	),



	array(
	  'id'      => 'google-map-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Google Map API Key', 'accu'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid google account api key here', 'accu').'</p>',
	),

	array(
	  'id'      => 'mailchimp-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Mailchimp API Key', 'accu'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid mailchimp account api key here', 'accu').'</p>',
	),

  ),
);

$options[]      = array(
  'name'        => 'layout_options',
  'title'       => esc_html__('Layout Options', 'accu'),
  'icon'        => 'dashicons dashicons-exerpt-view',
  'sections' => array(

	// -----------------------------------------
	// Header Options
	// -----------------------------------------
	array(
	  'name'      => 'breadcrumb_options',
	  'title'     => esc_html__('Breadcrumb Options', 'accu'),
	  'icon'      => 'fa fa-sitemap',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Breadcrumb Options", 'accu' ),
		  ),

		  array(
			'id'  		 => 'show-breadcrumb',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Breadcrumb', 'accu'),
			'info'		 => esc_html__('YES! to display breadcrumb for all pages.', 'accu'),
			'default' 	 => true,
		  ),

		  array(
			'id'           => 'breadcrumb-delimiter',
			'type'         => 'icon',
			'title'        => esc_html__('Breadcrumb Delimiter', 'accu'),
			'info'         => esc_html__('Choose delimiter style to display on breadcrumb section.', 'accu'),
		  ),

		  array(
			'id'           => 'breadcrumb-style',
			'type'         => 'select',
			'title'        => esc_html__('Breadcrumb Style', 'accu'),
			'options'      => array(
			  'default' 							=> esc_html__('Default', 'accu'),
			  'aligncenter'    						=> esc_html__('Align Center', 'accu'),
			  'alignright'  						=> esc_html__('Align Right', 'accu'),
			  'breadcrumb-left'    					=> esc_html__('Left Side Breadcrumb', 'accu'),
			  'breadcrumb-right'     				=> esc_html__('Right Side Breadcrumb', 'accu'),
			  'breadcrumb-top-right-title-center'  	=> esc_html__('Top Right Title Center', 'accu'),
			  'breadcrumb-top-left-title-center'  	=> esc_html__('Top Left Title Center', 'accu'),
			),
			'class'        => 'chosen',
			'default'      => 'aligncenter',
			'info'         => esc_html__('Choose alignment style to display on breadcrumb section.', 'accu'),
		  ),

		  array(
			  'id'                 => 'breadcrumb-position',
			  'type'               => 'select',
			  'title'              => esc_html__('Position', 'accu' ),
			  'options'            => array(
				  'header-top-absolute'    => esc_html__('Behind the Header','accu'),
				  'header-top-relative'    => esc_html__('Default','accu'),
			  ),
			  'class'        => 'chosen',
			  'default'      => 'header-top-absolute',
			  'info'         => esc_html__('Choose position of breadcrumb section.', 'accu'),
		  ),

		  array(
			'id'    => 'breadcrumb_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'accu'),
			'desc'  => esc_html__('Choose background options for breadcrumb title section.', 'accu')
		  ),

		),
	),

  ),
);

$options[]      = array(
  'name'        => 'allpage_options',
  'title'       => esc_html__('All Page Options', 'accu'),
  'icon'        => 'fa fa-files-o',
  'sections' => array(

	// -----------------------------------------
	// Post Options
	// -----------------------------------------
	array(
	  'name'      => 'post_options',
	  'title'     => esc_html__('Post Options', 'accu'),
	  'icon'      => 'fa fa-file',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Single Post Options", 'accu' ),
		  ),
		
		  array(
			'id'  		 => 'single-post-authorbox',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Author Box', 'accu'),
			'info'		 => esc_html__('YES! to display author box in single blog posts.', 'accu')
		  ),

		  array(
			'id'  		 => 'single-post-related',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Related Posts', 'accu'),
			'info'		 => esc_html__('YES! to display related blog posts in single posts.', 'accu')
		  ),

		  array(
			'id'  		 => 'single-post-navigation',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Post Navigation', 'accu'),
			'info'		 => esc_html__('YES! to display post navigation in single posts.', 'accu')
		  ),

		  array(
			'id'  		 => 'single-post-comments',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Posts Comments', 'accu'),
			'info'		 => esc_html__('YES! to display single blog post comments.', 'accu'),
			'default' 	 => true,
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Post Archives Page Layout", 'accu' ),
		  ),

		  array(
			'id'      	 => 'post-archives-page-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Page Layout', 'accu'),
			'options'    => array(
			  'content-full-width'   => ACCU_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => ACCU_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'post-archives-page-layout',
			),
		  ),

		  array(
			'id'  		 => 'show-standard-left-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Left Sidebar', 'accu'),
			'dependency' => array( 'post-archives-page-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  		 => 'show-standard-right-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Right Sidebar', 'accu'),
			'dependency' => array( 'post-archives-page-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Post Archives Post Layout", 'accu' ),
		  ),

		  array(
			'id'      	   => 'post-archives-post-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Post Layout', 'accu'),
			'options'      => array(
			  'one-column' 		  => ACCU_THEME_URI . '/cs-framework-override/images/one-column.png',
			  'one-half-column'   => ACCU_THEME_URI . '/cs-framework-override/images/one-half-column.png',
			  'one-third-column'  => ACCU_THEME_URI . '/cs-framework-override/images/one-third-column.png',
			  '1-2-2'			  => ACCU_THEME_URI . '/cs-framework-override/images/1-2-2.png',
			  '1-2-2-1-2-2' 	  => ACCU_THEME_URI . '/cs-framework-override/images/1-2-2-1-2-2.png',
			  '1-3-3-3'			  => ACCU_THEME_URI . '/cs-framework-override/images/1-3-3-3.png',
			  '1-3-3-3-1' 		  => ACCU_THEME_URI . '/cs-framework-override/images/1-3-3-3-1.png',
			),
			'default'      => 'one-half-column',
		  ),

		  array(
			'id'           => 'post-style',
			'type'         => 'select',
			'title'        => esc_html__('Post Style', 'accu'),
			'options'      => array(
			  'blog-default-style' 		=> esc_html__('Default', 'accu'),
			  'entry-date-left'      	=> esc_html__('Date Left', 'accu'),
			  'entry-date-left outer-frame-border'      	=> esc_html__('Date Left Modern', 'accu'),
			  'entry-date-author-left'  => esc_html__('Date and Author Left', 'accu'),
			  'blog-modern-style'       => esc_html__('Modern', 'accu'),
			  'bordered'      			=> esc_html__('Bordered', 'accu'),
			  'classic'      			=> esc_html__('Classic', 'accu'),
			  'entry-overlay-style' 	=> esc_html__('Trendy', 'accu'),
			  'overlap' 				=> esc_html__('Overlap', 'accu'),
			  'entry-center-align'		=> esc_html__('Stripe', 'accu'),
			  'entry-fashion-style'	 	=> esc_html__('Fashion', 'accu'),
			  'entry-minimal-bordered' 	=> esc_html__('Minimal Bordered', 'accu'),
			  'blog-medium-style'       => esc_html__('Medium', 'accu'),
			  'blog-medium-style dt-blog-medium-highlight'     					 => esc_html__('Medium Hightlight', 'accu'),
			  'blog-medium-style dt-blog-medium-highlight dt-sc-skin-highlight'  => esc_html__('Medium Skin Highlight', 'accu'),
			),
			'class'        => 'chosen',
			'default'      => 'blog-default-style',
			'info'         => esc_html__('Choose post style to display post archives pages.', 'accu'),
		  ),

		  array(
			'id'  		 => 'post-archives-enable-excerpt',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Allow Excerpt', 'accu'),
			'info'		 => esc_html__('YES! to allow excerpt', 'accu'),
			'default'    => true,
		  ),

		  array(
			'id'  		 => 'post-archives-excerpt',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Excerpt Length', 'accu'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Put Excerpt Length', 'accu').'</span>',
			'default' 	 => 40,
		  ),

		  array(
			'id'  		 => 'post-archives-enable-readmore',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Read More', 'accu'),
			'info'		 => esc_html__('YES! to enable read more button', 'accu'),
			'default'	 => true,
		  ),

		  array(
			'id'  		 => 'post-archives-readmore',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Read More Shortcode', 'accu'),
			'info'		 => esc_html__('Paste any button shortcode here', 'accu'),
			'default'	 => '[dt_sc_button title="'.esc_attr__('Read More', 'accu').'" style="fully-rounded-corner" size="medium" class="type1"]',
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Single Post & Post Archive options", 'accu' ),
		  ),

		  array(
			'id'      => 'post-format-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Post Format Meta', 'accu' ),
			'info'	  => esc_html__('YES! to show post format meta information', 'accu'),
			'default' => false
		  ),

		  array(
			'id'      => 'post-author-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Author Meta', 'accu' ),
			'info'	  => esc_html__('YES! to show post author meta information', 'accu'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-date-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Date Meta', 'accu' ),
			'info'	  => esc_html__('YES! to show post date meta information', 'accu'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-comment-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Comment Meta', 'accu' ),
			'info'	  => esc_html__('YES! to show post comment meta information', 'accu'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-category-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Category Meta', 'accu' ),
			'info'	  => esc_html__('YES! to show post category information', 'accu'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-tag-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Tag Meta', 'accu' ),
			'info'	  => esc_html__('YES! to show post tag information', 'accu'),
			'default' => true
			),
			
			array(
				'id'      => 'post-likes',
				'type'    => 'switcher',
				'title'   => esc_html__('Post Likes', 'accu' ),
				'info'    => esc_html__('YES! to show post likes information', 'accu'),
				'default' => true
			),

			array(
				'id'      => 'post-views',
				'type'    => 'switcher',
				'title'   => esc_html__('Post Views', 'accu' ),
				'info'    => esc_html__('YES! to show post views information', 'accu'),
				'default' => true
			),

		),
	),

	// -----------------------------------------
	// 404 Options
	// -----------------------------------------
	array(
	  'name'      => '404_options',
	  'title'     => esc_html__('404 Options', 'accu'),
	  'icon'      => 'fa fa-warning',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "404 Message", 'accu' ),
		  ),
		  
		  array(
			'id'      => 'enable-404message',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Message', 'accu' ),
			'info'	  => esc_html__('YES! to enable not-found page message.', 'accu'),
			'default' => true
		  ),

		  array(
			'id'           => 'notfound-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'accu'),
			'options'      => array(
			  'type1' 	   => esc_html__('Modern', 'accu'),
			  'type2'      => esc_html__('Classic', 'accu'),
			  'type4'  	   => esc_html__('Diamond', 'accu'),
			  'type5'      => esc_html__('Shadow', 'accu'),
			  'type6'      => esc_html__('Diamond Alt', 'accu'),
			  'type7'  	   => esc_html__('Stack', 'accu'),
			  'type8'  	   => esc_html__('Minimal', 'accu'),
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of not-found template page.', 'accu')
		  ),

		  array(
			'id'      => 'notfound-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('404 Dark BG', 'accu' ),
			'info'	  => esc_html__('YES! to use dark bg notfound page for this site.', 'accu')
		  ),

		  array(
			'id'           => 'notfound-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'accu'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'accu'),
			'info'       	 => esc_html__('Choose the page for not-found content.', 'accu')
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Background Options", 'accu' ),
		  ),

		  array(
			'id'    => 'notfound_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'accu')
		  ),

		  array(
			'id'  		 => 'notfound-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'accu'),
			'info'		 => esc_html__('Paste custom CSS styles for not found page.', 'accu')
		  ),

		),
	),

	// -----------------------------------------
	// Underconstruction Options
	// -----------------------------------------
	array(
	  'name'      => 'comingsoon_options',
	  'title'     => esc_html__('Under Construction Options', 'accu'),
	  'icon'      => 'fa fa-thumbs-down',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Under Construction", 'accu' ),
		  ),
	
		  array(
			'id'      => 'enable-comingsoon',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Coming Soon', 'accu' ),
			'info'	  => esc_html__('YES! to check under construction page of your website.', 'accu')
		  ),
	
		  array(
			'id'           => 'comingsoon-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'accu'),
			'options'      => array(
			  'type1' 	   => esc_html__('Diamond', 'accu'),
			  'type2'      => esc_html__('Teaser', 'accu'),
			  'type3'  	   => esc_html__('Minimal', 'accu'),
			  'type4'      => esc_html__('Counter Only', 'accu'),
			  'type5'      => esc_html__('Belt', 'accu'),
			  'type6'  	   => esc_html__('Classic', 'accu'),
			  'type7'  	   => esc_html__('Boxed', 'accu')
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of coming soon template.', 'accu'),
		  ),

		  array(
			'id'      => 'uc-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('Coming Soon Dark BG', 'accu' ),
			'info'	  => esc_html__('YES! to use dark bg coming soon page for this site.', 'accu')
		  ),

		  array(
			'id'           => 'comingsoon-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'accu'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'accu'),
			'info'       	 => esc_html__('Choose the page for comingsoon content.', 'accu')
		  ),

		  array(
			'id'      => 'show-launchdate',
			'type'    => 'switcher',
			'title'   => esc_html__('Show Launch Date', 'accu' ),
			'info'	  => esc_html__('YES! to show launch date text.', 'accu'),
		  ),

		  array(
			'id'      => 'comingsoon-launchdate',
			'type'    => 'text',
			'title'   => esc_html__('Launch Date', 'accu'),
			'attributes' => array( 
			  'placeholder' => '10/30/2016 12:00:00'
			),
			'after' 	=> '<p class="cs-text-info">'.esc_html__('Put Format: 12/30/2016 12:00:00 month/day/year hour:minute:second', 'accu').'</p>',
		  ),

		  array(
			'id'           => 'comingsoon-timezone',
			'type'         => 'select',
			'title'        => esc_html__('UTC Timezone', 'accu'),
			'options'      => array(
			  '-12' => '-12', '-11' => '-11', '-10' => '-10', '-9' => '-9', '-8' => '-8', '-7' => '-7', '-6' => '-6', '-5' => '-5', 
			  '-4' => '-4', '-3' => '-3', '-2' => '-2', '-1' => '-1', '0' => '0', '+1' => '+1', '+2' => '+2', '+3' => '+3', '+4' => '+4',
			  '+5' => '+5', '+6' => '+6', '+7' => '+7', '+8' => '+8', '+9' => '+9', '+10' => '+10', '+11' => '+11', '+12' => '+12'
			),
			'class'        => 'chosen',
			'default'      => '0',
			'info'         => esc_html__('Choose utc timezone, by default UTC:00:00', 'accu'),
		  ),

		  array(
			'id'    => 'comingsoon_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'accu')
		  ),

		  array(
			'id'  		 => 'comingsoon-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'accu'),
			'info'		 => esc_html__('Paste custom CSS styles for under construction page.', 'accu'),
		  ),

		),
	),

  ),
);

// -----------------------------------------
// Widget area Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'widgetarea_options',
  'title'       => esc_html__('Widget Area', 'accu'),
  'icon'        => 'fa fa-trello',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Widget Area for Sidebar", 'accu' ),
	  ),

	  array(
		'id'           => 'wtitle-style',
		'type'         => 'select',
		'title'        => esc_html__('Sidebar widget Title Style', 'accu'),
		'options'      => array(
			'default' => esc_html__('Choose any type', 'accu'),
			'type1'   => esc_html__('Double Border', 'accu'),
			'type2'   => esc_html__('Tooltip', 'accu'),
			'type3'   => esc_html__('Title Top Border', 'accu'),
			'type4'   => esc_html__('Left Border & Pattren', 'accu'),
			'type5'   => esc_html__('Bottom Border', 'accu'),
			'type6'   => esc_html__('Tooltip Border', 'accu'),
			'type7'   => esc_html__('Boxed Modern', 'accu'),
			'type8'   => esc_html__('Elegant Border', 'accu'),
			'type9'   => esc_html__('Needle', 'accu'),
			'type10'  => esc_html__('Ribbon', 'accu'),
			'type11'  => esc_html__('Content Background', 'accu'),
			'type12'  => esc_html__('Classic BG', 'accu'),
			'type13'  => esc_html__('Tiny Boders', 'accu'),
			'type14'  => esc_html__('BG & Border', 'accu'),
			'type15'  => esc_html__('Classic BG Alt', 'accu'),
			'type16'  => esc_html__('Left Border & BG', 'accu'),
			'type17'  => esc_html__('Basic', 'accu'),
			'type18'  => esc_html__('BG & Pattern', 'accu'),
		),
		'class'   => 'chosen',
		'default' => 'type1',
		'info'    => esc_html__('Choose the style of sidebar widget title.', 'accu')
	  ),

	  array(
		'id'              => 'widgetarea-custom',
		'type'            => 'group',
		'title'           => esc_html__('Custom Widget Area', 'accu'),
		'button_title'    => esc_html__('Add New', 'accu'),
		'accordion_title' => esc_html__('Add New Widget Area', 'accu'),
		'fields'          => array(

		  array(
			'id'          => 'widgetarea-custom-name',
			'type'        => 'text',
			'title'       => esc_html__('Name', 'accu'),
		  ),

		)
	  ),

	),
);

// -----------------------------------------
// Woocommerce Options
// -----------------------------------------
if( function_exists( 'is_woocommerce' ) && ! class_exists ( 'DTWooPlugin' ) ){

	$options[]      = array(
	  'name'        => 'woocommerce_options',
	  'title'       => esc_html__('Woocommerce', 'accu'),
	  'icon'        => 'fa fa-shopping-cart',

	  'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Woocommerce Shop Page Options", 'accu' ),
		  ),

		  array(
			'id'  		 => 'shop-product-per-page',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Products Per Page', 'accu'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Number of products to show in catalog / shop page', 'accu').'</span>',
			'default' 	 => 12,
		  ),

		  array(
			'id'           => 'product-style',
			'type'         => 'select',
			'title'        => esc_html__('Product Style', 'accu'),
			'options'      => array(
			  'woo-type1' 	   => esc_html__('Thick Border', 'accu'),
			  'woo-type4'      => esc_html__('Diamond Icons', 'accu'),
			  'woo-type8' 	   => esc_html__('Modern', 'accu'),
			  'woo-type10' 	   => esc_html__('Easing', 'accu'),
			  'woo-type11' 	   => esc_html__('Boxed', 'accu'),
			  'woo-type12' 	   => esc_html__('Easing Alt', 'accu'),
			  'woo-type13' 	   => esc_html__('Parallel', 'accu'),
			  'woo-type14' 	   => esc_html__('Pointer', 'accu'),
			  'woo-type16' 	   => esc_html__('Stack', 'accu'),
			  'woo-type17' 	   => esc_html__('Bouncy', 'accu'),
			  'woo-type20' 	   => esc_html__('Masked Circle', 'accu'),
			  'woo-type21' 	   => esc_html__('Classic', 'accu')
			),
			'class'        => 'chosen',
			'default' 	   => 'woo-type1',
			'info'         => esc_html__('Choose products style to display shop & archive pages.', 'accu')
		  ),

		  array(
			'id'      	 => 'shop-page-product-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Product Layout', 'accu'),
			'options'    => array(
				  1   => ACCU_THEME_URI . '/cs-framework-override/images/one-column.png',
				  2   => ACCU_THEME_URI . '/cs-framework-override/images/one-half-column.png',
				  3   => ACCU_THEME_URI . '/cs-framework-override/images/one-third-column.png',
				  4   => ACCU_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
			),
			'default'      => 4,
			'attributes'   => array(
			  'data-depend-id' => 'shop-page-product-layout',
			),
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Detail Page Options", 'accu' ),
		  ),

		  array(
			'id'      	   => 'product-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'accu'),
			'options'      => array(
			  'content-full-width'   => ACCU_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => ACCU_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'accu'),
			'dependency'   	 => array( 'product-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'accu'),
			'dependency' 	 => array( 'product-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  		 	 => 'enable-related',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Related Products', 'accu'),
			'info'	  		 => esc_html__("YES! to display related products on single product's page.", 'accu')
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Category Page Options", 'accu' ),
		  ),

		  array(
			'id'      	   => 'product-category-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'accu'),
			'options'      => array(
			  'content-full-width'   => ACCU_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => ACCU_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-category-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-category-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'accu'),
			'dependency'   	 => array( 'product-category-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-category-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'accu'),
			'dependency' 	 => array( 'product-category-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Tag Page Options", 'accu' ),
		  ),

		  array(
			'id'      	   => 'product-tag-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'accu'),
			'options'      => array(
			  'content-full-width'   => ACCU_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => ACCU_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => ACCU_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-tag-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-tag-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'accu'),
			'dependency'   	 => array( 'product-tag-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-tag-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'accu'),
			'dependency' 	 => array( 'product-tag-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

	  ),
	);
}

// -----------------------------------------
// Sociable Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'sociable_options',
  'title'       => esc_html__('Sociable', 'accu'),
  'icon'        => 'fa fa-share-alt-square',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Sociable", 'accu' ),
	  ),

	  array(
		'id'              => 'sociable_fields',
		'type'            => 'group',
		'title'           => esc_html__('Sociable', 'accu'),
		'info'            => esc_html__('Click button to add type of social & url.', 'accu'),
		'button_title'    => esc_html__('Add New Social', 'accu'),
		'accordion_title' => esc_html__('Adding New Social Field', 'accu'),
		'fields'          => array(
		  array(
			'id'          => 'sociable_fields_type',
			'type'        => 'select',
			'title'       => esc_html__('Select Social', 'accu'),
			'options'      => array(
			  'delicious' 	 => esc_html__('Delicious', 'accu'),
			  'deviantart' 	 => esc_html__('Deviantart', 'accu'),
			  'digg' 	  	 => esc_html__('Digg', 'accu'),
			  'dribbble' 	 => esc_html__('Dribbble', 'accu'),
			  'envelope' 	 => esc_html__('Envelope', 'accu'),
			  'facebook' 	 => esc_html__('Facebook', 'accu'),
			  'flickr' 		 => esc_html__('Flickr', 'accu'),
			  'google-plus'  => esc_html__('Google Plus', 'accu'),
			  'gtalk'  		 => esc_html__('GTalk', 'accu'),
			  'instagram'	 => esc_html__('Instagram', 'accu'),
			  'lastfm'	 	 => esc_html__('Lastfm', 'accu'),
			  'linkedin'	 => esc_html__('Linkedin', 'accu'),
			  'pinterest'	 => esc_html__('Pinterest', 'accu'),
			  'reddit'		 => esc_html__('Reddit', 'accu'),
			  'rss'		 	 => esc_html__('RSS', 'accu'),
			  'skype'		 => esc_html__('Skype', 'accu'),
			  'stumbleupon'	 => esc_html__('Stumbleupon', 'accu'),
			  'tumblr'		 => esc_html__('Tumblr', 'accu'),
			  'twitter'		 => esc_html__('Twitter', 'accu'),
			  'viadeo'		 => esc_html__('Viadeo', 'accu'),
			  'vimeo'		 => esc_html__('Vimeo', 'accu'),
			  'yahoo'		 => esc_html__('Yahoo', 'accu'),
			  'youtube'		 => esc_html__('Youtube', 'accu'),
			),
			'class'        => 'chosen',
			'default'      => 'delicious',
		  ),

		  array(
			'id'          => 'sociable_fields_url',
			'type'        => 'text',
			'title'       => esc_html__('Enter URL', 'accu')
		  ),
		)
	  ),

   ),
);

// -----------------------------------------
// Hook Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'hook_options',
  'title'       => esc_html__('Hooks', 'accu'),
  'icon'        => 'fa fa-paperclip',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Top Hook", 'accu' ),
	  ),

	  array(
		'id'  	=> 'enable-top-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Top Hook', 'accu'),
		'info'	=> esc_html__("YES! to enable top hook.", 'accu')
	  ),

	  array(
		'id'  		 => 'top-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Top Hook', 'accu'),
		'info'		 => esc_html__('Paste your top hook, Executes after the opening &lt;body&gt; tag.', 'accu')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content Before Hook", 'accu' ),
	  ),

	  array(
		'id'  	=> 'enable-content-before-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Content Before Hook', 'accu'),
		'info'	=> esc_html__("YES! to enable content before hook.", 'accu')
	  ),

	  array(
		'id'  		 => 'content-before-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content Before Hook', 'accu'),
		'info'		 => esc_html__('Paste your content before hook, Executes before the opening &lt;#primary&gt; tag.', 'accu')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content After Hook", 'accu' ),
	  ),

	  array(
		'id'  	=> 'enable-content-after-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Content After Hook', 'accu'),
		'info'	=> esc_html__("YES! to enable content after hook.", 'accu')
	  ),

	  array(
		'id'  		 => 'content-after-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content After Hook', 'accu'),
		'info'		 => esc_html__('Paste your content after hook, Executes after the closing &lt;/#main&gt; tag.', 'accu')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Bottom Hook", 'accu' ),
	  ),

	  array(
		'id'  	=> 'enable-bottom-hook',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Bottom Hook', 'accu'),
		'info'	=> esc_html__("YES! to enable bottom hook.", 'accu')
	  ),

	  array(
		'id'  		 => 'bottom-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Bottom Hook', 'accu'),
		'info'		 => esc_html__('Paste your bottom hook, Executes after the closing &lt;/body&gt; tag.', 'accu')
	  ),

   array(
		'id'  	=> 'enable-analytics-code',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Tracking Code', 'accu'),
		'info'	=> esc_html__("YES! to enable site tracking code.", 'accu')
	  ),

	  array(
		'id'  		 => 'analytics-code',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Google Analytics Tracking Code', 'accu'),
		'info'		 => esc_html__('Enter your Google tracking id (UA-XXXXX-X) here. If you want to offer your visitors the option to stop being tracked you can place the shortcode [dt_sc_privacy_google_tracking] somewhere on your site', 'accu')
	  ),

   ),
);

// -----------------------------------------
// Custom Font Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'font_options',
  'title'       => esc_html__('Custom Fonts', 'accu'),
  'icon'        => 'fa fa-font',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Fonts", 'accu' ),
	  ),

	  array(
		'id'              => 'custom_font_fields',
		'type'            => 'group',
		'title'           => esc_html__('Custom Font', 'accu'),
		'info'            => esc_html__('Click button to add font name & urls.', 'accu'),
		'button_title'    => esc_html__('Add New Font', 'accu'),
		'accordion_title' => esc_html__('Adding New Font Field', 'accu'),
		'fields'          => array(
		  array(
			'id'          => 'custom_font_name',
			'type'        => 'text',
			'title'       => esc_html__('Font Name', 'accu')
		  ),

		  array(
			'id'      => 'custom_font_woof',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff)', 'accu'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff) file here.', 'accu').'</p>',
		  ),

		  array(
			'id'      => 'custom_font_woof2',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff2)', 'accu'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff2) file here.', 'accu').'</p>',
		  )
		)
	  ),

   ),
);

// ------------------------------
// backup                       
// ------------------------------
$options[]   = array(
  'name'     => 'backup_section',
  'title'    => esc_html__('Backup', 'accu'),
  'icon'     => 'fa fa-shield',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'warning',
      'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'accu')
    ),

    array(
      'type'    => 'backup',
    ),

  )
);

// ------------------------------
// license
// ------------------------------
$options[]   = array(
  'name'     => 'theme_version',
  'title'    => constant('ACCU_THEME_NAME').esc_html__(' Log', 'accu'),
  'icon'     => 'fa fa-info-circle',
  'fields'   => array(

    array(
      'type'    => 'heading',
      'content' => constant('ACCU_THEME_NAME').esc_html__(' Theme Change Log', 'accu')
    ),
    array(
      'type'    => 'content',
			'content' => '<pre>
			
2025.06.23 - version 3.6
* Compatible: Latest WordPress Version 
* Fixed : Notice errors

2025.02.18 - version 3.5
* Premium plugins source updated
* Compatible with the latest version of premium plugins listed

2024.11.28 - version 3.4
* Compatible: Latest WordPress Version 
* Fixed : Warnings and deprecated errors

2024.08.29 - version 3.3
* Compatible: Latest WordPress Version    
* Importer source updated
* Fixed: Bulk plugin installation error

2023.04.20 - version 3.2
* Compatible with WordPress 6.2
* Compatible with latest WooCommerce versions
* Updated: All premium plugins

2022.12.23 - version 3.1
* Compatible with WordPress 6.1
* Compatible with latest WooCommerce versions
* Compatible with PHP 8.1 version
* Updated: All premium plugins

2022.03.02 - version 3.0
* Fixed Kirki Customizer Issue

2022.02.23 - version 2.9
* Simple Booking manager plugin update

2021.12.22 - version 2.8
* Buddypress plugin fix

2021.10.13 - version 2.7
* Some design fix updated

2021.10.13 - version 2.6
* Updated demo contents
* Latest events calendar plugin compatible
* Latest contact form 7 plugin compatible

2021.01.23 - version 2.5
* Compatible with wordpress 5.6
* Some design issues updated
* Updated: All premium plugins

2020.11.23 - version 2.4
* Latest jQuery fixes updated
* Updated: All premium plugins

2020.08.13 - version 2.3
* Compatible with wordpress 5.5

2020.08.05 - version 2.2

* Updated: Envato Theme check
* Updated: sanitize_text_field added
* Updated: All wordpress theme standards
* Updated: All premium plugins

2020.06.18 - version 2.1

* Compatible with wordpress 5.4.2
* Updated: Some design tweaks
* Updated: Sub menu mouse hover issue
* Updated: Activating another theme causes error
* Updated: Slider overlap issue with menus
* Updated: Wrong Image call in css

2020.02.07 - version 2.0

* Updated : All premium plugins			

2020.01.30 - version 1.9

* Compatible with wordpress 5.3.2
* Updated: All premium plugins
* Updated: All wordpress theme standards
* Updated: Privacy and Cookies concept
* Updated: Gutenberg editor support for custom post types

* Fixed: Google Analytics issue
* Fixed: Mailchimp email client issue
* Fixed: Privacy Button Issue
* Fixed: Gutenberg check for old wordpress version

* Improved: Tags taxonomy added for portfolio
* Improved: Single product breadcrumb section
* Improved: Revisions options added for all custom posts

2019.11.11 - version 1.8
* Compatible with wordpress 5.2.4
* Updated: All wordpress theme standards
* Updated: All premium plugins

2019.07.26 - version 1.7
* Compatible with wordpress 5.2.2
* Updated: All premium plugins
* Updated: Revisions added to all custom post types
* Updated: Gutenberg editor support for custom post types
* Updated: Link for phone number module
* Updated: Online documentation link, check readme file

* Fixed: Customizer logo option
* Fixed: Google Analytics issue
* Fixed: Mailchimp email client issue
* Fixed: Gutenberg check for old wordpress version
* Fixed: Edit with Visual Composer for portfolio
* Fixed: Header & Footer wpml option
* Fixed: Appointment person display under the services in backend
* Fixed: Breadcrumb issue in services page
* Fixed: Site title color
* Fixed: Privacy popup bg color
* Fixed: 404 page scrolling issue

* Improved: Single product breadcrumb section
* Improved: Tags taxonomy added for portfolio
* Improved: Woocommerce cart module added with custom class option

* New: Whatsapp Shortcode

2019.05.17 - version 1.6
* Gutenberg Latest fixes
* Updated Visual Composer and Layerslider plugins

2019.05.03 - version 1.5
 * Gutenberg Latest update compatible
 * Portfolio Video option
 * Coming Soon page fix
 * Portfolio archive page breadcrumb fix
 * Mega menu image fix
 * GDPR product single page fix
 * Codestar framework update
 * Simple Booking Manager plugin fix
 * Wpml xml file updated
 * disable options for likes and views in single post page
 * Updated latest version of all third party plugins
 * Some design tweaks

2019.01.22 - version 1.4
 * Gutenberg compatible
 * Latest WordPress version 5.0.3 compatible
 * Updated latest version of all third party plugins
 * Some design tweaks
 *       
2018.10.29 - version 1.3
 * Small bug fix.
 * 
2018.10.10 - version 1.2
 * Gutenberg plugin compatible
 * GDPR Compliant update in comment form, mailchimp form etc.
 * Updated documentation.
 * Updated WPBakery Page Builder plugin.
 * Updated Ultimate Addons for WPBakery Page Builder.

2018.08.23 - version 1.1
 * Optimised demo content included.

2018.08.14 - version 1.0
 * First release!  </pre>',
    ),

  )
);

// ------------------------------
// Seperator
// ------------------------------
$options[] = array(
  'name'   => 'seperator_1',
  'title'  => esc_html__('Plugin Options', 'accu'),
  'icon'   => 'fa fa-plug'
);


CSFramework::instance( $settings, $options );