<?php

/**
 * TPCore Sidebar Posts Image
 *
 *
 * @author 		Theme_Pure
 * @category 	Widgets
 * @package 	TPCore/Widgets
 * @version 	1.0.0
 * @extends 	WP_Widget
 */

class TP_Post_Sidebar_Widget extends WP_Widget
{

	public function __construct()
	{
		parent::__construct('tp-latest-posts', 'Tp :: Blog Sidebar Post', array(
			'description' => 'Latest Blog Post Widget by Theme_Pure'
		));
	}


	public function widget($args, $instance)
	{
		extract($args);
		extract($instance);

		echo $before_widget;
		?>

		<?php
		if ($instance['title']):
			echo $before_title; ?>
			<?php echo apply_filters('widget_title', $instance['title']); ?>
			<?php echo $after_title; ?>
		<?php endif; ?>

		<div class="tp-sidebar-post sidebar__post rc__post tp-recent-post-content">

			<?php
			$q = new WP_Query(array(
				'post_type' => 'post',
				'posts_per_page' => ($instance['count']) ? $instance['count'] : '3',
				'order' => ($instance['posts_order']) ? $instance['posts_order'] : 'DESC',
				'orderby' => 'date'
			));

			if ($q->have_posts()):
				while ($q->have_posts()):
					$q->the_post();

					$categories = get_the_terms($q->ID, 'category');
					?>
					<div class="rc__post tp-recent-post-content">

						<div class="rc__post-content tp-recent-post-content">
							<?php if (!empty($categories)): 
								$color =  get_term_meta($categories[0]->term_id, '_acadia_post_cat_color', true);
								?>
								<span class="tp-recent-post-span">
									<a data-bg-color="<?php echo esc_attr($color); ?>" href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>">
										<?php echo esc_html($categories[0]->name); ?>
									</a>
								</span>
							<?php endif; ?>
							<h3 class="rc__post-title tp-recent-post-title">
								<a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), 8, ''); ?></a>
							</h3>
							<div class="rc__meta tp-recent-post-tag">
								<span>
									<?php the_time('d. M, Y'); ?>
								</span>
								<span>
									<?php echo acadia_post_read_count(); ?>
								</span>
							</div>
						</div>
					</div>
				<?php endwhile;
				wp_reset_query();
			endif; ?>

		</div>
		<!-- latest post end -->

		<?php echo $after_widget; ?>

		<?php
	}



	public function form($instance)
	{
		$title = !empty($instance['title']) ? $instance['title'] : '';
		$count = !empty($instance['count']) ? $instance['count'] : esc_html__('3', 'tpcore');
		$posts_order = !empty($instance['posts_order']) ? $instance['posts_order'] : esc_html__('DESC', 'tpcore');
		$choose_style = !empty($instance['choose_style']) ? $instance['choose_style'] : esc_html__('style_1', 'tpcore');
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>">Title</label>
			<input type="text" name="<?php echo $this->get_field_name('title'); ?>"
				id="<?php echo $this->get_field_id('title'); ?>" value="<?php echo esc_attr($title); ?>" class="widefat">
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('count'); ?>">How many posts you want to show ?</label>
			<input type="number" name="<?php echo $this->get_field_name('count'); ?>"
				id="<?php echo $this->get_field_id('count'); ?>" value="<?php echo esc_attr($count); ?>" class="widefat">
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('posts_order'); ?>">Posts Order</label>
			<select name="<?php echo $this->get_field_name('posts_order'); ?>"
				id="<?php echo $this->get_field_id('posts_order'); ?>" class="widefat">
				<option value="" disabled="disabled">Select Post Order</option>
				<option value="ASC" <?php if ($posts_order === 'ASC') {
					echo 'selected="selected"';
				} ?>>ASC</option>
				<option value="DESC" <?php if ($posts_order === 'DESC') {
					echo 'selected="selected"';
				} ?>>DESC</option>
			</select>
		</p>

	<?php }
}

add_action('widgets_init', function () {
	register_widget('TP_Post_Sidebar_Widget');
});
