<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use \Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Image_Parallax extends Widget_Base
{

    use \TPCore\Widgets\TP_Style_Trait;
    use \TPCore\Widgets\TP_Animation_Trait;

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tp-image-parallax';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Parallax Image', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        // layout Panel
        $this->tp_design_layout('Layout Style', 1);

        // image
        $this->start_controls_section(
            'thumb_section',
            [
                'label' => esc_html__('Image Section', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_image',
            [
                'label' => esc_html__('Choose Image', 'tpcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'tp_parallax_y_offset',
            [
                'label' => esc_html__('Parallax Y Offset', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('200', 'tpcore'),
            ]
        );

        $this->add_control(
            'tp_parallax_smoothness',
            [
                'label' => esc_html__('Parallax Smoothness', 'tpcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('30', 'tpcore'),
            ]
        );
        $this->end_controls_section();
    }

    protected function style_tab_content()
    {
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>


        <?php if ($settings['tp_design_style'] == 'layout-2'): ?>

        <?php else:
            // thumbnail
            $img = tp_get_img($settings, 'tp_image', 'full', false);

            $smoothness = $settings['tp_parallax_smoothness'];
            $y_offset = $settings['tp_parallax_y_offset'];
            ?>
            <div class="tp-chose-yoga-shape" data-parallax='{"y": <?php echo esc_attr($y_offset); ?>, "smoothness": <?php echo esc_attr($smoothness); ?>}'>
                <img src="<?php echo esc_url($img['tp_image']); ?>" alt="<?php echo esc_url($img['tp_image_alt']); ?>">
            </div>

        <?php endif;
    }
}

$widgets_manager->register(new TP_Image_Parallax());
