<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package acadia
 */

$categories = get_the_terms($post->ID, 'category');

$acadia_blog_date = get_theme_mod('acadia_blog_date', true);
$acadia_blog_comments = get_theme_mod('acadia_blog_comments', true);
$acadia_blog_author = get_theme_mod('acadia_blog_author', true);
$acadia_blog_cat = get_theme_mod('acadia_blog_cat', false);
$acadia_blog_tags = get_theme_mod('acadia_blog_tags', true);



?>


<div class="tp-postbox-meta postbox__meta tp-blog-stories-tag-wrap d-flex">

    <?php if (!empty($acadia_blog_cat)) : ?>
        <?php if (!empty($categories[0]->name)) : 
             $color =  get_term_meta($categories[0]->term_id, '_acadia_post_cat_color', true)
            ?>
            <a data-bg-color="<?php echo esc_attr($color); ?>" class="tp-blog-categorize" href="<?php print esc_url(get_category_link($categories[0]->term_id)); ?>">
                <?php echo esc_html($categories[0]->name); ?>
            </a>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (!empty($acadia_blog_date)) : ?>
        <span>
            <?php the_time(get_option('date_format')); ?>
        </span>
    <?php endif; ?>

    <?php if (!empty($acadia_blog_comments)) : ?>
        <span class="tp-blog-comments">
            <a href="<?php comments_link(); ?>">
                <?php comments_number(); ?>
            </a>
        </span>
    <?php endif; ?>

</div>