<?php

$ac_ms_sort_sw = get_theme_mod( 'ac_ms_sort_sw', 'on' );
$ac_ms_cat_sw = get_theme_mod( 'ac_ms_cat_sw', 'on' );
$ac_ms_instructor_sw = get_theme_mod( 'ac_ms_instructor_sw', 'on' );
$ac_ms_price_sw = get_theme_mod( 'ac_ms_price_sw', 'on' );
$ac_ms_skill_sw = get_theme_mod( 'ac_ms_skill_sw', 'on' );
$course_cat = get_terms(
	'stm_lms_course_taxonomy',
	array(
		'orderby' => 'count',
		'order'   => 'DESC',
		'parent'  => false,
	)
);

$instructors = get_users(
    array(
        'role__in' => array( 'administrator', 'stm_lms_instructor' ),
        'orderby'  => 'display_name',
        'order'    => 'ASC',
    )
);

$levels = \STM_LMS_Helpers::get_course_levels();

?>

<div class="tp-filter-dropdown-area tp-filter-dropdown-wrapper tp-filter-dropdown-wrapper-2 tp-filter-dropdown-wrapper-3">
    <button type="button" class=" tp-filter-offcanvas-close tp-filter-offcanvas-close-btn">
        <?php echo esc_html__( 'Close', 'acadia' ); ?> 
        <span>
            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M15 1L1 15M1 1L15 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
        </span>
    </button>
    <div class="tp-filter-offcanvas-inner">
        <div class="row row-cols-1">
            <?php if( $ac_ms_sort_sw == 'on' ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Sort by', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-radio">
                        <ul>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="latest"
                                        id="sort_latest" <?php checked(($args['sort_by'] == 'latest'), 1); ?> >
                                    <span><?php echo esc_html__( 'Latest', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="trending"
                                        id="sort_trending" <?php checked(($args['sort_by'] == 'trending'), 1); ?> >
                                    <span><?php echo esc_html__( 'Trending', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="popularity"
                                        id="sort_popular" <?php checked(($args['sort_by'] == 'popularity'), 1); ?> >
                                    <span><?php echo esc_html__( 'Popularity', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="low_high"
                                        id="sort_low_high" <?php checked(($args['sort_by'] == 'low_high'), 1); ?> >
                                    <span><?php echo esc_html__( 'Price: low to high', 'acadia' ); ?></span>
                                </label>
                            </li>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" name="sort_by" value="high_low"
                                        id="sort_high_low" <?php checked(($args['sort_by'] == 'high_low'), 1); ?>>
                                    <span><?php echo esc_html__( 'Price: high to low', 'acadia' ); ?></span>
                                </label>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( $ac_ms_cat_sw == 'on' ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'All Categories', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-checkbox">
                        <ul>
                            <?php foreach( $course_cat as $key => $cat ) : 
                                $name  = $cat->name;
                                $slug  = $cat->slug;
                                $count = $cat->count;
                            ?>
                            <li>
                                <label class="from-checkbox">
                                    <input id="<?php echo esc_attr( $slug ); ?>" name='categories'
                                        value="<?php echo esc_attr( $slug ); ?>" type="checkbox" <?php checked(in_array($slug, $args['categories']), 1)?>>
                                    <span><?php echo $name . ' (' . $count . ')';?></span>
                                </label>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( $ac_ms_instructor_sw == 'on' ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Instructors', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-checkbox">
                        <ul>
                            <?php
                            foreach( $instructors as $key => $instructor ){
                                $ID    = $instructor->ID;
                                $name  = $instructor->display_name;
                                $count = \STM_LMS_Instructor::get_course_quantity( $ID );
                            ?>
                            <li>
                                <label class="from-checkbox">
                                    <input id="<?php echo esc_attr( $ID ); ?>" type="checkbox" name="instructors"
                                        value="<?php echo esc_html( $ID ); ?>" <?php checked(in_array($ID, $args['instructors']), 1)?>>
                                    <span><?php echo esc_html( ucwords( $name ) );  ?>
                                        (<?php echo esc_attr( $count ); ?>)</span>
                                </label>
                            </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( $ac_ms_price_sw == 'on' ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Price', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-radio">
                        <ul>
    
                            <?php
                            // all
                            $query_args = array(
                                'post_type'      => 'stm-courses',
                                'posts_per_page' => 1,
                                'fields'         => 'ids'
                            );
                
                            $loop = new \WP_Query( $query_args );
                            $count_course_all = $loop->found_posts;
                            ?>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" value='on_all' name="sort_by_price"
                                        id="sort_on_all" <?php checked(in_array('on_all', $args['sort_by_price']), 1)?> >
                                    <span>
                                        <?php echo esc_html__( 'All', 'acadia' ); ?>
                                        (<?php echo esc_attr( $count_course_all ); ?>)
                                    </span>
                                </label>
                            </li>
    
                            <?php
                            // free
                            $meta_query = array(array(
                                'relation' => 'AND',
                                array(
                                    'relation' => 'OR',
                                    array(
                                        'key'     => 'price',
                                        'value'   => array( 0, '' ),
                                        'compare' => 'in'
                                    ),
                                    array(
                                        'key'     => 'price',
                                        'compare' => 'NOT EXISTS'
                                    )
                                ),
                                array(
                                    'relation' => 'OR',
                                    array(
                                        'key'     => 'not_single_sale',
                                        'value'   => 'on',
                                        'compare' => '!='
                                    ),
                                    array(
                                        'key'     => 'not_single_sale',
                                        'compare' => 'NOT EXISTS'
                                    )
                                )
                            ) );
    
                            $query_args = array(
                                'post_type'      => 'stm-courses',
                                'posts_per_page' => 1,
                                'meta_query'     => $meta_query,
                                'fields'         => 'ids'
                            );
    
                            $loop = new \WP_Query( $query_args );
                            $count_courses_free = $loop->found_posts;
                            ?>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" value='on_free' name="sort_by_price"
                                        id="sort_on_free" <?php checked(in_array('on_free', $args['sort_by_price']), 1)?>>
                                    <span>
                                        <?php echo esc_html__( 'Free', 'acadia' ); ?>
                                        (<?php echo esc_attr( $count_courses_free ); ?>)
                                    </span>
                                </label>
                            </li>
    
                            <?php
                            // paid
                            $meta_query = array(array(
                                'relation' => 'AND',
                                array(
                                    'key'     => 'price',
                                    'value'   => 0,
                                    'compare' => '>'
                                ),
                                array(
                                    'relation' => 'OR',
                                    array(
                                        'key'     => 'not_single_sale',
                                        'value'   => 'on',
                                        'compare' => '!='
                                    ),
                                    array(
                                        'key'     => 'not_single_sale',
                                        'compare' => 'NOT EXISTS'
                                    )
                                )
                            ) );
    
                            $query_args = array(
                                'post_type'      => 'stm-courses',
                                'posts_per_page' => 1,
                                'meta_query'     => $meta_query,
                                'fields'         => 'ids'
                            );
    
                            $loop = new \WP_Query( $query_args );
                            $count_courses_paid = $loop->found_posts;
                            ?>
                            <li>
                                <label class="form-check">
                                    <input class="form-check-input" type="radio" value='on_paid' name="sort_by_price"
                                        id="sort_on_paid" <?php checked(in_array('on_paid', $args['sort_by_price']), 1)?>>
                                    <span>
                                        <?php echo esc_html__( 'Paid', 'acadia' ); ?>
                                        (<?php echo esc_attr( $count_courses_paid ); ?>)
                                    </span>
                                </label>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if( $ac_ms_skill_sw == 'on' ) : ?>
            <div class="col">
                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Skills Level', 'acadia' ); ?></h4>
                <div class="tp-filter-widget-content">
                    <div class="tp-filter-widget-radio">
                        <ul>
                            <?php 
                               foreach ( $levels as $key => $level ) :
                                $meta_query = array(
                                    array(
                                        'key'     => 'level',
                                        'value'   => $key,
                                        'compare' => '='
                                    )
                                );
                                
                                $query_args = array(
                                    'post_type'      => 'stm-courses',
                                    'posts_per_page' => 1,
                                    'meta_query'     => $meta_query,
                                    'fields'         => 'ids'
                                );
            
                                $loop = new \WP_Query( $query_args );
                                $count = $loop->found_posts;
                            ?>
                            <li>
                                <label class="from-checkbox">
                                    <input id="<?php echo esc_attr( $key ); ?>" type="checkbox" value="<?php echo esc_attr( $key ); ?>" name="skills" <?php checked(in_array($key, $args['skills']), 1)?>>
                                    <span><?php echo esc_html( $level ); ?>
                                        (<?php echo esc_html( $count ); ?>)</span>
                                </label>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div class="filter-offcanvas-overlay"></div>