<?php
$ac_ms_sort_sw       = get_theme_mod( 'ac_ms_sort_sw', 'on' );
$ac_ms_cat_sw        = get_theme_mod( 'ac_ms_cat_sw', 'on' );
$ac_ms_instructor_sw = get_theme_mod( 'ac_ms_instructor_sw', 'on' );
$ac_ms_price_sw      = get_theme_mod( 'ac_ms_price_sw', 'on' );
$ac_ms_skill_sw      = get_theme_mod( 'ac_ms_skill_sw', 'on' );
$ac_ms_search_sw     = get_theme_mod( 'ac_ms_search_sw', 'on' );

$get_sort_by       = isset($_GET['sort_by']) ? sanitize_text_field( $_GET['sort_by'] ) : '';
$get_categories    = isset($_GET['categories']) ? sanitize_text_field( $_GET['categories'] ) : '';
$get_instructors   = isset($_GET['instructors']) ? intval($_GET['instructors']) : '';
$get_sort_by_price = isset($_GET['sort_by_price']) ? sanitize_text_field( $_GET['sort_by_price'] ) : '';
$get_search_for    = isset($_GET['search_for']) ? sanitize_text_field( $_GET['search_for'] ) : '';
$get_skills        = isset($_GET['skills']) ? explode( ',', sanitize_text_field( $_GET['skills'] ) ) : array();


$filter_args = array(
    'sort_by'       => $get_sort_by,
    'categories'    => $get_categories,
    'instructors'   => $get_instructors,
    'sort_by_price' => $get_sort_by_price,
    'skills'        => $get_skills,
);

$course_cat = get_terms(
	'stm_lms_course_taxonomy',
	array(
		'orderby' => 'count',
		'order'   => 'DESC',
		'parent'  => false,
	)
);

$instructors = get_users(
    array(
        'role__in' => array( 'administrator', 'stm_lms_instructor' ),
        'orderby'  => 'display_name',
        'order'    => 'ASC',
    )
);

$levels = \STM_LMS_Helpers::get_course_levels();

?>

<?php get_template_part('stm-lms-templates/courses/archive-filter-double/filter-features','res', $filter_args); ?>

<div class="pt-80">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class=" p-relative">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="tp-course-filter-top-left d-flex align-items-center">
                                <div class="tp-course-filter-top-tab tp-tab mb-35">
                                    <ul class="nav nav-tabs" id="filterTab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                                data-bs-target="#home" type="button" role="tab" aria-controls="home"
                                                aria-selected="true">
                                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M5.66667 1H1V5.66667H5.66667V1Z" stroke="#031F42"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M12.9997 1H8.33301V5.66667H12.9997V1Z" stroke="#031F42"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M12.9997 8.33337H8.33301V13H12.9997V8.33337Z"
                                                        stroke="#031F42" stroke-linecap="round"
                                                        stroke-linejoin="round" />
                                                    <path d="M5.66667 8.33337H1V13H5.66667V8.33337Z" stroke="#031F42"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                                <?php echo esc_html__( 'Grid', 'acadia' ); ?>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                                data-bs-target="#profile" type="button" role="tab"
                                                aria-controls="profile" aria-selected="false">
                                                <svg width="14" height="14" viewBox="0 0 16 15" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M15 7.11108H1" stroke="#031F42" stroke-width="1"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path d="M15 1H1" stroke="#031F42" stroke-width="1"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path d="M15 13.2222H1" stroke="#031F42" stroke-width="1"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>
                                                <?php echo esc_html__( 'List', 'acadia' ); ?>
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="tp-course-filter-top-result ms-double-result mb-35" data-total-courses>
                                    <p><?php echo $args['index']; ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="tp-course-filter-top-right d-flex align-items-center justify-content-start justify-content-lg-end">
                                <div class="tp-course-filter-top-right-search d-none d-lg-block mb-35">
                                    <?php if( $ac_ms_search_sw == 'on' ) : ?>
                                    <form action="" class="ac-archive-filter-open-search-form">
                                        <?php 
                                        $nonce = wp_create_nonce('_nonce2');
                                        
                                        ?>
                                        <input type="hidden" id="nonce" name="nonce" value="<?php echo esc_html( $nonce ); ?>">
                                        <input type="text" class="course_search" placeholder="<?php echo esc_attr__( 'Search for Courses...', 'acadia' ); ?>" value="<?php echo esc_attr( $get_search_for ); ?>" name="search_for">
                                        <button class="tp-course-filter-top-right-search-btn" type="submit">
                                            <span>
                                                <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M12.625 12.625L16 16" stroke="#8B8B8B" stroke-width="1.5"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path
                                                        d="M14.5 7.75C14.5 4.02208 11.4779 1 7.75 1C4.02208 1 1 4.02208 1 7.75C1 11.4779 4.02208 14.5 7.75 14.5C11.4779 14.5 14.5 11.4779 14.5 7.75Z"
                                                        stroke="#8B8B8B" stroke-width="1.5" stroke-linejoin="round">
                                                    </path>
                                                </svg>
                                            </span>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                                <div class="tp-course-filter-btn mb-35">
                                    <button type="button"
                                        class="tp-filter-btn archive-filter-btn filter-open-dropdown-btn">
                                        <span>
                                            <svg width="16" height="15" viewBox="0 0 16 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M14.9998 3.44995H10.7998" stroke="currentColor"
                                                    stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M3.8 3.44995H1" stroke="currentColor" stroke-width="1.5"
                                                    stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path
                                                    d="M6.60039 5.9C7.95349 5.9 9.05039 4.8031 9.05039 3.45C9.05039 2.0969 7.95349 1 6.60039 1C5.24729 1 4.15039 2.0969 4.15039 3.45C4.15039 4.8031 5.24729 5.9 6.60039 5.9Z"
                                                    stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M15.0002 11.15H12.2002" stroke="currentColor"
                                                    stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M5.2 11.15H1" stroke="currentColor" stroke-width="1.5"
                                                    stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path
                                                    d="M9.4002 13.6C10.7533 13.6 11.8502 12.503 11.8502 11.15C11.8502 9.79685 10.7533 8.69995 9.4002 8.69995C8.0471 8.69995 6.9502 9.79685 6.9502 11.15C6.9502 12.503 8.0471 13.6 9.4002 13.6Z"
                                                    stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <?php echo esc_html__( 'Filter', 'acadia' ); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tp-filter-dropdown-area tp-filter-dropdown-wrapper d-none d-md-block">
                        <div class="row row-cols-lg-5 row-cols-md-3 row-cols-sm-2 row-cols-1">
                            <?php if( $ac_ms_sort_sw == 'on' ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Sort by', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-radio">
                                        <ul>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="latest"
                                                        id="sort_latest" <?php checked(($args['sort_by'] == 'latest'), 1); ?> >
                                                    <span><?php echo esc_html__( 'Latest', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="trending"
                                                        id="sort_trending" <?php checked(($args['sort_by'] == 'trending'), 1); ?> >
                                                    <span><?php echo esc_html__( 'Trending', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="popularity"
                                                        id="sort_popular" <?php checked(($args['sort_by'] == 'popularity'), 1); ?> >
                                                    <span><?php echo esc_html__( 'Popularity', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="low_high"
                                                        id="sort_low_high" <?php checked(($args['sort_by'] == 'low_high'), 1); ?> >
                                                    <span><?php echo esc_html__( 'Price: low to high', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="high_low"
                                                        id="sort_high_low" <?php checked(($args['sort_by'] == 'high_low'), 1); ?>>
                                                    <span><?php echo esc_html__( 'Price: high to low', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( $ac_ms_cat_sw == 'on' ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'All Categories', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-checkbox">
                                        <ul>
                                            <?php foreach( $course_cat as $key => $cat ) : 
                                                $name  = $cat->name;
                                                $slug  = $cat->slug;
                                                $count = $cat->count;
                                            ?>
                                            <li>
                                                <label class="from-checkbox">
                                                    <input id="<?php echo esc_attr( $slug ); ?>" name='categories'
                                                        value="<?php echo esc_attr( $slug ); ?>" type="checkbox" 
                                                        <?php 
    
                                                            if (is_array($args['categories'])) {
                                                                checked(in_array($slug, $args['categories']), 1);
                                                            } else {
                                                                checked($args['categories'] == $slug, 1);
                                                            }
    
                                                        ?> >
                                                    <span><?php echo $name . ' (' . $count . ')';?></span>
                                                </label>
                                            </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( $ac_ms_instructor_sw == 'on' ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Instructors', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-checkbox">
                                        <ul>
                                            <?php
                                            foreach( $instructors as $key => $instructor ){
                                                $ID    = $instructor->ID;
                                                $name  = $instructor->display_name;
                                                $count = \STM_LMS_Instructor::get_course_quantity( $ID );
                                            ?>
                                            <li>
                                                <label class="from-checkbox">
                                                    <input id="<?php echo esc_attr( $ID ); ?>" type="checkbox" name="instructors"
                                                        value="<?php echo esc_html( $ID ); ?>" <?php 
                                                        if (is_array($args['instructors'])) {
                                                            checked(in_array($ID, $args['instructors']), 1);
                                                        } else {
                                                            checked($args['instructors'] == $ID, 1);
                                                        }
                                                    ?>>
                                                    <span><?php echo esc_html( ucwords( $name ) );  ?>
                                                        (<?php echo esc_attr( $count ); ?>)</span>
                                                </label>
                                            </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( $ac_ms_price_sw == 'on' ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Price', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-radio">
                                        <ul>
    
                                            <?php
                                            // all
                                            $query_args = array(
                                                'post_type'      => 'stm-courses',
                                                'posts_per_page' => 1,
                                                'fields'         => 'ids'
                                            );
                                
                                            $loop = new \WP_Query( $query_args );
                                            $count_course_all = $loop->found_posts;
                                            ?>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" value='on_all' name="sort_by_price"
                                                        id="sort_on_all" <?php 
                                                        if (is_array($args['sort_by_price'])) {
                                                            checked(in_array('on_all', $args['sort_by_price']), 1);
                                                        } else {
                                                            checked($args['sort_by_price'] == 'on_all', 1);
                                                        }
                                                    ?> >
                                                    <span>
                                                        <?php echo esc_html__( 'All', 'acadia' ); ?>
                                                        (<?php echo esc_attr( $count_course_all ); ?>)
                                                    </span>
                                                </label>
                                            </li>
    
                                            <?php
                                            // free
                                            $meta_query = array(array(
                                                'relation' => 'AND',
                                                array(
                                                    'relation' => 'OR',
                                                    array(
                                                        'key'     => 'price',
                                                        'value'   => array( 0, '' ),
                                                        'compare' => 'in'
                                                    ),
                                                    array(
                                                        'key'     => 'price',
                                                        'compare' => 'NOT EXISTS'
                                                    )
                                                ),
                                                array(
                                                    'relation' => 'OR',
                                                    array(
                                                        'key'     => 'not_single_sale',
                                                        'value'   => 'on',
                                                        'compare' => '!='
                                                    ),
                                                    array(
                                                        'key'     => 'not_single_sale',
                                                        'compare' => 'NOT EXISTS'
                                                    )
                                                )
                                            ) );
    
                                            $query_args = array(
                                                'post_type'      => 'stm-courses',
                                                'posts_per_page' => 1,
                                                'meta_query'     => $meta_query,
                                                'fields'         => 'ids'
                                            );
    
                                            $loop = new \WP_Query( $query_args );
                                            $count_courses_free = $loop->found_posts;
                                            ?>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" value='on_free' name="sort_by_price"
                                                        id="sort_on_free" <?php 
                                                        if (is_array($args['sort_by_price'])) {
                                                            checked(in_array('on_free', $args['sort_by_price']), 1);
                                                        } else {
                                                            checked($args['sort_by_price'] == 'on_free', 1);
                                                        }
                                                    ?>>
                                                    <span>
                                                        <?php echo esc_html__( 'Free', 'acadia' ); ?>
                                                        (<?php echo esc_attr( $count_courses_free ); ?>)
                                                    </span>
                                                </label>
                                            </li>
    
                                            <?php
                                            // paid
                                            $meta_query = array(array(
                                                'relation' => 'AND',
                                                array(
                                                    'key'     => 'price',
                                                    'value'   => 0,
                                                    'compare' => '>'
                                                ),
                                                array(
                                                    'relation' => 'OR',
                                                    array(
                                                        'key'     => 'not_single_sale',
                                                        'value'   => 'on',
                                                        'compare' => '!='
                                                    ),
                                                    array(
                                                        'key'     => 'not_single_sale',
                                                        'compare' => 'NOT EXISTS'
                                                    )
                                                )
                                            ) );
    
                                            $query_args = array(
                                                'post_type'      => 'stm-courses',
                                                'posts_per_page' => 1,
                                                'meta_query'     => $meta_query,
                                                'fields'         => 'ids'
                                            );
    
                                            $loop = new \WP_Query( $query_args );
                                            $count_courses_paid = $loop->found_posts;
                                            ?>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" value='on_paid' name="sort_by_price"
                                                        id="sort_on_paid" <?php 
                                                        if (is_array($args['sort_by_price'])) {
                                                            checked(in_array('on_paid', $args['sort_by_price']), 1);
                                                        } else {
                                                            checked($args['sort_by_price'] == 'on_paid', 1);
                                                        }
                                                    ?>>
                                                    <span>
                                                        <?php echo esc_html__( 'Paid', 'acadia' ); ?>
                                                        (<?php echo esc_attr( $count_courses_paid ); ?>)
                                                    </span>
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( $ac_ms_skill_sw == 'on' ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Skills Level', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-radio">
                                        <ul>
                                            <?php 
                                            foreach ( $levels as $key => $level ) :
                                                $meta_query = array(
                                                    array(
                                                        'key'     => 'level',
                                                        'value'   => $key,
                                                        'compare' => '='
                                                    )
                                                );
                                                
                                                $query_args = array(
                                                    'post_type'      => 'stm-courses',
                                                    'posts_per_page' => 1,
                                                    'meta_query'     => $meta_query,
                                                    'fields'         => 'ids'
                                                );
                            
                                                $loop = new \WP_Query( $query_args );
                                                $count = $loop->found_posts;
                                            ?>
                                            <li>
                                                <label class="from-checkbox">
                                                    <input id="<?php echo esc_attr( $key ); ?>" type="checkbox" value="<?php echo esc_attr( $key ); ?>" name="skills" <?php 
                                                        if (is_array($args['skills'])) {
                                                            checked(in_array($key, $args['skills']), 1);
                                                        } else {
                                                            checked($args['skills'] == $key, 1);
                                                        }
                                                    ?>>
                                                    <span><?php echo esc_html( $level ); ?>
                                                        (<?php echo esc_html( $count ); ?>)</span>
                                                </label>
                                            </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>