<?php

use ParagonIE\Sodium\Core\Curve25519\H;

    $post_id = get_the_ID();
    $course_data = apply_filters( 'masterstudy_course_page_header', 'default' ); 

    $is_course_coming_soon = STM_LMS_Helpers::masterstudy_lms_is_course_coming_soon( $post_id );
    $price      = get_post_meta( $post_id, 'price', true );
    $sale_price = STM_LMS_Course::get_sale_price( $post_id );

    STM_LMS_Templates::show_lms_template(
        'components/course/expired',
        array(
            'course'         => $course_data['course'],
            'user_id'        => $course_data['current_user_id'],
            'is_coming_soon' => $course_data['is_coming_soon'],
        )
    );
?>

<main class='ms-course-details-1'>

    <!-- course details breadcrumb start -->
    <section class="tp-breadcrumb__area pt-25 pb-55 p-relative z-index-1 fix">
        <div class="tp-breadcrumb__bg"
            data-background="<?php echo get_template_directory_uri(); ?>/assets/img/breadcrumb/breadcrumb-bg-2.jpg">
        </div>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-12">
                    <div class="tp-breadcrumb__content">
                        <div class="tp-breadcrumb__list course-details mb-70">
                            <?php
                                if( function_exists( 'acadia_masterstudy_course_breadcrumb' ) ) {
                                    echo acadia_masterstudy_course_breadcrumb();
                                }
                            ?>
                        </div>

                        <div class="tp-course-details-2-header">
                            <span class="tp-course-details-1-category mb-5">
                                <?php
                                    if ( ! $course_data['is_coming_soon'] || $course_data['course']->coming_soon_details ) {
                                        STM_LMS_Templates::show_lms_template( 'components/course/categories', array( 'term_ids' => $course_data['course']->category ) );
                                    }
                                    STM_LMS_Templates::show_lms_template( 'components/course/status', array( 'course' => $course_data['course'] ) );
                                ?>
                            </span>

                            <?php
                            STM_LMS_Templates::show_lms_template(
                                'global/coming_soon',
                                array(
                                    'course_id' => $course_data['course']->id,
                                    'mode'      => 'course',
                                ),
                            );
                            ?>

                            <?php STM_LMS_Templates::show_lms_template( 'components/course/title', array( 'title' => $course_data['course']->title ) ); ?>

                            <?php 
                                if ( ! $course_data['is_coming_soon'] || $course_data['course']->coming_soon_details ) {
                                    ?>
                            <div class="masterstudy-single-course__info">
                                <div class="masterstudy-single-course__info-block">
                                    <?php
                                            STM_LMS_Templates::show_lms_template(
                                                'components/course/instructor',
                                                array(
                                                    'instructor' => $course_data['instructor'],
                                                    'course'     => $course_data['course'],
                                                )
                                            );
                                            ?>
                                </div>
                                <?php if ( ! empty( $course_data['course']->current_students ) ) { ?>
                                <div
                                    class="masterstudy-single-course__info-block masterstudy-single-course__info-block_students">
                                    <?php STM_LMS_Templates::show_lms_template( 'components/course/current-students', array( 'current_students' => $course_data['course']->current_students ) ); ?>
                                </div>
                                <?php
                                        }
                                        if ( ! empty( $course_data['course']->rate ) || ! empty( $course_data['course']->udemy_rate ) ) {
                                            ?>
                                <div class="masterstudy-single-course__info-block">
                                    <?php STM_LMS_Templates::show_lms_template( 'components/course/rating', array( 'course' => $course_data['course'] ) ); ?>
                                </div>
                                <?php } ?>
                            </div>
                            <?php
                                }
                            ?>

                            <div class="single-course-share">
                                <?php
                                STM_LMS_Templates::show_lms_template( 'components/course/wishlist', array( 'course_id' => $course_data['course']->id ) );
                                STM_LMS_Templates::show_lms_template( 'components/course/share-button', array( 'course' => $course_data['course'] ) );
                                ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- course details breadcrumb end -->


    <!-- course details area start -->
    <section class="tp-course-details-2-area pt-50 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="tp-course-details-2-main-inner pr-70">

                        <?php 
                            STM_LMS_Templates::show_lms_template(
                                'components/course/tabs',
                                array(
                                    'course'         => $course_data['course'],
                                    'course_preview' => $course_data['course_preview'] ?? '',
                                    'user_id'        => $course_data['current_user_id'],
                                    'style'          => 'underline',
                                    'with_image'     => true,
                                )
                            );
                        ?>

                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="tp-course-details-2-widget">

                        <?php if( has_post_thumbnail() ) : ?>
                        <div class="tp-course-details-2-widget-thumb p-relative">
                            <?php the_post_thumbnail(); ?>
                        </div>
                        <?php endif; ?>
                        <div class="tp-course-details-2-widget-content">

                            <?php
                                STM_LMS_Templates::show_lms_template(
                                    'components/course/complete',
                                    array(
                                        'course_id'     => $course_data['course']->id,
                                        'user_id'       => $course_data['current_user_id'],
                                        'settings'      => $course_data['settings'],
                                        'block_enabled' => true,
                                    )
                                );
                                if ( ! $course_data['is_coming_soon'] || $course_data['course']->coming_soon_preorder ) {
                                    ?>
                            <div class="masterstudy-single-course__cta">
                                <?php
                                        STM_LMS_Templates::show_lms_template(
                                            'components/buy-button/buy-button',
                                            array(
                                                'post_id'              => $course_data['course']->id,
                                                'item_id'              => '',
                                                'user_id'              => $course_data['current_user_id'],
                                                'dark_mode'            => false,
                                                'prerequisite_preview' => false,
                                                'hide_group_course'    => false,
                                            )
                                        );
                                        ?>
                            </div>
                            <?php
                                    STM_LMS_Templates::show_lms_template( 'components/course/price-info', array( 'course' => $course_data['course'] ) );
                                }
                                if ( $course_data['is_coming_soon'] && $course_data['course']->coming_soon_price && ! $course_data['course']->coming_soon_preorder ) {
                                    ?>
                            <div class="masterstudy-single-course__cta">
                                <?php STM_LMS_Templates::show_lms_template( 'components/course/coming-button' ); ?>
                            </div>
                            <?php
                                }
                            ?>

                            <?php

                                STM_LMS_Templates::show_lms_template(
                                    'components/course/expired',
                                    array(
                                        'course'         => $course_data['course'],
                                        'user_id'        => $course_data['current_user_id'],
                                        'is_coming_soon' => $course_data['is_coming_soon'],
                                    )
                                );
                                STM_LMS_Templates::show_lms_template( 'components/course/details', array( 'course' => $course_data['course'] ) );
                                if ( $course_data['settings']['course_allow_basic_info'] ) {
                                    STM_LMS_Templates::show_lms_template(
                                        'components/course/info',
                                        array(
                                            'course_id' => $course_data['course']->id,
                                            'content'   => $course_data['course']->basic_info,
                                            'title'     => esc_html__( 'Basic info', 'masterstudy-lms-learning-management-system' ),
                                        ),
                                    );
                                }
                                if ( $course_data['settings']['course_allow_requirements_info'] ) {
                                    STM_LMS_Templates::show_lms_template(
                                        'components/course/info',
                                        array(
                                            'course_id' => $course_data['course']->id,
                                            'content'   => $course_data['course']->requirements,
                                            'title'     => esc_html__( 'Course requirements', 'masterstudy-lms-learning-management-system' ),
                                        ),
                                    );
                                }
                                if ( $course_data['settings']['course_allow_intended_audience'] ) {
                                    STM_LMS_Templates::show_lms_template(
                                        'components/course/info',
                                        array(
                                            'course_id' => $course_data['course']->id,
                                            'content'   => $course_data['course']->intended_audience,
                                            'title'     => esc_html__( 'Intended audience', 'masterstudy-lms-learning-management-system' ),
                                        ),
                                    );
                                }
                                ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- course details area end -->

    <!-- course details area start -->
    <section class="tp-course-details-2-related-area pb-80">
        <div class="container">
            <?php
                STM_LMS_Templates::show_lms_template( 'components/course/related-courses', array( 'course' => $course_data['course'] ) );
            ?>
        </div>
    </section>
    <!-- course details area end -->

</main>