<?php
/**
 * Template for displaying content of single course.
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Header for page
 */
if ( ! wp_is_block_theme() ) {
	do_action( 'learn-press/template-header' );
}

$acadia_lp_details = get_theme_mod( 'acadia_lp_details', 'style_1' );

$ac_lp_single = isset($_GET['ac_lp_single']) ? sanitize_text_field($_GET['ac_lp_single']) : $acadia_lp_details;

if( $ac_lp_single ) {
	if( 'style_2' == $ac_lp_single ) {
		get_template_part('learnpress/course-details/style-2');
	} else {
		get_template_part('learnpress/course-details/style-1');
	}
} else {
	if( 'style_2' == $acadia_lp_details ) {
		get_template_part('learnpress/course-details/style-2');
	} else {
		get_template_part('learnpress/course-details/style-1');
	}
}



/**
 * Footer for page
 */
if ( ! wp_is_block_theme() ) {
	do_action( 'learn-press/template-footer' );
}