<?php

defined( 'ABSPATH' ) || exit;

/**
 * @since 4.0.0
 *
 * @see LP_Template_General::template_header()
 */
if ( ! wp_is_block_theme() ) {
	do_action( 'learn-press/template-header' );
}

$acadia_lp_archive = get_theme_mod( 'acadia_lp_archive', 'style_1' );

$ac_lp_archive = isset($_GET['ac_lp_archive']) ? sanitize_text_field($_GET['ac_lp_archive']) : $acadia_lp_archive;

if( $ac_lp_archive ) {

	if( 'style_2' == $ac_lp_archive ) {
		get_template_part('learnpress/archive-filter/content-archive-filter');
	} elseif( 'style_3' == $ac_lp_archive ) {
		get_template_part('learnpress/archive-filter-open/content-archive-filter-open');
	} elseif( 'style_4' == $ac_lp_archive ) {
		get_template_part('learnpress/archive-tab/content-archive-tab');
	} elseif( 'style_5' == $ac_lp_archive ) {
		get_template_part('learnpress/archive-filter-double/content-archive-filter-double');
	} else {
		get_template_part('learnpress/archive-sidebar/content-archive-sidebar');
	}

} else {
	if( 'style_2' == $acadia_lp_archive ) {
		get_template_part('learnpress/archive-filter/content-archive-filter');
	} elseif( 'style_3' == $acadia_lp_archive ) {
		get_template_part('learnpress/archive-filter-open/content-archive-filter-open');
	} elseif( 'style_4' == $acadia_lp_archive ) {
		get_template_part('learnpress/archive-tab/content-archive-tab');
	} elseif( 'style_5' == $acadia_lp_archive ) {
		get_template_part('learnpress/archive-filter-double/content-archive-filter-double');
	} else {
		get_template_part('learnpress/archive-sidebar/content-archive-sidebar');
	}
}




/**
 * @since 4.0.0
 *
 * @see   LP_Template_General::template_footer()
 */
if ( ! wp_is_block_theme() ) {
	do_action( 'learn-press/template-footer' );
}
