<?php


new \Kirki\Panel(
    'acadia_panel',
    [
        'priority' => 10,
        'title' => esc_html__('Acadia Customizer', 'acadia'),
        'description' => esc_html__('Acadia Theme Customizer.', 'acadia'),
    ]
);

function acadia_theme_settings()
{

    new \Kirki\Section(
        'acadia_theme_settings_section',
        [
            'title' => esc_html__('Theme Settings', 'acadia'),
            'description' => esc_html__('Theme Controls.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 100,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_header_sticky',
            'label' => esc_html__('Header Sticky Switcher', 'acadia'),
            'description' => esc_html__('Header Sticky On/Off', 'acadia'),
            'section' => 'acadia_theme_settings_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );
}
acadia_theme_settings();


function acadia_header_settings()
{

    new \Kirki\Section(
        'header_main_section',
        [
            'title' => esc_html__('Header Main Settings', 'acadia'),
            'description' => esc_html__('Header Main Controls.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 101,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_header_elementor_switch',
            'label' => esc_html__('Header Custom/Elementor Switch', 'acadia'),
            'description' => esc_html__('Header Custom/Elementor On/Off', 'acadia'),
            'section' => 'header_main_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Radio_Image(
        [
            'settings' => 'header_layout_custom',
            'label' => esc_html__('Chose Header Style', 'acadia'),
            'section' => 'header_main_section',
            'priority' => 10,
            'choices' => [
                'header_1' => get_template_directory_uri() . '/inc/img/header/header-1.png',
            ],
            'default' => 'header_1',
            'active_callback' => [
                [
                    'setting' => 'acadia_header_elementor_switch',
                    'operator' => '==',
                    'value' => false
                ]
            ]
        ]
    );

    $header_buildertype = array(
        'post_type' => 'tp-header',
        'posts_per_page' => -1,
    );
    $header_buildertype_loop = get_posts($header_buildertype);

    $header_post_obj_arr = array();
    foreach ($header_buildertype_loop as $post) {
        $header_post_obj_arr[$post->ID] = $post->post_title;
    }


    wp_reset_query();


    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_header_templates',
            'label' => esc_html__('Elementor Header Template', 'acadia'),
            'section' => 'header_main_section',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => $header_post_obj_arr,
            'active_callback' => [
                [
                    'setting' => 'acadia_header_elementor_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'header_right_switch',
            'label' => esc_html__('Header Right Switch', 'acadia'),
            'description' => esc_html__('Header Right On/Off', 'acadia'),
            'section' => 'header_main_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_header_cart',
            'label' => esc_html__('Header Cart Switch', 'acadia'),
            'description' => esc_html__('Header Cart On/Off', 'acadia'),
            'section' => 'header_main_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_header_hamburger',
            'label' => esc_html__('Header Hamburger Switch', 'acadia'),
            'description' => esc_html__('Header Hamburger On/Off', 'acadia'),
            'section' => 'header_main_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );
}
acadia_header_settings();

function acadia_logo_settings()
{
    // header_logo_section section 
    new \Kirki\Section(
        'header_logo_section',
        [
            'title' => esc_html__('Header Logo', 'acadia'),
            'description' => esc_html__('Header Logo Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 101,
        ]
    );

    // header_logo_section section 
    new \Kirki\Field\Image(
        [
            'settings' => 'header_logo_black',
            'label' => esc_html__('Header Black Logo', 'acadia'),
            'description' => esc_html__('Theme Default/Primary Logo Here', 'acadia'),
            'section' => 'header_logo_section',
            'default' => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
        ]
    );
    new \Kirki\Field\Image(
        [
            'settings' => 'header_logo_white',
            'label' => esc_html__('Header White Logo', 'acadia'),
            'description' => esc_html__('Theme White Logo Here', 'acadia'),
            'section' => 'header_logo_section',
            'default' => get_template_directory_uri() . '/assets/img/logo/logo.png',
        ]
    );

    new \Kirki\Field\Dimension(
        [
            'settings' => 'acadia_header_logo_width',
            'label' => __('Width', 'acadia'),
            'section' => 'header_logo_section',
            'responsive' => true,
            'default' => [
                'desktop' => [
                    'width' => '85px',
                ],
                'tablet' => [
                    'width' => '85px',
                ],
                'mobile' => [
                    'width' => '85px',
                ],
            ],
            'output' => [
                [
                    'element' => '.acadia-site-logo img',
                    'property' => 'width',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
        ]
    );
}
acadia_logo_settings();


function acadia_offcanvas_settings()
{

    new \Kirki\Section(
        'acadia_offcanvas_section',
        [
            'title' => esc_html__('Offcanvas Settings', 'acadia'),
            'description' => esc_html__('Offcanvas Controls.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 102,
        ]
    );

    new \Kirki\Field\Image(
        [
            'settings' => 'acadia_offcanvas_logo',
            'label' => esc_html__('Offcanvas Logo', 'acadia'),
            'section' => 'acadia_offcanvas_section',
            'default' => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Dimension(
        [
            'settings' => 'acadia_offcanvas_logo_width',
            'label' => __('Width', 'acadia'),
            'section' => 'acadia_offcanvas_section',
            'responsive' => true,
            'default' => [
                'desktop' => '85px',
                'tablet' => '85px',
                'mobile' => '85px',
            ],
            'output' => [
                [
                    'element' => '.acadia-offcanvas-logo img',
                    'property' => 'width',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_offcanvas_content_switch',
            'label' => esc_html__('Offcanvas Content Switch', 'acadia'),
            'description' => esc_html__('Offcanvas Content On/Off', 'acadia'),
            'section' => 'acadia_offcanvas_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_offcanvas_title',
            'label' => esc_html__('Offcanvas Title', 'acadia'),
            'section' => 'acadia_offcanvas_section',
            'default' => esc_html__('Hello There!', 'acadia'),
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'acadia_offcanvas_content_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Textarea(
        [
            'settings' => 'acadia_offcanvas_content',
            'label' => esc_html__('Offcanvas Content', 'acadia'),
            'section' => 'acadia_offcanvas_section',
            'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, ', 'acadia'),
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'acadia_offcanvas_content_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
}

acadia_offcanvas_settings();


function acadia_back_to_top_section()
{

    new \Kirki\Section(
        'back_to_top_section',
        [
            'title' => esc_html__('Back To Top Settings', 'acadia'),
            'description' => esc_html__('Back To Top Controls.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 103,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_backtotop_switch',
            'label' => esc_html__('Back To Top Switch', 'acadia'),
            'description' => esc_html__('Back To Top On/Off', 'acadia'),
            'section' => 'back_to_top_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'back_to_top_bg',
            'label' => __('Back To Top BG Color', 'acadia'),
            'description' => esc_html__('You can change Back To Top bg color from here.', 'acadia'),
            'section' => 'back_to_top_section',
            'default' => '#000',
            'output' => [
                [
                    'element' => '.back-to-top-btn',
                    'property' => 'background',
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_backtotop_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'back_to_top_icon_color',
            'label' => __('Back To Top Icon Color', 'acadia'),
            'description' => esc_html__('You can change Back To Top icon color from here.', 'acadia'),
            'section' => 'back_to_top_section',
            'default' => '#fff',
            'output' => [
                [
                    'element' => '.back-to-top-btn',
                    'property' => 'color',
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_backtotop_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
}
acadia_back_to_top_section();


function acadia_preloader_settings()
{

    new \Kirki\Section(
        'preloader_section',
        [
            'title' => esc_html__('Preloader Settings', 'acadia'),
            'description' => esc_html__('Preloader Controls.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 104,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_preloader_switch',
            'label' => esc_html__('Preloader Switch', 'acadia'),
            'description' => esc_html__('Preloader On/Off', 'acadia'),
            'section' => 'preloader_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Image(
        [
            'settings' => 'acadia_preloader_logo',
            'label' => esc_html__('Preloader Logo', 'acadia'),
            'section' => 'preloader_section',
            'default' => get_template_directory_uri() . '/assets/img/logo/preloader/preloader-icon.png',
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'acadia_preloader_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_preloader_loading_text',
            'label' => esc_html__('Preloader Loading Text', 'acadia'),
            'section' => 'preloader_section',
            'default' => esc_html__('Loading', 'acadia'),
            'priority' => 11,
            'active_callback' => [
                [
                    'setting' => 'acadia_preloader_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'acadia_preloader_typography',
            'label' => esc_html__('Typography Control', 'acadia'),
            'description' => esc_html__('Set typography for desktop', 'acadia'),
            'section' => 'preloader_section',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => '.tp-preloader-subtitle',
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_preloader_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ],

        ]
    );

    new \Kirki\Field\Background(
        [
            'settings' => 'acadia_preloader_loading_bg',
            'label' => __('Background', 'acadia'),
            'description' => esc_html__('Background conrols are pretty complex! (but useful if used properly)', 'acadia'),
            'section' => 'preloader_section',
            'default' => [
                'background-color' => '#fff',
                'background-image' => '',
                'background-repeat' => 'repeat',
                'background-position' => 'center center',
                'background-size' => 'cover',
                'background-attachment' => 'scroll',
            ],
            'transport' => 'auto',
            'output' => [
                [
                    'element' => '#loading',
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_preloader_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
}

acadia_preloader_settings();

function acadia_breadcrumb_settings()
{

    new \Kirki\Section(
        'acadia_breadcrumb_section',
        [
            'title' => esc_html__('Breadcrumb Settings', 'acadia'),
            'description' => esc_html__('Breadcrumb Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 105,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'breadcrumb_switch',
            'label' => esc_html__('Show Breadcrumb Globally', 'acadia'),
            'description' => esc_html__('Breadcrumb On/Off', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'default' => true,
            'choices' => [
                'on' => esc_html__('Show', 'acadia'),
                'off' => esc_html__('Hide', 'acadia'),
            ],

        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'breadcrumb_on_single',
            'label' => esc_html__('Show Breadcrumb On Single Page ?', 'acadia'),
            'description' => esc_html__('Breadcrumb On/Off', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'default' => false,
            'choices' => [
                'on' => esc_html__('Yes', 'acadia'),
                'off' => esc_html__('No', 'acadia'),
            ],

        ]
    );
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'breadcrumb_on_single_courses',
            'label' => esc_html__('Show Breadcrumb On Single Course ?', 'acadia'),
            'description' => esc_html__('Breadcrumb Courses Single On/Off', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'default' => false,
            'choices' => [
                'on' => esc_html__('Yes', 'acadia'),
                'off' => esc_html__('No', 'acadia'),
            ],

        ]
    );


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_breadcrumb_elementor_switch',
            'label' => esc_html__('Breadcrumb Custom/Elementor Switch', 'acadia'),
            'description' => esc_html__('Breadcrumb Custom/Elementor On/Off', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Radio_Image(
        [
            'settings' => 'breadcrumb_layout_custom',
            'label' => esc_html__('Chose Breadcrumb Style', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'priority' => 10,
            'choices' => [
                'breadcrumb_1' => get_template_directory_uri() . '/inc/img/breadcrumb/breadcrumb-bg.jpg',
            ],
            'default' => 'breadcrumb_1',
            'active_callback' => [
                [
                    'setting' => 'acadia_breadcrumb_elementor_switch',
                    'operator' => '==',
                    'value' => false
                ]
            ]
        ]
    );

    $breadcrumb_buildertype = array(
        'post_type' => 'tp-breadcrumb',
        'posts_per_page' => -1,
    );
    $breadcrumb_buildertype_loop = get_posts($breadcrumb_buildertype);

    $breadcrumb_post_obj_arr = array();
    foreach ($breadcrumb_buildertype_loop as $post) {
        $breadcrumb_post_obj_arr[$post->ID] = $post->post_title;
    }

    wp_reset_query();

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_breadcrumb_templates_acadia',
            'label' => esc_html__('Elementor Breadcrumb Template', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => $breadcrumb_post_obj_arr,
            'active_callback' => [
                [
                    'setting' => 'acadia_breadcrumb_elementor_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );


    new \Kirki\Field\Radio_Buttonset(
        [
            'settings' => 'breadcrumb_typography_responsive_control',
            'label' => esc_html__('Typography Control', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'default' => 'desktop',
            'priority' => 10,
            'choices' => [
                'desktop' => esc_html__('Desktop', 'acadia'),
                'tablet' => esc_html__('Tablet', 'acadia'),
                'mobile' => esc_html__('Mobile', 'acadia'),
            ],
        ]
    );


    new \Kirki\Field\Typography(
        [
            'settings' => 'breadcrumb_typography_desktop',
            'label' => esc_html__('Typography Control', 'acadia'),
            'description' => esc_html__('Set typography for desktop', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '#031F42',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'active_callback' => [
                [
                    'setting' => 'breadcrumb_typography_responsive_control',
                    'operator' => '==',
                    'value' => 'desktop'
                ]
            ],
            'output' => [
                [
                    'element' => '.tp_acadia_breadcrumb__title',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'breadcrumb_typography_tablet',
            'label' => esc_html__('Typography Control', 'acadia'),
            'description' => esc_html__('Set typography for tablet', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '#031F42',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'active_callback' => [
                [
                    'setting' => 'breadcrumb_typography_responsive_control',
                    'operator' => '==',
                    'value' => 'tablet'
                ]
            ],
            'output' => [
                [
                    'element' => '.tp_acadia_breadcrumb__title',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'breadcrumb_typography_mobile',
            'label' => esc_html__('Typography Control', 'acadia'),
            'description' => esc_html__('Set typography for mobile', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '#031F42',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'active_callback' => [
                [
                    'setting' => 'breadcrumb_typography_responsive_control',
                    'operator' => '==',
                    'value' => 'mobile'
                ]
            ],
            'output' => [
                [
                    'element' => '.tp_acadia_breadcrumb__title',
                ],
            ],
        ]
    );


    new \Kirki\Field\Background(
        [
            'settings' => 'breadcrumb_background_setting',
            'label' => esc_html__('Breadcrumb Background', 'acadia'),
            'description' => esc_html__('Background conrols for breadcrumb', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'default' => [
                'background-color' => '',
                'background-image' => get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-bg.jpg',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center',
                'background-size' => 'cover',
                'background-attachment' => 'scroll',
            ],
            'transport' => 'auto',
            'output' => [
                [
                    'element' => '.acadia-breadcrumb-padding',
                ],
            ],
        ]
    );

    new \Kirki\Field\Dimensions(
        [
            'settings' => 'acadia_breadcrumb_padding',
            'label' => __('Padding', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'responsive' => true,
            'default' => [
                'desktop' => [
                    'padding-top' => '60px',
                    'padding-bottom' => '60px',
                ],
                'tablet' => [
                    'padding-top' => '70px',
                    'padding-bottom' => '70px',
                ],
                'mobile' => [
                    'padding-top' => '40px',
                    'padding-bottom' => '40px',
                ],
            ],
            'output' => [
                [
                    'element' => '.acadia-breadcrumb-padding',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
        ]
    );
}
acadia_breadcrumb_settings();

function acadia_blog_settings()
{
    // blog_section section 
    new \Kirki\Section(
        'blog_section',
        [
            'title' => esc_html__('Blog Settings', 'acadia'),
            'description' => esc_html__('Blog Section Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 106,
        ]
    );


    new \Kirki\Field\Radio_Image(
        [
            'settings' => 'acadia_blog_single_layout',
            'label' => esc_html__('Chose Single Style', 'acadia'),
            'section' => 'blog_section',
            'priority' => 10,
            'choices' => [
                'blog_single_default' => get_template_directory_uri() . '/inc/img/blog/blog-standard.jpg',
                'blog_single_classic' => get_template_directory_uri() . '/inc/img/blog/blog-classic.jpg',
            ],
            'default' => 'blog_single_default',
        ]
    );

    new \Kirki\Field\Radio_Buttonset(
        [
            'settings' => 'acadia_blog_sidebar_system',
            'label' => esc_html__('Sidebar Controls', 'acadia'),
            'section' => 'blog_section',
            'default' => 'right',
            'priority' => 10,
            'choices' => [
                'right' => esc_html__('Right', 'acadia'),
                'left' => esc_html__('Left', 'acadia'),
                'no_sidebar' => esc_html__('No Sidebar', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Background(
        [
            'settings' => 'acadia_blog_full_width_overlay_bg',
            'label' => __('Select Color/Image', 'acadia'),
            'description' => esc_html__('Background conrols are pretty complex! (but useful if used properly)', 'acadia'),
            'section' => 'blog_section',
            'default' => [
                'background-color' => 'rgba(0,0,0,.36)',
                'background-image' => get_template_directory_uri() . '/assets/img/blog/blog-stories/blog-stories-bg.png',
                'background-repeat' => 'repeat',
                'background-position' => 'center center',
                'background-size' => 'cover',
                'background-attachment' => 'scroll',
            ],
            'transport' => 'auto',
            'output' => [
                [
                    'element' => '.blog-details-overlay::after',
                ],
            ],
        ]
    );


    new \Kirki\Field\Dimensions(
        [
            'settings' => 'acadia_blog_full_width_padding',
            'label' => esc_html__('Vertical Padding', 'acadia'),
            'description' => esc_html__('Change Vertical Padding here', 'acadia'),
            'section' => 'blog_section',
            'responsive' => true,
            'default' =>
                [
                    'desktop' => [
                        'padding-top' => '170px',
                        'padding-bottom' => '170px',
                    ],
                    'tablet' => [
                        'padding-top' => '70px',
                        'padding-bottom' => '70px',
                    ],
                    'mobile' => [
                        'padding-top' => '40px',
                        'padding-bottom' => '40px',
                    ],
                ],
            'output' => [
                [
                    'element' => '.acadia-blog-single-height',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_blog_single_layout',
                    'operator' => '==',
                    'value' => 'blog_single_classic'
                ]
            ]
        ]
    );

    new \Kirki\Field\Dimensions(
        [
            'settings' => 'acadia_blog_classic_padding',
            'label' => esc_html__('Vertical Padding', 'acadia'),
            'description' => esc_html__('Change Vertical Padding here', 'acadia'),
            'section' => 'blog_section',
            'responsive' => true,
            'default' => [
                'desktop' => [
                    'padding-top' => '170px',
                    'padding-bottom' => '70px',
                ],
                'tablet' => [
                    'padding-top' => '100px',
                    'padding-bottom' => '70px',
                ],
                'mobile' => [
                    'padding-top' => '70px',
                    'padding-bottom' => '40px',
                ],
            ],
            'output' => [
                [
                    'element' => '.blog-details-without-sidebar',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_blog_single_layout',
                    'operator' => '==',
                    'value' => 'blog_single_classic'
                ]
            ]
        ]
    );

    new \Kirki\Field\Dimensions(
        [
            'settings' => 'acadia_blog_default_padding',
            'label' => esc_html__('Vertical Padding', 'acadia'),
            'description' => esc_html__('Change Vertical Padding here', 'acadia'),
            'section' => 'blog_section',
            'responsive' => true,
            'default' => [
                'desktop' => [
                    'padding-top' => '100px',
                    'padding-bottom' => '100px',
                ],
                'tablet' => [
                    'padding-top' => '70px',
                    'padding-bottom' => '70px',
                ],
                'mobile' => [
                    'padding-top' => '40px',
                    'padding-bottom' => '40px',
                ],
            ],
            'output' => [
                [
                    'element' => '.acadia-blog-single-padding',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_blog_single_layout',
                    'operator' => '==',
                    'value' => 'blog_single_default'
                ]
            ]
        ]
    );


    new \Kirki\Field\Dimension(
        [
            'settings' => 'acadia_blog_full_width_height_set',
            'label' => esc_html__('Set Height', 'acadia'),
            'description' => esc_html__('Adjust height of hero section.', 'acadia'),
            'section' => 'blog_section',
            'responsive' => true,
            'default' => [
                'desktop' => '800px',
                'tablet' => '600px',
                'mobile' => '450px',
            ],
            'choices' => [
                'accept_unitless' => true,
            ],
            'output' => [
                [
                    'element' => '.acadia-blog-single-height',
                    'property' => 'height',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_blog_single_layout',
                    'operator' => '==',
                    'value' => 'blog_single_full_width'
                ]
            ]
        ]
    );


    // blog_section BTN 
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_cat',
            'label' => esc_html__('Blog Category Meta On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => false,
            'priority' => 10,
        ]
    );

    // blog_section Author Meta 
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_author',
            'label' => esc_html__('Blog Author Meta On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => true,
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_date',
            'label' => esc_html__('Blog Date Meta On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => true,
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_comments',
            'label' => esc_html__('Blog Comments Meta On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => true,
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_tags',
            'label' => esc_html__('Blog Tags Meta On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => true,
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_post_box_social_switch',
            'label' => esc_html__('Post Box Social On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => true,
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_btn_switch',
            'label' => esc_html__('Blog BTN On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => true,
            'priority' => 10,
        ]
    );

    // blog_section_details text 
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_details_content',
            'label' => esc_html__('Blog Details Text', 'acadia'),
            'section' => 'blog_section',
            'default' => "Back to main blog",
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_single_social',
            'label' => esc_html__('Single Blog Social Share', 'acadia'),
            'section' => 'blog_section',
            'default' => false,
            'priority' => 10,
        ]
    );

    // blog_section Blog BTN text 
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_blog_btn',
            'label' => esc_html__('Blog Button Text', 'acadia'),
            'section' => 'blog_section',
            'default' => "Read More",
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'acadia_blog_btn_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_blog_single_related',
            'label' => esc_html__('Enable Related Post?', 'acadia'),
            'description' => esc_html__('Related Post For Single On/Off', 'acadia'),
            'section' => 'blog_section',
            'default' => false,
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_blog_related_title',
            'label' => esc_html__('Blog Related Title', 'acadia'),
            'section' => 'blog_section',
            'default' => "Related Posts",
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'acadia_blog_single_related',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
}
acadia_blog_settings();
function error_404_section()
{
    // 404_section section 
    new \Kirki\Section(
        'error_404_section',
        [
            'title' => esc_html__('404 Page', 'acadia'),
            'description' => esc_html__('404 Page Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 107,
        ]
    );

    new \Kirki\Field\Image(
        [
            'settings' => 'acadia_error_thumb',
            'label' => esc_html__('Error Image', 'acadia'),
            'description' => esc_html__('rror Image Here', 'acadia'),
            'section' => 'error_404_section',
            'default' => get_template_directory_uri() . '/assets/img/error/error.png',
        ]
    );

    // 404_section 
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_error_title',
            'label' => esc_html__('Not Found Title', 'acadia'),
            'section' => 'error_404_section',
            'default' => "Oops!",
            'priority' => 10,
        ]
    );
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_error_title_sm',
            'label' => esc_html__('Something went Wrong...', 'acadia'),
            'section' => 'error_404_section',
            'default' => "Oops! Page not found",
            'priority' => 10,
        ]
    );

    // 404_section description
    new \Kirki\Field\Textarea(
        [
            'settings' => 'acadia_error_desc',
            'label' => esc_html__('Not Found description', 'acadia'),
            'section' => 'error_404_section',
            'default' => "Sorry, we couldn\'t find your page.",
            'priority' => 10,
        ]
    );

    // 404_section description
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_error_link_text',
            'label' => esc_html__('Error Link Text', 'acadia'),
            'section' => 'error_404_section',
            'default' => "Back To Home",
            'priority' => 10,
        ]
    );
}
error_404_section();

function acadia_lms_settings()
{
    new \Kirki\Section(
        'acadia_lms_settings',
        [
            'title' => esc_html__('Acadia LMS', 'acadia'),
            'description' => esc_html__('Acadia LMS Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 108,
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_single_layout',
            'label' => esc_html__('Single Layout', 'acadia'),
            'description' => esc_html__('Choose signle layout', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'course_single_standard',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                'course_single_standard' => esc_html__('Standard', 'acadia'),
                'course_single_classic' => esc_html__('Classic', 'acadia'),
            ],
        ]
    );


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_lms_change_details_sidebar_position',
            'label' => esc_html__('Sidebar On Top (in responsive)?', 'acadia'),
            'description' => esc_html__('This will affect below 992px', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Yes', 'acadia'),
                'off' => esc_html__('No', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_single_layout',
                    'operator' => '==',
                    'value' => 'course_single_standard'
                ]
            ]
        ]
    );

    new \Kirki\Field\Background(
        [
            'settings' => 'acadia_lms_single_breadcrumb',
            'label' => esc_html__('Signle Breadcrumb Background', 'acadia'),
            'description' => esc_html__('Background conrols for breadcrumb', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => [
                'background-color' => '',
                'background-image' => get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-bg-2.jpg',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center',
                'background-size' => 'cover',
                'background-attachment' => 'scroll',
            ],
            'transport' => 'auto',
            'output' => [
                [
                    'element' => '.acadia-lms-single-breadcrumb',
                ],
            ],
        ]
    );


    new \Kirki\Field\Background(
        [
            'settings' => 'acadia_lms_single_course_bg',
            'label' => esc_html__('Signle Course Background', 'acadia'),
            'description' => esc_html__('Background conrols for lms single page', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => [
                'background-color' => '',
                'background-image' => get_template_directory_uri() . '/assets/img/breadcrumb/breadcrumb-bg-3.jpg',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center',
                'background-size' => 'cover',
                'background-attachment' => 'scroll',
            ],
            'transport' => 'auto',
            'output' => [
                [
                    'element' => '.tp-breadcrumb__bg.details3',
                ],
            ],
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_lms_course_breadcrumb_desc',
            'label' => esc_html__('Breadcrumb Description', 'acadia'),
            'description' => esc_html__('Breadcrumb Description, for archive page', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => esc_html__('We have a wide range of courses to help you achieve your goals.', 'acadia'),
            'priority' => 10,
        ]
    );
    new \Kirki\Field\Dimensions(
        [
            'settings' => 'acadia_lms_course_breadcrumb_padding',
            'label' => __('Padding', 'acadia'),
            'section' => 'acadia_breadcrumb_section',
            'responsive' => true,
            'default' => [
                'desktop' => [
                    'padding-top' => '150px',
                    'padding-bottom' => '60px',
                ],
                'tablet' => [
                    'padding-top' => '100px',
                    'padding-bottom' => '70px',
                ],
                'mobile' => [
                    'padding-top' => '100px',
                    'padding-bottom' => '40px',
                ],
            ],
            'output' => [
                [
                    'element' => '.acadia-lms-breadcrumb-padding',
                    'media_query' => [
                        'desktop' => '@media (min-width: 1024px)',
                        'tablet' => '@media (min-width: 768px) and (max-width: 1023px)',
                        'mobile' => '@media (max-width: 767px)',
                    ],
                ],
            ],
        ]
    );


    // textarea
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_lms_related_course_title',
            'label' => esc_html__('Related Course Title', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => esc_html__('Related Courses', 'acadia'),
            'priority' => 10,
        ]
    );
    // textarea
    new \Kirki\Field\Textarea(
        [
            'settings' => 'acadia_lms_related_course_desc',
            'label' => esc_html__('Related Course Description', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => esc_html__('10,000+ unique online course list designs', 'acadia'),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Textarea(
        [
            'settings' => 'acadia_lms_course_found_desc',
            'label' => esc_html__('Course Found Title', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => esc_html__('We found [course_number] courses available for you', 'acadia'),
            'priority' => 10,
        ]
    );

    // mumber 
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_lms_course_title_word_count',
            'label' => esc_html__('Course Title Word Count', 'acadia'),
            'description' => esc_html__('Course Title Word Count, for archive page', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 3,
            'priority' => 10,
        ]
    );


    //switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_lms_view_style_switch',
            'label' => esc_html__('Show View Switcher?', 'acadia'),
            'description' => esc_html__('View Toggle Switch On/Off', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'on',
            'choices' => [
                'on' => esc_html__('Yes', 'acadia'),
                'off' => esc_html__('No', 'acadia'),
            ],

        ]
    );


    // select column for default layout
    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_view_style',
            'label' => esc_html__('Default View', 'acadia'),
            'description' => esc_html__('Choose view style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'grid',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                'grid' => esc_html__('Grid', 'acadia'),
                'list' => esc_html__('List', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_view_style_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_grid_view_style',
            'label' => esc_html__('Default Grid View', 'acadia'),
            'description' => esc_html__('Choose Grid view style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'grid_default',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                'grid_default' => esc_html__('Default', 'acadia'),
                'grid_gym' => esc_html__('Gym', 'acadia'),
                'grid_school' => esc_html__('School', 'acadia'),
                'grid_list' => esc_html__('Grid List', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_view_style_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    // select column for default layout
    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_archive_style',
            'label' => esc_html__('Select View Style', 'acadia'),
            'description' => esc_html__('Choose Card style here', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'archive_grid',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                'archive_grid' => esc_html__('Grid', 'acadia'),
                'archive_list' => esc_html__('List', 'acadia'),
                'archive_gym' => esc_html__('Gym', 'acadia'),
                'archive_school' => esc_html__('School', 'acadia'),
                'archive_list_grid' => esc_html__('List Grid', 'acadia'),

            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_view_style_switch',
                    'operator' => '==',
                    'value' => false
                ]
            ]
        ]
    );


    // select column for default layout
    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_filter_style',
            'label' => esc_html__('Select Filter Style', 'acadia'),
            'description' => esc_html__('Choose filter style here', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'sidebar',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                'sidebar' => esc_html__('Sidebar', 'acadia'),
                'style_1' => esc_html__('Style 1', 'acadia'),
                'style_2' => esc_html__('Style 2', 'acadia'),
                'style_3' => esc_html__('Style 3', 'acadia'),
            ],
        ]
    );

    //switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_lms_col_switch',
            'label' => esc_html__('Enable Custom Column?', 'acadia'),
            'description' => esc_html__('This will disable column system from Tutor LMS', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Yes', 'acadia'),
                'off' => esc_html__('No', 'acadia'),
            ],

        ]
    );

    // select column for default layout
    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_column_xl',
            'label' => esc_html__('Select Column XL', 'acadia'),
            'description' => esc_html__('Column for Extra Large Device, only for grid style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => '3',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                '1' => esc_html__('1 Column', 'acadia'),
                '2' => esc_html__('2 Column', 'acadia'),
                '3' => esc_html__('3 Column', 'acadia'),
                '4' => esc_html__('4 Column', 'acadia'),
                '5' => esc_html__('5 Column', 'acadia'),
                '6' => esc_html__('6 Column', 'acadia'),
                '7' => esc_html__('7 Column', 'acadia'),
                '8' => esc_html__('8 Column', 'acadia'),
                '9' => esc_html__('9 Column', 'acadia'),
                '10' => esc_html__('10 Column', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_col_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    // select column for default layout lg
    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_column_lg',
            'label' => esc_html__('Select Column LG', 'acadia'),
            'description' => esc_html__('Column for Large Device, only for grid style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => '3',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                '1' => esc_html__('1 Column', 'acadia'),
                '2' => esc_html__('2 Column', 'acadia'),
                '3' => esc_html__('3 Column', 'acadia'),
                '4' => esc_html__('4 Column', 'acadia'),
                '5' => esc_html__('5 Column', 'acadia'),
                '6' => esc_html__('6 Column', 'acadia'),
                '7' => esc_html__('7 Column', 'acadia'),
                '8' => esc_html__('8 Column', 'acadia'),
                '9' => esc_html__('9 Column', 'acadia'),
                '10' => esc_html__('10 Column', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_col_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_column_md',
            'label' => esc_html__('Select Column MD', 'acadia'),
            'description' => esc_html__('Column for Medium Device, only for grid style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => '2',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                '1' => esc_html__('1 Column', 'acadia'),
                '2' => esc_html__('2 Column', 'acadia'),
                '3' => esc_html__('3 Column', 'acadia'),
                '4' => esc_html__('4 Column', 'acadia'),
                '5' => esc_html__('5 Column', 'acadia'),
                '6' => esc_html__('6 Column', 'acadia'),
                '7' => esc_html__('7 Column', 'acadia'),
                '8' => esc_html__('8 Column', 'acadia'),
                '9' => esc_html__('9 Column', 'acadia'),
                '10' => esc_html__('10 Column', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_col_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_column_sm',
            'label' => esc_html__('Select Column SM', 'acadia'),
            'description' => esc_html__('Column for Small Device, only for grid style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => '1',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                '1' => esc_html__('1 Column', 'acadia'),
                '2' => esc_html__('2 Column', 'acadia'),
                '3' => esc_html__('3 Column', 'acadia'),
                '4' => esc_html__('4 Column', 'acadia'),
                '5' => esc_html__('5 Column', 'acadia'),
                '6' => esc_html__('6 Column', 'acadia'),
                '7' => esc_html__('7 Column', 'acadia'),
                '8' => esc_html__('8 Column', 'acadia'),
                '9' => esc_html__('9 Column', 'acadia'),
                '10' => esc_html__('10 Column', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_col_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_lms_column_xs',
            'label' => esc_html__('Select Column XS', 'acadia'),
            'description' => esc_html__('Column for Extra Small Device, only for grid style', 'acadia'),
            'section' => 'acadia_lms_settings',
            'default' => '1',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                '1' => esc_html__('1 Column', 'acadia'),
                '2' => esc_html__('2 Column', 'acadia'),
                '3' => esc_html__('3 Column', 'acadia'),
                '4' => esc_html__('4 Column', 'acadia'),
                '5' => esc_html__('5 Column', 'acadia'),
                '6' => esc_html__('6 Column', 'acadia'),
                '7' => esc_html__('7 Column', 'acadia'),
                '8' => esc_html__('8 Column', 'acadia'),
                '9' => esc_html__('9 Column', 'acadia'),
                '10' => esc_html__('10 Column', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'acadia_lms_col_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
}
acadia_lms_settings();

function acadia_woocommerce_settings()
{
    new \Kirki\Section(
        'acadia_woocommerce_settings',
        [
            'title' => esc_html__('Acadia Woocommerce', 'acadia'),
            'description' => esc_html__('Acadia Woocommerce Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 108,
        ]
    );

    new \Kirki\Field\Radio_Image(
        [
            'settings' => 'acadia_shop_single_details_style',
            'label' => esc_html__('Chose Single Layout', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'priority' => 10,
            'choices' => [
                'style_default' => get_template_directory_uri() . '/inc/img/shop/single-default.jpg',
            ],
            'default' => 'style_default',

        ]
    );


    // Category Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_categories_switch',
            'label' => esc_html__('Show/Hide Product Category ', 'acadia'),
            'description' => esc_html__('Show/Hide Product Category on single page', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'on',
            'choices' => [
                'on' => esc_html__('Show', 'acadia'),
                'off' => esc_html__('Hide', 'acadia'),
            ],
        ]
    );

    // SKU Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_sku_switch',
            'label' => esc_html__('Show/Hide Product SKU ', 'acadia'),
            'description' => esc_html__('Show/Hide Product SKU on single page', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'on',
            'choices' => [
                'on' => esc_html__('Show', 'acadia'),
                'off' => esc_html__('Hide', 'acadia'),
            ],
        ]
    );

    // Tags Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_tags_switch',
            'label' => esc_html__('Show/Hide Product Tag ', 'acadia'),
            'description' => esc_html__('Show/Hide Product Tag on single page', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'on',
            'choices' => [
                'on' => esc_html__('Show', 'acadia'),
                'off' => esc_html__('Hide', 'acadia'),
            ],
        ]
    );

    // Wishlist Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_wishlist_switch',
            'label' => esc_html__('Show/Hide Wishlist', 'acadia'),
            'description' => esc_html__('Show/Hide wishlist on single page', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'on',
            'choices' => [
                'on' => esc_html__('Show', 'acadia'),
                'off' => esc_html__('Hide', 'acadia'),
            ],
        ]
    );

    // Compare Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_compare_switch',
            'label' => esc_html__('Product Compare Switch', 'acadia'),
            'description' => esc_html__('Product Compare On/Off', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'on',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],

        ]
    );

    // Social Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_social_switch',
            'label' => esc_html__('Product Social Switch', 'acadia'),
            'description' => esc_html__('Product Social On/Off', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    // Repeater
    new \Kirki\Field\Repeater(
        [
            'settings' => 'acadia_product_single_fea_meta',
            'label' => esc_html__('product Single Repeater Control', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'priority' => 10,
            'default' => [
                [
                    'tp_product_message' => esc_html__('30 days easy returns', 'acadia'),
                ],
            ],
            'fields' => [
                'tp_product_message' => [
                    'type' => 'text',
                    'label' => esc_html__('Product Message', 'acadia'),
                    'default' => '30 days easy returns',
                ],
            ],
        ]
    );

    // Payment Hide switch
    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_product_single_payment_switch',
            'label' => esc_html__('Payment Info Switch', 'acadia'),
            'description' => esc_html__('Payment Info On/Off', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],

        ]
    );

    // product single payment text
    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_product_single_payment_text',
            'label' => esc_html__('Payment Text', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => esc_html__('Guaranteed safe & secure checkout', 'acadia'),
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'acadia_product_single_payment_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    // product single payment
    new \Kirki\Field\Image(
        [
            'settings' => 'acadia_product_single_payment_img',
            'label' => esc_html__('Payment Image', 'acadia'),
            'description' => esc_html__('Payment Image add/remove', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'active_callback' => [
                [
                    'setting' => 'acadia_product_single_payment_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    // cart empty
    new \Kirki\Field\Image(
        [
            'settings' => 'acadia_shop_cartmini_empty_img',
            'label' => esc_html__('Cartmini Empty Thumbnail', 'acadia'),
            'description' => esc_html__('Upload cartmini empty thumbnail here', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => get_template_directory_uri() . '/assets/img/product/empty-cart.png',
        ]
    );

    new \Kirki\Field\Textarea(
        [
            'settings' => 'acadia_shop_cartmini_empty_text',
            'label' => esc_html__('Cartmini Empty Text', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'Your Cart is empty',
            'description' => esc_attr__('Cart empty message', 'acadia'),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Textarea(
        [
            'settings' => 'acadia_shop_cartmini_empty_button_text',
            'label' => esc_html__('Cartmini Empty Button Text', 'acadia'),
            'section' => 'acadia_woocommerce_settings',
            'default' => 'Go To Shop',
            'description' => esc_attr__('Cart empty message', 'acadia'),
            'priority' => 10,
        ]
    );
}

acadia_woocommerce_settings();

function free_shipping_settings()
{
    new \Kirki\Section(
        'free_shipping_settings',
        [
            'title' => esc_html__('Free Shipping Settings', 'acadia'),
            'description' => esc_html__('Free Shipping Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 109,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'enable_free_shipping_bar',
            'label' => esc_html__('Shipping Bar Switch', 'acadia'),
            'description' => esc_html__('Shipping Bar On/Off', 'acadia'),
            'section' => 'free_shipping_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'shipping_progress_bar_location_mini_cart',
            'label' => esc_html__('Cartmini Switch', 'acadia'),
            'description' => esc_html__('Enable For Cartmini', 'acadia'),
            'section' => 'free_shipping_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'enable_free_shipping_bar',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'shipping_progress_bar_location_card_page',
            'label' => esc_html__('Cart Page Switch', 'acadia'),
            'description' => esc_html__('Enable For Cart Page', 'acadia'),
            'section' => 'free_shipping_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'enable_free_shipping_bar',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'shipping_progress_bar_location_checkout',
            'label' => esc_html__('Checkout Page Switch', 'acadia'),
            'description' => esc_html__('Enable For Checkout Page', 'acadia'),
            'section' => 'free_shipping_settings',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
            'active_callback' => [
                [
                    'setting' => 'enable_free_shipping_bar',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );

    new \Kirki\Field\Textarea(
        [
            'settings' => 'shipping_progress_bar_message_initial',
            'label' => esc_html__('Initial Message', 'acadia'),
            'section' => 'free_shipping_settings',
            'default' => 'Add [remainder] to cart and get free shipping!',
            'description' => esc_attr__('Message to show before reaching the goal. Use shortcode [remainder] to display the amount left to reach the minimum.', 'acadia'),
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'enable_free_shipping_bar',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
    new \Kirki\Field\Textarea(
        [
            'settings' => 'shipping_progress_bar_message_success',
            'label' => esc_html__('Success message', 'acadia'),
            'section' => 'free_shipping_settings',
            'default' => 'Your order qualifies for free shipping!',
            'description' => esc_attr__('Message to show after reaching 100%.', 'acadia'),
            'priority' => 10,
            'active_callback' => [
                [
                    'setting' => 'enable_free_shipping_bar',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );
}
free_shipping_settings();

function acadia_event_settings()
{
    // event_section section 
    new \Kirki\Section(
        'acadia_event_section',
        [
            'title' => esc_html__('Event Settings', 'acadia'),
            'description' => esc_html__('Blog Section Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 106,
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_event_title_count',
            'label' => esc_html__('Title Count', 'acadia'),
            'section' => 'acadia_event_section',
            'default' => '3',
            'description' => esc_attr__('Title Count Number', 'acadia'),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_event_description_switch',
            'label' => esc_html__('Event Description Switch', 'acadia'),
            'description' => esc_html__('Event Description On/Off', 'acadia'),
            'section' => 'acadia_event_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_event_calendar_switcher',
            'label' => esc_html__('Event Calendar Switch', 'acadia'),
            'description' => esc_html__('Event Calendar On/Off', 'acadia'),
            'section' => 'acadia_event_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );
}
acadia_event_settings();

function full_site_typography()
{
    new \Kirki\Section(
        'full_site_typography',
        [
            'title' => esc_html__('Typography', 'acadia'),
            'description' => esc_html__('Typography Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 190,
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_h1',
            'label' => esc_html__('H1 Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'h1',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_h2',
            'label' => esc_html__('H2 Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'h2',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_h3',
            'label' => esc_html__('H3 Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'h3',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_h4',
            'label' => esc_html__('H4 Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'h4',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_h5',
            'label' => esc_html__('H5 Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'h5',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_h6',
            'label' => esc_html__('H6 Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'h6',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_body',
            'label' => esc_html__('Body Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'body',
                ],
            ],
        ]
    );

    new \Kirki\Field\Typography(
        [
            'settings' => 'full_site_typography_settings_p',
            'label' => esc_html__('Paragraph Typography Control', 'acadia'),
            'description' => esc_html__('The full set of options.', 'acadia'),
            'section' => 'full_site_typography',
            'priority' => 10,
            'transport' => 'auto',
            'default' => [
                'font-family' => '',
                'variant' => '',
                'color' => '',
                'font-size' => '',
                'line-height' => '',
                'text-align' => '',
            ],
            'output' => [
                [
                    'element' => 'p',
                ],
            ],
        ]
    );
}
full_site_typography();
function acadia_footer_settings()
{

    new \Kirki\Section(
        'acadia_footer_section',
        [
            'title' => esc_html__('Footer', 'acadia'),
            'description' => esc_html__('Footer Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 190,
        ]
    );
    // footer_widget_number section 
    new \Kirki\Field\Select(
        [
            'settings' => 'footer_widget_number',
            'label' => esc_html__('Footer Widget Number', 'acadia'),
            'section' => 'acadia_footer_section',
            'default' => '4',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => [
                '1' => esc_html__('1', 'acadia'),
                '2' => esc_html__('2', 'acadia'),
                '3' => esc_html__('3', 'acadia'),
                '4' => esc_html__('4', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings' => 'acadia_footer_elementor_switch',
            'label' => esc_html__('Footer Custom/Elementor Switch', 'acadia'),
            'description' => esc_html__('Footer Custom/Elementor On/Off', 'acadia'),
            'section' => 'acadia_footer_section',
            'default' => 'off',
            'choices' => [
                'on' => esc_html__('Enable', 'acadia'),
                'off' => esc_html__('Disable', 'acadia'),
            ],
        ]
    );

    new \Kirki\Field\Radio_Image(
        [
            'settings' => 'footer_layout_custom',
            'label' => esc_html__('Footer Layout Control', 'acadia'),
            'section' => 'acadia_footer_section',
            'priority' => 10,
            'choices' => [
                'footer_1' => get_template_directory_uri() . '/inc/img/footer/footer-1.png',

            ],
            'default' => 'footer_1',
            'active_callback' => [
                [
                    'setting' => 'acadia_footer_elementor_switch',
                    'operator' => '==',
                    'value' => false
                ]
            ]
        ]
    );

    $footer_buildertype = array(
        'post_type' => 'tp-footer',
        'posts_per_page' => -1,
    );
    $footer_buildertype_loop = get_posts($footer_buildertype);
    $footer_post_obj_arr = array();
    foreach ($footer_buildertype_loop as $post) {
        $footer_post_obj_arr[$post->ID] = $post->post_title;
    }

    wp_reset_postdata();

    new \Kirki\Field\Select(
        [
            'settings' => 'acadia_footer_templates',
            'label' => esc_html__('Elementor Footer Template', 'acadia'),
            'section' => 'acadia_footer_section',
            'placeholder' => esc_html__('Choose an option', 'acadia'),
            'choices' => $footer_post_obj_arr,
            'active_callback' => [
                [
                    'setting' => 'acadia_footer_elementor_switch',
                    'operator' => '==',
                    'value' => true
                ]
            ]
        ]
    );


    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_copyright',
            'label' => esc_html__('Footer Copyright', 'acadia'),
            'section' => 'acadia_footer_section',
            'default' => esc_html__('© 2024 Acadia. All rights reserved.', 'acadia'),
            'priority' => 10,
        ]
    );
}
acadia_footer_settings();
function acadia_theme_colors()
{
    new \Kirki\Section(
        'acadia_theme_color_section',
        [
            'title' => esc_html__('Theme Colors', 'acadia'),
            'description' => esc_html__('Theme Color Settings.', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 190,
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_1',
            'label' => __('Theme Color 1', 'acadia'),
            'description' => esc_html__('Choose Your Color 1', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#AB0C2F',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_2',
            'label' => __('Theme Color 2', 'acadia'),
            'description' => esc_html__('Choose Your Color 2', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#1A73E8',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_3',
            'label' => __('Theme Color 3', 'acadia'),
            'description' => esc_html__('Choose Your Color 3', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#FF7162',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_4',
            'label' => __('Theme Color 4', 'acadia'),
            'description' => esc_html__('Choose Your Color 4', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#F0EC51',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_5',
            'label' => __('Theme Color 5', 'acadia'),
            'description' => esc_html__('Choose Your Color 5', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#006B61',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_6',
            'label' => __('Theme Color 6', 'acadia'),
            'description' => esc_html__('Choose Your Color 6', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#1E1E2F',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_7',
            'label' => __('Theme Color 7', 'acadia'),
            'description' => esc_html__('Choose Your Color 7', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#B1040E',
        ]
    );

    new \Kirki\Field\Color(
        [
            'settings' => 'acadia_color_8',
            'label' => __('New Home Theme Color', 'acadia'),
            'description' => esc_html__('Choose Your Color', 'acadia'),
            'section' => 'acadia_theme_color_section',
            'default' => '#5956E9',
        ]
    );
}

acadia_theme_colors();

// acadia_post_type_slug_section
function acadia_post_type_slug_section()
{
    new \Kirki\Section(
        'acadia_post_type_slug_section',
        [
            'title' => esc_html__('Slug Settings', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 190,
        ]
    );

    new \Kirki\Field\URL(
        [
            'settings' => 'acadia_portfolios_slug',
            'label' => esc_html__('Portfolios Slug', 'acadia'),
            'section' => 'acadia_post_type_slug_section',
            'default' => __('tp-portfolios', 'acadia'),
            'priority' => 10,
        ]
    );

    new \Kirki\Field\URL(
        [
            'settings' => 'acadia_services_slug',
            'label' => esc_html__('Services Slug', 'acadia'),
            'section' => 'acadia_post_type_slug_section',
            'default' => __('tp-services', 'acadia'),
            'priority' => 10,
        ]
    );

}
acadia_post_type_slug_section();

if ( class_exists( 'LearnPress' ) ) {
// acadia_post_type_learnpress_section
function acadia_post_type_learnpress_section()
{
    new \Kirki\Section(
        'acadia_post_type_learnpress_section',
        [
            'title' => esc_html__('Learnpress', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 190,
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings'    => 'acadia_lp_archive',
            'label'       => esc_html__( 'Select Learnpress Archive Style', 'acadia' ),
            'description' => esc_html__( 'This changes will work on learnpress course page.', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'style_1',
            'choices'     => [
                'style_1' => esc_html__( 'Style 1', 'acadia' ),
                'style_2' => esc_html__( 'Style 2', 'acadia' ),
                'style_3' => esc_html__( 'Style 3', 'acadia' ),
                'style_4' => esc_html__( 'Style 4', 'acadia' ),
                'style_5' => esc_html__( 'Style 5', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Pro\Field\Headline(
        [
            'settings'    => 'ac_lp_archive_head',
            'label'       => esc_html__( 'Learnpress Archive Page Settings', 'acadia' ),
            'description' => esc_html__( 'The below changes will be work on Learnpress course archive page', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
        ]
    );

    new \Kirki\Field\Number(
        [
            'settings' => 'ac_lp_course_per',
            'label'    => esc_html__( 'Course Per Page', 'acadia' ),
            'section'  => 'acadia_post_type_learnpress_section',
            'default'  => 12,
            'choices'  => [
                'min'  => 0,
                'max'  => 100,
                'step' => 1,
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_load_more_sw',
            'label'       => esc_html__( 'Enable/Disable Load More', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_sort_sw',
            'label'       => esc_html__( 'Enable/Disable Sort By', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_lp_archive',
                    'operator' => 'in',
                    'value'    => ['style_2', 'style_3', 'style_4', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_search_sw',
            'label'       => esc_html__( 'Enable/Disable Search', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_cat_sw',
            'label'       => esc_html__( 'Enable/Disable Category', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
        ]
    );


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_instructor_sw',
            'label'       => esc_html__( 'Enable/Disable Instructor', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_lp_archive',
                    'operator' => 'in',
                    'value'    => ['style_1', 'style_2', 'style_3', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_price_sw',
            'label'       => esc_html__( 'Enable/Disable Price', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_lp_archive',
                    'operator' => 'in',
                    'value'    => ['style_1', 'style_2', 'style_3', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_skill_sw',
            'label'       => esc_html__( 'Enable/Disable Skill', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_lp_archive',
                    'operator' => 'in',
                    'value'    => ['style_1', 'style_2', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_lp_rating_sw',
            'label'       => esc_html__( 'Enable/Disable Rating', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_lp_archive',
                    'operator' => '==',
                    'value'    => 'style_1',
                ]
            ],
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings'    => 'acadia_lp_details',
            'label'       => esc_html__( 'Learnpress Course Details Style', 'acadia' ),
            'description' => esc_html__( 'This changes will work on learnpress course details page.', 'acadia' ),
            'section'     => 'acadia_post_type_learnpress_section',
            'default'     => 'style_1',
            'choices'     => [
                'style_1' => esc_html__( 'Style 1', 'acadia' ),
                'style_2' => esc_html__( 'Style 2', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Field\Text(
        [
            'settings' => 'acadia_lp_details_msg',
            'label'    => esc_html__( 'Button Below Message', 'acadia' ),
            'section'  => 'acadia_post_type_learnpress_section',
            'default'  => esc_html__( '30-Day Money-Back Guarantee', 'acadia' ),
            'priority' => 10,
        ]
    );

}
acadia_post_type_learnpress_section();
}

if ( function_exists( 'masterstudy_lms_pre_get_document_title' ) ) {
// acadia_post_type_masterstudy_section
function acadia_post_type_masterstudy_section()
{
    new \Kirki\Section(
        'acadia_post_type_masterstudy_section',
        [
            'title' => esc_html__('Masterstudy', 'acadia'),
            'panel' => 'acadia_panel',
            'priority' => 190,
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings'    => 'acadia_ms_archive',
            'label'       => esc_html__( 'Select Masterstudy Archive Style', 'acadia' ),
            'description' => esc_html__( 'This changes will work on masterstudy course page.', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'style_1',
            'choices'     => [
                'style_1' => esc_html__( 'Style 1', 'acadia' ),
                'style_2' => esc_html__( 'Style 2', 'acadia' ),
                'style_3' => esc_html__( 'Style 3', 'acadia' ),
                'style_4' => esc_html__( 'Style 4', 'acadia' ),
                'style_5' => esc_html__( 'Style 5', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Pro\Field\Headline(
        [
            'settings'    => 'ac_ms_archive_head',
            'label'       => esc_html__( 'Masterstudy Archive Page Settings', 'acadia' ),
            'description' => esc_html__( 'The below changes will be work on Masterstudy course archive page', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
        ]
    );

    new \Kirki\Field\Number(
        [
            'settings' => 'ac_ms_course_per',
            'label'    => esc_html__( 'Course Per Page', 'acadia' ),
            'section'  => 'acadia_post_type_masterstudy_section',
            'default'  => 12,
            'choices'  => [
                'min'  => 0,
                'max'  => 100,
                'step' => 1,
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_load_more_sw',
            'label'       => esc_html__( 'Enable/Disable Load More', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_search_sw',
            'label'       => esc_html__( 'Enable/Disable Search', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_sort_sw',
            'label'       => esc_html__( 'Enable/Disable Sort By', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_ms_archive',
                    'operator' => 'in',
                    'value'    => [ 'style_1', 'style_2', 'style_3', 'style_4', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_cat_sw',
            'label'       => esc_html__( 'Enable/Disable Category', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_status_sw',
            'label'       => esc_html__( 'Enable/Disable Status', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_ms_archive',
                    'operator' => 'in',
                    'value'    => 'style_1',
                ],
            ],
        ]
    );


    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_instructor_sw',
            'label'       => esc_html__( 'Enable/Disable Instructor', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_ms_archive',
                    'operator' => 'in',
                    'value'    => ['style_1', 'style_2', 'style_3', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_price_sw',
            'label'       => esc_html__( 'Enable/Disable Price', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_ms_archive',
                    'operator' => 'in',
                    'value'    => ['style_1', 'style_2', 'style_3', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_skill_sw',
            'label'       => esc_html__( 'Enable/Disable Skill', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_ms_archive',
                    'operator' => 'in',
                    'value'    => ['style_1', 'style_2', 'style_5'],
                ],
            ],
        ]
    );

    new \Kirki\Field\Checkbox_Switch(
        [
            'settings'    => 'ac_ms_rating_sw',
            'label'       => esc_html__( 'Enable/Disable Rating', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'on',
            'choices'     => [
                'on'  => esc_html__( 'Enable', 'acadia' ),
                'off' => esc_html__( 'Disable', 'acadia' ),
            ],
            'active_callback' => [
                [
                    'setting'  => 'acadia_ms_archive',
                    'operator' => '==',
                    'value'    => 'style_1',
                ]
            ],
        ]
    );

    new \Kirki\Field\Number(
        [
            'settings' => 'ac_ms_course_per',
            'label'    => esc_html__( 'Course Per Page', 'acadia' ),
            'section'  => 'acadia_post_type_masterstudy_section',
            'default'  => 12,
            'choices'  => [
                'min'  => 0,
                'max'  => 100,
                'step' => 1,
            ],
        ]
    );

    new \Kirki\Field\Select(
        [
            'settings'    => 'acadia_ms_details',
            'label'       => esc_html__( 'Masterstudy Course Details Style', 'acadia' ),
            'description' => esc_html__( 'This changes will work on Masterstudy course details page.', 'acadia' ),
            'section'     => 'acadia_post_type_masterstudy_section',
            'default'     => 'style_1',
            'choices'     => [
                'style_1' => esc_html__( 'Style 1', 'acadia' ),
                'style_2' => esc_html__( 'Style 2', 'acadia' ),
            ],
        ]
    );
}
acadia_post_type_masterstudy_section();
}