<?php
/**
 * Single Product tabs
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Filter tabs and allow third parties to add their own
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $tabs ) ) : ?>
<div class="woocommerce-tabs">
	<ul id="tabs" class="product-tabs">
		<?php foreach ( $tabs as $key => $tab ) : ?>

			<li class="<?php echo $key ?>_tab">
				<a href="#tab-<?php echo $key ?>"><?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', $tab['title'], $key ) ?></a>
				<section><?php call_user_func( $tab['callback'], $key, $tab ) ?></section>
			</li>

		<?php endforeach; ?>
        <?php if (etheme_get_option('custom_tab_title') && etheme_get_option('custom_tab_title') != '' ) : ?>
            <li class="custom_tab">
                <a href="#custom"><?php  etheme_option('custom_tab_title'); ?></a>
                <section><?php echo do_shortcode(etheme_get_option('custom_tab')); ?></section>
            </li>
        <?php endif; ?>	 
        <?php if ( etheme_get_custom_field('_etheme_custom_tab1_title') ) : ?>
            <li class="custom_tab">
                <a href="#custom2"><?php etheme_custom_field('_etheme_custom_tab1_title'); ?></a>
                <section><?php echo do_shortcode(etheme_get_custom_field('_etheme_custom_tab1')) ?></section>
            </li>
        <?php endif; ?>	 
        <?php if ( etheme_get_custom_field('_etheme_custom_tab2_title') ) : ?>
            <li class="custom_tab">
                <a href="#custom3"><?php etheme_custom_field('_etheme_custom_tab2_title'); ?></a>
                <section><?php echo do_shortcode(etheme_get_custom_field('_etheme_custom_tab2')) ?></section>
            </li>
        <?php endif; ?>	 
	</ul>
	<div class="clear"></div>
</div>
	
<?php endif; ?>