<?php
/**
 * The loop that displays posts.
 *
 * The loop displays the posts and the post content.  See
 * http://codex.wordpress.org/The_Loop to understand it and
 * http://codex.wordpress.org/Template_Tags to understand
 * the tags used in it.
 *
 * This can be overridden in child themes with loop.php or
 * loop-template.php, where 'template' is the loop context
 * requested by a template. For example, loop-index.php would
 * be used if it exists and we ask for the loop with:
 * <code>get_template_part( 'loop', 'index' );</code>
 *
 */
?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if ( $wp_query->max_num_pages > 1 ) : ?>
	<div id="nav-above" class="navigation">
		<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', ETHEME_DOMAIN) ); ?></div>
		<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', ETHEME_DOMAIN) ); ?></div>
	    <div class="clear"></div>
    </div><!-- #nav-above -->
<?php endif; ?>

<?php /* If there are no posts to display, such as an empty archive page */ ?>
<?php if ( ! have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title"><?php _e( 'Not Found', ETHEME_DOMAIN); ?></h1>
		<div class="entry-content">
			<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', ETHEME_DOMAIN); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>

<?php
	/* Start the Loop.
	 *
	 * In Twenty Ten we use the same loop in multiple contexts.
	 * It is broken into three main parts: when we're displaying
	 * posts that are in the gallery category, when we're displaying
	 * posts in the asides category, and finally all other posts.
	 *
	 * Additionally, we sometimes check for whether we are on an
	 * archive page, a search page, etc., allowing for small differences
	 * in the loop on each template without actually duplicating
	 * the rest of the loop that is shared.
	 *
	 * Without further ado, the loop:
	 */ ?>
<?php while ( have_posts() ) : the_post(); ?>
        <?php 
            $blog_layout = etheme_get_option('blog_layout');
            
            switch ($blog_layout){ 
            	case 'default':
                    $imH = 300;
                    $imW = 725;
            	break;
            	case 'portrait':
                    $imH = 360;
                    $imW = 260;
            	break;
                default:
                    $blog_layout = 'default';
                    $imH = 870;
                    $imW = 870;
            
            }
            
            $imgUrl = etheme_get_image(false,$imW,$imH,false);
            
        ?>
        <?php if (has_post_thumbnail( get_the_ID() ) ): ?>
            <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() )); ?>
        <?php endif; ?>  
        
        <article id="post-<?php the_ID(); ?>" class="article <?php if($imgUrl == '') { echo 'without-image'; } else{ echo "with-image"; } ?>">
            <div <?php post_class(); ?>>
                <?php if(@$imgUrl && @$imgUrl!=''): ?>
                    <a href="<?php the_permalink(); ?>" class="article-image"><img src="<?php echo $imgUrl; ?>"/></a>    
                    <?php unset($imgUrl) ?>
            	<?php endif; ?>
                
                <div class="article-info">
                    <div class="article-date">
                        <span class="date-day"><?php the_time('d'); ?></span>
                        <span class="date-month"><?php the_time('M'); ?></span>
                    </div>
                    <h3 class="article-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', ETHEME_DOMAIN ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h3>
                
        			<div class="entry-utility">
            			<?php etheme_posted_by(); ?> /
        
        				<?php if ( count( get_the_category() ) ) : ?>
        					<span class="cat-links">
        						<?php printf( __( '<span class="%1$s">Posted in</span> %2$s', ETHEME_DOMAIN ), 'entry-utility-prep entry-utility-prep-cat-links', etheme_get_the_category_list( ', ' ) ); ?>
        					</span>
        					<span class="meta-sep">|</span>
        				<?php endif; ?>
        				<?php
        					$tags_list = get_the_tag_list( '', ', ' );
        					if ( $tags_list ):
        				?>
        					<span class="tag-links">
        						<?php printf( __( '<span class="%1$s">Tagged</span> %2$s', ETHEME_DOMAIN ), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list ); ?>
        					</span>
        					<span class="meta-sep">|</span>
        				<?php endif; ?>
        				<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', ETHEME_DOMAIN ), __( '1 Comment', ETHEME_DOMAIN ), __( '% Comments', ETHEME_DOMAIN ) ); ?></span>
        				<?php edit_post_link( __( 'Edit', ETHEME_DOMAIN ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>
        			</div><!-- .entry-utility -->  
                    <div class="clear"></div>
                </div>
                
            	<?php if ( is_archive() || is_search() ) : // Only display excerpts for archives and search. ?>
            			<div class="entry-summary">
            				<?php the_excerpt(); ?>
            			</div><!-- .entry-summary -->
            	<?php else : ?>
            			<div class="entry-content">
            				<?php the_content( __( '<span class="button active fl-r"><span>Read More</span></span><br/>', ETHEME_DOMAIN ) ); ?>
            				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', ETHEME_DOMAIN ), 'after' => '</div>' ) ); ?>
            			</div><!-- .entry-content -->
            	<?php endif; ?>              
                <div class="clear"></div>
		          <?php comments_template( '', true ); ?>
            </div>
        </article>   


<?php endwhile; // End the loop. Whew. ?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if (  $wp_query->max_num_pages > 1 ) : ?>
				<div id="nav-below" class="navigation">
					<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', ETHEME_DOMAIN ) ); ?></div>
					<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', ETHEME_DOMAIN ) ); ?></div>
				</div><!-- #nav-below -->
<?php endif; ?>
