<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WorkScout
 */

get_header(); ?>


	<div id="titlebar" class="single">
		<div class="container">

			<div class="sixteen columns">
				<h1 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'workscout' ), '<em>' . get_search_query() . '</em>' ); ?></h1>
			</div>

		</div>
	</div>
			
<?php $layout = Kirki::get_option( 'workscout', 'pp_blog_layout' ); ?>

<div class="container <?php echo esc_attr($layout); ?>">

	<!-- Blog Posts -->
	<div class="eleven columns">
		<div class="padding-right">
		<?php if ( have_posts() ) : ?>

			<?php while ( have_posts() ) : the_post(); ?>

				<?php
				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', 'search' );
				?>

			<?php endwhile; ?>

			<?php if(function_exists('wp_pagenavi')) { 
				wp_pagenavi(array(
					'next_text' => '<i class="fa fa-chevron-right"></i>',
					'prev_text' => '<i class="fa fa-chevron-left"></i>',
					'use_pagenavi_css' => false,
					));
			} else {
				workscout_posts_navigation(array(
		 			'prev_text'  => ' ',
		            'next_text'  => ' ',
				)); 
			} ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>
		</div>
	</div>
	<!-- Blog Posts / End -->
	<?php get_sidebar(); ?>

</div>

<?php get_footer(); ?>

