---
layout: blog
title: Kirki 2.2.7 goodies and new toys
---

Kirki 2.2.7 was just released and with it we have a couple new toys for you!

In this version we fixed a few bugs, mostly regarding the `output` & the `js_vars` arguments. And there were also a few more tweaks:

#### Using `auto` transport

Though technically this was introduced in 2.2.6, we now refined it and it's a lot better!

If you use `'transport' => 'auto'` you no longer have to write `js_vars`, they will be automatically generated for you from your field's `output` argument.

#### Introducing the `value_pattern` argument in `output`

Have you ever tried using Kirki to calculate complex CSS values?
Say for example you wanted a color control to create this CSS for you:

```css
box-shadow: 10px 0 0 #222, -10px 0 0 #222;
```

In previous versions doing that would be a mess and would basically require you to create a custom callback for that output. And this is where the `value_pattern` argument comes in handy:

```php
'output' => array(
	array(
		'element'       => '#my-div',
		'property'      => 'box-shadow',
		'value_pattern' => '10px 0 0 $, -10px 0 0 $',
	),
),
```

Pretty neat, right? You can even use it to calculate a width using `calc` like `calc(100% - $)` and imagine new ways to take advantage of it. It works equally well on `output` and `js_vars`, though we advise you to use the new `auto` mode for transports to avoid code duplication. There's no reason for you to write the same things twice.

#### New multicolor control

'Nuff said. Check the docs on [https://aristath.github.io/kirki/docs/controls/multicolor.html](https://aristath.github.io/kirki/docs/controls/multicolor.html) and try it. IT'S AWESOME!!

#### Changed `js_vars` mode

If you've ever used `js_vars` with pseudo-elements (like `a:hover`), then you know that it didn't work unless you set the `function` argument to `style`.

No more!

Whether you use `style` or `css` we now inject your styles in stylesheets in your document's `<head>` instead of adding them inline in your markup.
This simplifies the way we write things as we just take another thing off your head. No more worries... Just write the `output`, set `transport` to `auto` and Kirki takes care of everything else. Doesn't matter if you use pseudo-elements or not, it'll all work the same.

A big thanks to all of you for your support and encouragement!
As always, if you have any issues you can find me in github in the [issues queue](https://github.com/aristath/kirki/issues). :)
