---
layout: blog
title: Kirki 2.2.5 will radically change the way we handle postMessage scripts
---

Kirki 2.2.5 (still in beta) is bringing some changes in the way we're handling `js_vars`.

Until now, our implementation was mostly PHP-based: the fields were getting parsed by a PHP script, and then the necessary javascript was generated and enqueued in the footer.

In 2.2.5, we're changing the implementation to one that's mostly JS-based:

Fields are parsed in PHP and an array of fields that contain js_vars is stored in a variable.
That variable is then passed-on to JS using the [`wp_localize_script`](https://codex.wordpress.org/Function_Reference/wp_localize_script) function. the JS script then gets the values, detects any changes, and applies the CSS to apply your changes instantly.

The benefits of the new method is that it's a lot cleaner, and more performant, especially in cases where we have a lot of options, since there's now only 1 script to process in the browser instead of one for every control that uses `js_vars`.

This change will also allow us in the future to handle postMessage scripts for composite fields like `typography` and `spacing.

### Other changes in 2.2.5:

Another great addition is the fact that you will now be able to pass options to your color fields using the `choices` argument.

So if for example you want to change the palette, you can add this:

```
'choices' => array(
	'palettes' => array(
		'#F44336',
		'#E91E63',
		'#9C27B0',
		'#673AB7',
		'#3F51B5',
		'#2196F3',
	),
),
```

You can find a list of available options in the [Iris documentation](http://automattic.github.io/Iris/#options)

### How can you help?

You can help by testing the new implementation and letting us know if you find any issues.
You can test it by downloading the develop branch from our [github repository](https://github.com/aristath/kirki/tree/develop) (click on the "download zip" button).

You can report any issues you find in out [issues queue](https://github.com/aristath/kirki/issues).
