<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.2
 */
global $product;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! comments_open() ) {
	return;
}
?>
<div id="messages" class="tab-pane active " role="tabpanel">

	<div class="tab-p-details">
		<div class="review_panel">
			<div class="col-md-6">
				<div class="review_comments">
					<div class="review_heading">
						<div class="review_heading_left">
								<h2><?php
									if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' && ( $count = $product->get_review_count() ) )
										printf( _n( '%s review for %s', '%s reviews for %s', $count, 'wooland' ), $count, get_the_title() );
									else
										_e( 'Reviews', 'wooland' );
									?>
								</h2>
						</div>
					</div>
			

						<?php if ( have_comments() ) : ?>

							<ul class="commentlist">
								<?php wp_list_comments( apply_filters( 'woocommerce_product_review_list_args', array( 'callback' => 'woocommerce_comments' ) ) ); ?>
							</ul>

							<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
								echo '<nav class="woocommerce-pagination">';
								paginate_comments_links( apply_filters( 'woocommerce_comment_pagination_args', array(
									'prev_text' => '&larr;',
									'next_text' => '&rarr;',
									'type'      => 'list',
								) ) );
								echo '</nav>';
							endif; ?>

						<?php else : ?>

							<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'wooland' ); ?></p>

						<?php endif; ?>
				</div>
			</div>
			<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->id ) ) : ?>

			<div id="review_form_wrapper">
				<div id="review_form">
					<div class="col-md-6">
						<div class="Review_input">
							<?php
								$commenter = wp_get_current_commenter();

								$comment_form = array(
									'title_reply'          => have_comments() ? esc_html__( 'Write Your Review', 'wooland' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'wooland' ), get_the_title() ),
									'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'wooland' ),
									'comment_notes_before' => '',
									'comment_notes_after'  => '',
									'fields'               => array(
										'author' => //'<p class="comment-form-author">' . '<label for="author">' . esc_html__( '', 'wooland' ) . ' <span class="required"></span></label> ' .
										            '<input id="author" class="comment-form-author" name="author" placeholder="Enter Your Nickname" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="60" aria-required="true" />',
										'email'  => //'<p class="comment-form-email"><label for="email">' . esc_html__( '', 'wooland' ) . ' <span class="required"></span></label> ' .
										            '<input id="email" class="comment-form-email" name="email" placeholder="Summary of your Review" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="60" aria-required="true" />',
									),
									'label_submit'  => esc_html__( 'Submit', 'wooland' ),
									'logged_in_as'  => '',
									'comment_field' => ''
								);

								if ( $account_page_url = wc_get_page_permalink( 'myaccount' ) ) {
									$comment_form['must_log_in'] = '<p class="must-log-in">' .  sprintf( __( 'You must be <a href="%s">logged in</a> to post a review.', 'wooland' ), esc_url( $account_page_url ) ) . '</p>';
								}

								if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
									$comment_form['comment_field'] = '<p class="comment-form-rating"><select name="rating" id="rating">
										<option value="">' . esc_html__( 'Rate&hellip;', 'wooland' ) . '</option>
										<option value="5">' . esc_html__( 'Perfect', 'wooland' ) . '</option>
										<option value="4">' . esc_html__( 'Good', 'wooland' ) . '</option>
										<option value="3">' . esc_html__( 'Average', 'wooland' ) . '</option>
										<option value="2">' . esc_html__( 'Not that bad', 'wooland' ) . '</option>
										<option value="1">' . esc_html__( 'Very Poor', 'wooland' ) . '</option>
									</select></p>';
								}

								$comment_form['comment_field'] .= '<p class="comment-form-comment"><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea></p>';

								comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
							?>
						</div>	

					</div>
				</div>
			</div>


			<?php else : ?>

				<p class="woocommerce-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'wooland' ); ?></p>

			<?php endif; ?>

			<div class="clear"></div>
		</div>
	</div>
</div>




