<?php

/**

 * The template for displaying product content within loops.

 *

 * Override this template by copying it to yourtheme/woocommerce/content-product.php

 *

 * @author 		WooThemes

 * @package 	WooCommerce/Templates

 * @version     2.5.0

 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $product, $woocommerce_loop;

// Store loop count we're currently on

if ( empty( $woocommerce_loop['loop'] ) )

	$woocommerce_loop['loop'] = 0;

// Store column count for displaying the grid

if ( empty( $woocommerce_loop['columns'] ) )

	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 3 );

// Ensure visibility

if ( ! $product || ! $product->is_visible() )

	return;

// Increase loop count

$woocommerce_loop['loop']++;

// Extra post classes

$classes = array();

if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] )

	$classes[] = 'first1';

if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] )

	$classes[] = 'last1';

$classes[] = 'col-md-3 col-sm-4 col-xs-12';
	?>
	<?php

$meta = wooland_WSH()->get_meta('_sh_layout_settings', get_option( 'woocommerce_shop_page_id' ));
$meta1 = wooland_WSH()->get_meta('_sh_single_product_options');

//print_r($meta1);

$layout = wooland_wow_sh_set( $meta, 'layout', 'full' );

$layout = wooland_wow_sh_set( $_GET, 'layout' ) ? $_GET['layout'] : $layout;

if( !$layout || $layout == 'full' ||wooland_wow_sh_set($_GET, 'layout_style')=='full' ) $classes[] = 'col-lg-3 col-md-3 col-sm-3 col-xs-12'; else $classes[] = 'col-lg-3 col-md-3 col-sm-4 col-xs-12'; 

$attachment_ids = $product->get_gallery_attachment_ids();
$options = wooland_WSH()->option();
$hide_overlay = wooland_wow_sh_set($options,'hide_overlay');
$badge = wooland_wow_sh_set($meta1,'badge');		
//print_r($badge); exit();


?>

<div <?php  post_class( $classes ); ?>>

	



	<?php //do_action( 'woocommerce_before_shop_loop_item' ); ?>

	

	<?php /** Customized add to cart button */

	$cart_button = apply_filters( 'woocommerce_loop_add_to_cart_link',

		sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" data-quantity="%s" class="price a1 %s product_type_%s"><i class="icon-cart"></i></a>',

			esc_url( $product->add_to_cart_url() ),

			esc_attr( $product->id ),

			esc_attr( $product->get_sku() ),

			esc_attr( isset( $quantity ) ? $quantity : 1 ),

			$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',

			esc_attr( $product->product_type ),

			esc_html( $product->add_to_cart_text() )

		),

	$product ); ?>

		
		<div class="single_suite">
			
			<div class="single_suite_img1 hover_img effect">
				<a href="<?php the_permalink();?>">
					<?php the_post_thumbnail('wooland_wow_themes_244x370', array('class' => 'img-responsive'));?>
				</a>
				<?php 
					$post_thumbnail_id = get_post_thumbnail_id($post->ID);
					$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
				?>
				
				<?php if($badge): ?>
					<div class="badge"><a href="#"><?php echo balanceTags($badge); ?></a></div>
				<?php endif; ?>
			
				
				<div class="cc_hover">
					
					<ul class="cc_hover_ul">
						<li class="h_cart"><a class="fa fa-shopping-cart" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"></a></li>
						
						<?php $wishlist_url = add_query_arg('add_to_wishlist', get_the_id());?>
						<li class="h_heart"><a class="fa fa-heart add_to_wishlist" data-product-type="<?php echo esc_attr($product->product_type); ?>" href="<?php echo esc_attr($wishlist_url); ?>" data-product-id="<?php the_ID(); ?>"></a></li>
						<li class="h_search">
							<a data-toggle="modal" data-product_id="<?php the_ID(); ?>"  class="wooland-product-quick-view" href="<?php the_permalink(); ?>"></a>
							<div class="product-quick-view-button"><a data-product_id="<?php the_ID(); ?>" class="fa fa-search button yith-wcqv-button" href="#"></a></div>
						</li>
					</ul>

				</div>

				<div class="common_overlay"></div>
			</div>
			
			<div class="single_suite_text">
				<a href="<?php the_permalink();?>"><h3><?php the_title();?></h3></a>
			</div>
			<div class="yith-wcwl-add-to-wishlist add-to-wishlist-<?php the_ID(); ?>">
		<div class="yith-wcwl-add-button show" style="display:block">
			<img src="<?php echo get_template_directory_uri(); ?>/images/wpspin_light.gif" class="ajax-loading" alt="loading" width="16" height="16" style="visibility:hidden" />
		</div>
		<div class="yith-wcwl-wishlistaddedbrowse hide" style="display:none;">
			<span class="feedback"><?php esc_html_e('Product added!', 'wooland'); ?></span>
			<?php $whishlist= get_option(the_ID());  //print_r($whishlist); //exit(); ?>
			<?php $whishlist_txt = get_option( 'yith_wcwl_browse_wishlist_text', '' ); ?> 
			<a href="<?php get_permalink(the_ID()); ?>" rel="nofollow">
					<?php echo balanceTags($whishlist_txt); ?>
			</a>
		</div>
		 
		<div class="yith-wcwl-wishlistexistsbrowse hide" style="display:none">
			<?php $whishlist_txt2 = get_option( 'yith_wcwl_already_in_wishlist_text', '' ); ?> 
			<span class="feedback"><?php echo balanceTags($whishlist_txt2); ?></span>
			<a href="<?php get_permalink(the_ID()); ?>" rel="nofollow">
					<?php echo balanceTags($whishlist_txt); ?>	        
			</a>
		</div>

		<div style="clear:both"></div>
		<div class="yith-wcwl-wishlistaddresponse"></div>								
	</div>

			<div class="single_suite_left">
				<?php woocommerce_template_loop_price();?>
										
			</div>

			<div class="single_suite_right woocommerce">
				<?php woocommerce_template_loop_rating(); ?>
			</div>

		</div>


</div>

<?php //do_action( 'woocommerce_after_shop_loop_item' ); ?>	