<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;
?>

<?php
	/**
	 * woocommerce_before_single_product hook.
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
?>

<div itemscope itemtype="<?php echo woocommerce_get_product_schema(); ?>" id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<div class="single_product_container clearfix">
	
    	<div class="col-md-5 col-sm-5 col-xs-12 no-padding">
    		<div class="single_product_image">
    			<div class="">
    
    				<input type="hidden" id="__VIEWxSTATE" />
    				<?php
    					/**
    					 * woocommerce_before_single_product_summary hook.
    					 *
    					 * @hooked woocommerce_show_product_sale_flash - 10
    					 * @hooked woocommerce_show_product_images - 20
    					 */
    					do_action( 'woocommerce_before_single_product_summary' );
    				?>
    
    			</div>
    		</div>
    	</div>
    
    	
    	<div class="col-md-7 col-sm-7 col-xs-cc2 no-padding">
    		<div class="p_detail_right">
    			<div class="p_slider_box_details">
    				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><h3><?php the_title();?></h3></a>
    				<div class="single_suite_right">
    					
    						<?php woocommerce_template_single_rating(); ?>
    					
    				
    				</div>
    				<?php woocommerce_template_single_excerpt(); ?>
    			</div>
    			<?php woocommerce_template_single_add_to_cart(); ?>
    		</div>
    		<div class="pd_total">
    			<div class="pdq_left">
    				<p><?php esc_html_e('Total Price', 'wooland'); ?></p>
    				<span><?php woocommerce_template_loop_price();?></span>
    			</div>
    			
    			<?php $stock = $product->get_stock_quantity(); 
    				if ($stock) : ?>
    					<div class="in_stock">
    						<a href="javascript:;">In stock</a>
    					</div>
    			<?php endif; ?>	
    			<?php
    					/**
    					 * woocommerce_before_single_variation Hook.
    					 */
    					//do_action( 'woocommerce_before_single_variation' );
    
    					/**
    					 * woocommerce_single_variation hook. Used to output the cart button and placeholder for variation data.
    					 * @since 2.4.0
    					 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
    					 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
    					 */
    					//do_action( 'woocommerce_single_variation' );
    
    					/**
    					 * woocommerce_after_single_variation Hook.
    					 */
    					//do_action( 'woocommerce_after_single_variation' );
    				?>
    		</div>
    		
    		<div class="summary entry-summary">
        
        		<?php
        			/**
        			 * woocommerce_single_product_summary hook.
        			 *
        			 * @hooked woocommerce_template_single_title - 5
        			 * @hooked woocommerce_template_single_rating - 10
        			 * @hooked woocommerce_template_single_price - 10
        			 * @hooked woocommerce_template_single_excerpt - 20
        			 * @hooked woocommerce_template_single_add_to_cart - 30
        			 * @hooked woocommerce_template_single_meta - 40
        			 * @hooked woocommerce_template_single_sharing - 50
        			 */
        			do_action( 'woocommerce_single_product_summary' );
        		?>
        	</div><!-- .summary -->
    	</div>							
    
    </div>    	

	<?php
		/**
		 * woocommerce_after_single_product_summary hook.
		 *
		 * @hooked woocommerce_output_product_data_tabs - 10
		 * @hooked woocommerce_upsell_display - 15
		 * @hooked woocommerce_output_related_products - 20
		 */
		do_action( 'woocommerce_after_single_product_summary' );
	?>

	<meta itemprop="url" content="<?php the_permalink(); ?>" />

</div><!-- #product-<?php the_ID(); ?> -->

<?php do_action( 'woocommerce_after_single_product' ); ?>
