<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.3.8
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

wc_print_notices();

do_action( 'woocommerce_before_cart' ); ?>

<section class="cart_main_area">
	<form action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">

		<?php do_action( 'woocommerce_before_cart_table' ); ?>	
		<div class="shop-cart-table">
			<div class="cart_main">
				<table class="shop_table shop_table_responsive cart">
					<thead class="cart_head">
						<tr>
							
							
							<th class="product_name"><?php esc_html_e( 'PRODUCT', 'wooland' ); ?></th>
							<th class="product_price"><?php esc_html_e( 'PRICE', 'wooland' ); ?></th>
							<th class="product_quantity"><?php esc_html_e( 'QUANTITY', 'wooland' ); ?></th>
							<th class="product_total"><?php esc_html_e( 'TOTal PRICE', 'wooland' ); ?></th>
							<th class="product_remove"><?php esc_html_e( 'REMOVE', 'wooland' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php do_action( 'woocommerce_before_cart_contents' ); ?>

							<?php
							foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
								$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
								$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

								if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
									?>
									<tr class="cart_detail <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">

								
										<td class="product_name" data-title="<?php esc_html_e( 'Product', 'wooland' ); ?>">
											
											<div class="product_cart_img">
												<?php
													$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

													if ( ! $_product->is_visible() ) {
														echo balanceTags($thumbnail);
													} else {
														printf( '<a href="%s">%s</a>', esc_url( $_product->get_permalink( $cart_item ) ), $thumbnail );
													}
												?>
											</div>

											<div class="product_cart_text">
											<?php
												if ( ! $_product->is_visible() ) {
													echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;';
												} else {
													echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<h5><a href="%s">%s</a></h5>', esc_url( $_product->get_permalink( $cart_item ) ), $_product->get_title() ), $cart_item, $cart_item_key );
												}

												// Meta data
												echo WC()->cart->get_item_data( $cart_item );

												// Backorder notification
												if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
													echo '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'wooland' ) . '</p>';
												}
											?>
											</div>
										</td>
										

										<td class="product_price" data-title="<?php esc_html_e( 'Price', 'wooland' ); ?>">
										
											<?php
												echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
											?>

									
										</td>

										<td class="product_quantity" data-title="<?php esc_html_e( 'Quantity', 'wooland' ); ?>">
											<?php
												if ( $_product->is_sold_individually() ) {
													$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
												} else {
													$product_quantity = woocommerce_quantity_input( array(
														'input_name'  => "cart[{$cart_item_key}][qty]",
														'input_value' => $cart_item['quantity'],
														'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
														'min_value'   => '0'
													), $_product, false );
												}

												echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
											?>
										</td>

										<td class="product_total" data-title="<?php esc_html_e( 'Total', 'wooland' ); ?>">
											<?php
												echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
											?>
										</td>
											<td class="product_remove">
											<?php
												echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
													'<a href="%s" class="remove" title="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
													esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
													__( 'Remove this item', 'wooland' ),
													esc_attr( $product_id ),
													esc_attr( $_product->get_sku() )
												), $cart_item_key );
											?>
										</td>
									</tr>
									<?php
								}
							}
							?>
							
								
								
								<?php do_action( 'woocommerce_cart_contents' );
								?>
								
								<tr class="col-md-4 code-apply no-padding">
									<div class="cart_detail ever_last">
										<td colspan="6" class="actions">
											<div class="product_name apply">
												<?php if ( wc_coupons_enabled() ) { ?>
													<div class="input_name">

													 	<input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'ENtER COUPON CODE', 'wooland' ); ?>" /> 
													 	<input type="submit" class="button" name="apply_coupon" value="<?php esc_attr_e( 'Apply', 'wooland' ); ?>" />

														<?php do_action( 'woocommerce_cart_coupon' ); ?>
													</div>
												<?php } ?>

											

												<?php do_action( 'woocommerce_cart_actions' ); ?>

												<?php wp_nonce_field( 'woocommerce-cart' ); ?>
											</div>
										</td>
									</div>
								</tr>
									<?php wc_cart_totals_shipping_html(); ?>
							
							
							<?php do_action( 'woocommerce_after_cart_contents' ); ?>
		
					</tbody>
				</table>

<?php do_action( 'woocommerce_after_cart_table' ); ?>

</form>
</div>
        </div>
<div class="cart-collaterals">

	<?php do_action( 'woocommerce_cart_collaterals' ); ?>

</div>
</section>
<?php do_action( 'woocommerce_after_cart' ); ?>




