<?php
/**
 * Variable product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/variable.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.5.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
//exit();
global $product;

$attribute_keys = array_keys( $attributes );
 $product_meta = wooland_WSH()->get_meta('_sh_single_product_options');
//exit;
$product_color = wooland_wow_themes_set( $product_meta, 'product_color' );
$product_color = array_filter((array)$product_color);

$color_html = "\n";

if( $product_color )
foreach( $product_color as $ind => $p_color ) 
{
	if( !wooland_wow_themes_set( $p_color, 'prod_color' ) ) continue;
	$color_html .= '<li><a style="background-color:'.wooland_wow_themes_set( $p_color, 'prod_color') .'"></a></li>' . "\n";
}

do_action( 'woocommerce_before_add_to_cart_form' ); ?>

<div class="pd_color">
	
	<p><?php esc_html_e('COLORS', 'wooland'); ?></p>
	
	<ul class="s_colors">
		<?php echo $color_html; ?>
	</ul>
	
</div>

<form class="variations_form cart" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->id ); ?>" data-product_variations="<?php echo htmlspecialchars( json_encode( $available_variations ) ) ?>">
	<?php do_action( 'woocommerce_before_variations_form' ); ?>

	<?php if ( empty( $available_variations ) && false !== $available_variations ) : ?>
		<p class="stock out-of-stock"><?php _e( 'This product is currently out of stock and unavailable.', 'wooland' ); ?></p>
	<?php else : ?>
		<table class="variations">
			<tbody>
				<?php foreach ( $attributes as $attribute_name => $options ) : ?>
					<tr>
						<td class="label"><label for="<?php echo sanitize_title( $attribute_name ); ?>"><?php echo wc_attribute_label( $attribute_name ); ?></label></td>
						<td class="value">
							<?php
								$selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) : $product->get_variation_default_attribute( $attribute_name );
								wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected, 'class'=>'dropdown-boxes' ) );
								echo end( $attribute_keys ) === $attribute_name ? apply_filters( 'woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . __( 'Clear', 'wooland' ) . '</a>' ) : '';
							?>
						</td>
					</tr>
		        <?php endforeach;?>
			</tbody>
		</table>
			
		<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

		<div class="single_variation_wrap clearfix">
			<?php
				/**
				 * woocommerce_before_single_variation Hook.
				 */
				do_action( 'woocommerce_before_single_variation' );

				/**
				 * woocommerce_single_variation hook. Used to output the cart button and placeholder for variation data.
				 * @since 2.4.0
				 * @hooked woocommerce_single_variation - 10 Empty div for variation data.
				 * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
				 */
				do_action( 'woocommerce_single_variation' );

				/**
				 * woocommerce_after_single_variation Hook.
				 */
				do_action( 'woocommerce_after_single_variation' );
			?>
				<?php $wishlist_url = add_query_arg('add_to_wishlist', get_the_id()); ?>
					<div class="pdq_right">
						<a data-product-id="<?php the_ID(); ?>" class="add_to_wishlist add_w" data-product-type="<?php echo esc_attr($product->product_type); ?>" href="<?php echo esc_attr($wishlist_url); ?>"><i class="fa fa-heart"></i>ADD TO WISHLIST</a>
					</div>
					 <div class="yith-wcwl-add-to-wishlist add-to-wishlist-<?php the_ID(); ?>">
			            <div class="yith-wcwl-add-button show" style="display:block">
			                <img src="<?php echo get_template_directory_uri(); ?>/images/wpspin_light.gif" class="ajax-loading" alt="loading" width="16" height="16" style="visibility:hidden" />
			            </div>
			            <div class="yith-wcwl-wishlistaddedbrowse hide" style="display:none;">
			                <span class="feedback"><?php esc_html_e('Product added!' ,'wooland' );  ?></span>
			                 <a href="#" rel="nofollow">
			                 	<?php esc_html_e('Browse Wishlist' , 'wooland');  ?>
			                 </a>
			            </div>
			            <div class="yith-wcwl-wishlistexistsbrowse hide" style="display:none">
			                <span class="feedback"><?php esc_html_e('The product is already in the wishlist! ','wooland' ); ?></span>
			                <a href="#" rel="nofollow">
			                    <?php esc_html_e('Browse Wishlist','wooland'); ?>
			                </a>
			            </div>
			        <div style="clear:both"></div>
			        <div class="yith-wcwl-wishlistaddresponse"></div>
			  </div>
		</div>

		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
		<?php endif; ?>

		<?php do_action( 'woocommerce_after_variations_form' ); ?>
</form>

<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>
