<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

if ( ! $product->is_purchasable() ) {
	return;
}
//exit();
?>

<?php
	// Availability
	$availability      = $product->get_availability();
	$availability_html = empty( $availability['availability'] ) ? '' : '<p class="stock ' . esc_attr( $availability['class'] ) . '">' . esc_html( $availability['availability'] ) . '</p>';

	echo apply_filters( 'woocommerce_stock_html', $availability_html, $availability['availability'], $product );
?>
<?php
//$attribute_keys = array_keys( $attributes );
 $product_meta = wooland_WSH()->get_meta('_sh_single_product_options');
//exit;
$product_color = wooland_wow_themes_set( $product_meta, 'product_color' );
$product_color = array_filter((array)$product_color);

$color_html = "\n";

if( $product_color )
foreach( $product_color as $ind => $p_color ) 
{
	if( !wooland_wow_themes_set( $p_color, 'prod_color' ) ) continue;
	$color_html .= '<li><a style="background-color:'.wooland_wow_themes_set( $p_color, 'prod_color') .'"></a></li>' . "\n";
}
 if ( $product->is_in_stock() ) : ?>

	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>
	
	<div class="pd_color">
	
	<p><?php esc_html_e('COLORS', 'wooland'); ?></p>
	
	<ul class="s_colors">
		<?php echo $color_html; ?>
	</ul>
	
</div>

	<form class="cart" method="post" enctype='multipart/form-data'>
	 	<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>
	 	
	 	<div class="single_variation_wrap clearfix">
    	 	<div class="woocommerce-variation-add-to-cart">
    
        	 	<?php
        
        	 		if ( ! $product->is_sold_individually() ) {
        	 			woocommerce_quantity_input( array(
        	 				
        	 				'min_value'   => apply_filters( 'woocommerce_quantity_input_min', 1, $product ),
        	 				'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->backorders_allowed() ? '' : $product->get_stock_quantity(), $product ),
        	 				'input_value' => ( isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : 1 )
        	 				
        	 			) );
        	 		}
        	 	?>
        
        	 	<input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->id ); ?>" />
        
        	 	<button type="submit" class="single_add_to_cart_button button alt"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></button>
        
    		</div>
		</div>
		<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
	</form>

	<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>

<?php endif; ?>
