<?php
/**
 * Cart totals
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-totals.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.6
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$available_methods = wooland_wow_themes_set( wooland_wow_themes_set(wooland_WSH(), 'data'), 'available_methods' );
$index = wooland_wow_themes_set( wooland_wow_themes_set(wooland_WSH(), 'data'), 'index' );
?>
<section class="cart_subtotal_area">
	<div class="container">
		<div class="row">
			<div class="cart_totals <?php if ( WC()->customer->has_calculated_shipping() ) echo 'calculated_shipping'; ?>">

				<?php do_action( 'woocommerce_before_cart_totals' ); ?>

		

				<table cellspacing="0" class="shop_table shop_table_responsive">
				
					<tr class="cart-subtotal col-md-5 no-padding">
						
							<th>
								<div class="subtotal_cart">
									<p><?php _e( 'CartSubtotal', 'wooland' ); ?><?php wc_cart_totals_subtotal_html(); ?></p>
								</div>
							</th>
						       
						
							<td>
								<label>SHIPPING & HANDLING :</label>
								<?php if ( 1 === count( $available_methods ) ) :  ?>
								<?php
									$method = current( (array)$available_methods );
									if( $method ) {
    									printf( '%3$s <input type="hidden" name="shipping_method[%1$d]" data-index="%1$d" id="shipping_method_%1$d" value="%2$s" class="shipping_method" />', $index, esc_attr( $method->id ), wc_cart_totals_shipping_method_label( $method ) );
    									do_action( 'woocommerce_after_shipping_rate', $method, $index );
									}
								endif; ?>
							</td>
					</tr>
					

					<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
						<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
							<th><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
							<td data-title="<?php wc_cart_totals_coupon_label( $coupon ); ?>"><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
						</tr>
					<?php endforeach; ?>

					<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>

						<?php do_action( 'woocommerce_cart_totals_before_shipping' ); ?>

					

						<?php do_action( 'woocommerce_cart_totals_after_shipping' ); ?>

					<?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>

						<tr class="shipping">
							<th><?php _e( 'Shipping', 'wooland' ); ?></th>
							<td data-title="<?php _e( 'Shipping', 'wooland' ); ?>"><?php woocommerce_shipping_calculator(); ?></td>
						</tr>

					<?php endif; ?>

					<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
						<tr class="fee">
							<th><?php echo esc_html( $fee->name ); ?></th>
							<td data-title="<?php echo esc_html( $fee->name ); ?>"><?php wc_cart_totals_fee_html( $fee ); ?></td>
						</tr>
					<?php endforeach; ?>

					<?php if ( wc_tax_enabled() && 'excl' === WC()->cart->tax_display_cart ) :
						$taxable_address = WC()->customer->get_taxable_address();
						$estimated_text  = WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping()
								? sprintf( ' <small>(' . __( 'estimated for %s', 'wooland' ) . ')</small>', WC()->countries->estimated_for_prefix( $taxable_address[0] ) . WC()->countries->countries[ $taxable_address[0] ] )
								: '';

						if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
							<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
								<tr class="tax-rate tax-rate-<?php echo sanitize_title( $code ); ?>">
									<th><?php echo esc_html( $tax->label ) . $estimated_text; ?></th>
									<td data-title="<?php echo esc_html( $tax->label ); ?>"><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
								</tr>
							<?php endforeach; ?>
						<?php else : ?>
							<tr class="tax-total">
								<th><?php echo esc_html( WC()->countries->tax_or_vat() ) . $estimated_text; ?></th>
								<td data-title="<?php echo esc_html( WC()->countries->tax_or_vat() ); ?>"><?php wc_cart_totals_taxes_total_html(); ?></td>
							</tr>
						<?php endif; ?>
					<?php endif; ?>

					<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>

					<tr class="order-total total_cart col-md-2 no-padding">
						<th><?php _e( 'CART TOTAL:', 'wooland' ); ?></th>
						<td data-title="<?php _e( 'Total', 'wooland' ); ?>"><?php wc_cart_totals_order_total_html(); ?>
					
						</td>
					</tr>
					<tr class="col-md-5">
						<td>
								<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
							<div class="update_cart">
													
								<input type="submit" class="button" name="update_cart" value="<?php esc_attr_e( 'UPDATE CART', 'wooland' ); ?>" />
							</div>
						</td>
					</tr>

					<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>

				</table>

				
					
					

				<?php do_action( 'woocommerce_after_cart_totals' ); ?>
			</div>
		</div>
	</div>
</section>





