<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
$shop_id = get_option( 'woocommerce_shop_page_id' );
//print_r($shop_id); exit();

if( $shop_id && is_archive('product') && !(is_tax( 'product_cat' )) ) {

 $meta = wooland_WSH()->get_meta('_sh_layout_settings', get_option( 'woocommerce_shop_page_id' ));
 $sidebar = wooland_wow_sh_set( $meta, 'sidebar') ? $meta['sidebar'] : 'default-sidebar';
 //print_r($meta); exit();
 $layout = wooland_wow_sh_set( $meta, 'layout', 'full' );//print_r($layout);exit;
}
elseif( is_tax( 'product_cat' ) || is_tax( 'product_tag' ) )
{
 $meta = wooland_WSH()->get_term_meta( '_sh_category_settings' ); 
 $layout = wooland_wow_sh_set( $meta, 'layout', 'full' );//print_r($layout);exit;
 $sidebar = wooland_wow_sh_set( $meta, 'sidebar') ? $meta['sidebar'] : 'default-sidebar';//print_r($sidebar); 
}
/*if( $shop_id ) {
 $meta = wooland_WSH()->get_meta('_sh_header_settings', get_option( 'woocommerce_shop_page_id' ));
 $bg_image = wooland_wow_sh_set( $meta, 'bg_image', 'full' );

$sidebar = wooland_wow_sh_set( $meta, 'sidebar') ? $meta['sidebar'] : 'default-sidebar';//print_r($sidebar); exit();
}
*/


$layout = wooland_wow_sh_set( $_GET, 'layout' ) ? $_GET['layout'] : $layout; //print_r($layout);exit;
if( !$layout || $layout == 'full' || wooland_wow_sh_set($_GET, 'layout_style')=='full' ) $sidebar = ''; else
$sidebar = wooland_wow_sh_set( $meta, 'sidebar') ? $meta['sidebar'] : 'default-sidebar';//print_r($sidebar); exit();
$classes = ( !$layout || $layout == 'full' || wooland_wow_sh_set($_GET, 'layout_style')=='full' ) ? ' col-md-12' : ' col-lg-9 col-md-9 col-sm-9';




get_header( 'shop' ); ?>

<?php get_template_part('includes/modules/templates/banner_area'); ?>

<section class="shop_listing_cc_area blog_area">

	<div class="container">

		<?php
			/**
			 * woocommerce_before_main_content hook.
			 *
			 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
			 * @hooked woocommerce_breadcrumb - 20
			 */
			do_action( 'woocommerce_before_main_content' );
		?>

		<?php if ( apply_filters( 'woocommerce_show_page_title', false ) ) : ?>

			<h1 class="page-title"><?php woocommerce_page_title(); ?></h1>

		<?php endif; ?>

		<?php
			/**
			 * woocommerce_archive_description hook.
			 *
			 * @hooked woocommerce_taxonomy_archive_description - 10
			 * @hooked woocommerce_product_archive_description - 10
			 */
			do_action( 'woocommerce_archive_description' );
		?>

		<div class="row">

			<?php if( $layout == 'left' ): ?>
					
				<div class="pull-left col-md-3 col-sm-3 col-xs-12">
					<div id="sidebar" class="clearfix">
						<?php dynamic_sidebar( $sidebar ); ?>
						<?php
							/**
							 * woocommerce_sidebar hook
							 *
							 * @hooked woocommerce_get_sidebar - 10
							 */
							do_action( 'woocommerce_sidebar' );
						?>
					</div>
                </div>

			<?php endif; ?>
			

			<?php if ( have_posts() ) : ?>
						
				<div class="<?php echo esc_attr($classes);?>">
						
					<?php
						/**
						 * woocommerce_before_shop_loop hook.
						 *
						 * @hooked woocommerce_result_count - 20
						 * @hooked woocommerce_catalog_ordering - 30
						 */
						do_action( 'woocommerce_before_shop_loop' );
					?>
					


					<?php //woocommerce_product_loop_start(); ?>

						<?php woocommerce_product_subcategories(); ?>

						<?php while ( have_posts() ) : the_post(); ?>

							<?php wc_get_template_part( 'content', 'product' ); ?>

						<?php endwhile; // end of the loop. ?>

					<?php //woocommerce_product_loop_end(); ?>

					<?php
						/**
						 * woocommerce_after_shop_loop hook.
						 *
						 * @hooked woocommerce_pagination - 10
						 */
						do_action( 'woocommerce_after_shop_loop' );
					?>

				</div>

			<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

				<?php wc_get_template( 'loop/no-products-found.php' ); ?>

			<?php endif; ?>

			<?php if( $layout == 'right' ): ?>
	
				
                <div class="pull-right col-md-3 col-sm-3 col-xs-12">
					<div id="sidebar" class="clearfix">
						<?php dynamic_sidebar( $sidebar ); ?>
						<?php
							/**
							 * woocommerce_sidebar hook
							 *
							 * @hooked woocommerce_get_sidebar - 10
							 */
							do_action( 'woocommerce_sidebar' );
						?>
					</div>
                </div>
	
			<?php endif; ?>

			<?php
				/**
				 * woocommerce_after_main_content hook.
				 *
				 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
				 */
				do_action( 'woocommerce_after_main_content' );
			?>


		</div>

	</div>
	
</section>

<?php get_footer( 'shop' ); ?>
