function initialize() {

		"use strict";

		var $ = jQuery;
   		var container = document.getElementById('googleMap'),
   		lat = $(container).data('lat'),
   		long = $(container).data('long'),
   		marker = $(container).data('marker');
   		

      var mapOptions = {
        zoom: 15,
        scrollwheel: false,
         center: new google.maps.LatLng(lat, long)
     };

     var map = new google.maps.Map(container,
         mapOptions);


     var marker = new google.maps.Marker({
        position: map.getCenter(),
        animation:google.maps.Animation.BOUNCE,
         icon: marker,
           map: map
    });

}


jQuery(document).ready(function($) {

    "user strict";

	try{
	   	
	    google.maps.event.addDomListener(window, 'load', initialize);
	}
	catch(e) {
		console.log(e.message);
	}

	if ($('#map').length && $.mdMapExtend ) {
	var mapmarker = $('#map').data('marker'); //alert($('#map').data('marker'));
	$('#map').mdMapExtend({
	            appendTo: '#map',
	            autoCenter: true,
	            zoom: 14,
	            style: 'lightGray',
	            iconMarker: mapmarker,
	            scrollwheel: false
	        });
	}


$('.wooland-product-quick-view').on('click', function(e){
	e.preventDefault();
	var permalink = $(this).attr('href');
	var data_target = $(this).data('target');

	data_target.find('modal-body').html('<i class="fa fa-refresh fa-pulse fa-lg"></i>');

	$.ajax({
		url: permalink,
		type: 'GET',
		success: function(res){
			
		}
	});

});

	
	//TOGGLE LOGIN / REGISTER FORM
	$('.dropdown-inner-log .toggle-header-register').on('click', function(e){
		e.preventDefault();
		$(this).parents('.header-login-form-popup').hide();
		$('.dropdown-inner-log .header-register-form-popup').show();
	});


	$('.dropdown-inner-log .toggle-header-login').on('click', function(e){
		e.preventDefault();
		$(this).parents('.header-register-form-popup').hide();
		$('.dropdown-inner-log .header-login-form-popup').show();
	});

	// TOGGLE MOBILE MENU
	$('.ofm li.m_nav').on('click', function() {
		$(".mobi-menu").slideToggle("slow");
		$(this).find(".mobi-menu").slideToggle("slow");
	}
	);
	$('#cssmenu li.menu-item-has-children>a').on('click', function() {
		$(this).removeAttr('href');
		var element = $(this).parent('li');
		if (element.hasClass('open')) {
			element.removeClass('open');
			element.find('li').removeClass('open');
			element.find('ul').slideUp();
		} else {
			element.addClass('open');
			element.children('ul').slideDown();
			element.siblings('li').children('ul').slideUp();
			element.siblings('li').removeClass('open');
			element.siblings('li').find('li').removeClass('open');
			element.siblings('li').find('ul').slideUp();
		}
	});
	$('#cssmenu>ul>li.menu-item-has-children>a').append('<span class="holder"></span>');
	(function getColor() {
		var r, g, b;
		var textColor = $('#cssmenu').css('color');
		textColor = textColor.slice(4);
		r = textColor.slice(0, textColor.indexOf(','));
		textColor = textColor.slice(textColor.indexOf(' ') + 1);
		g = textColor.slice(0, textColor.indexOf(','));
		textColor = textColor.slice(textColor.indexOf(' ') + 1);
		b = textColor.slice(0, textColor.indexOf(')'));
		var l = rgbToHsl(r, g, b);
		if (l > 0.7) {
			$('#cssmenu>ul>li>a').css('text-shadow', '0 1px 1px rgba(0, 0, 0, .35)');
			$('#cssmenu>ul>li>a>span').css('border-color', 'rgba(0, 0, 0, .35)');
		} else {
			$('#cssmenu>ul>li>a').css('text-shadow', '0 1px 0 rgba(255, 255, 255, .35)');
			$('#cssmenu>ul>li>a>span').css('border-color', 'rgba(255, 255, 255, .35)');
		}
	})();

	function rgbToHsl(r, g, b) {
		r /= 255, g /= 255, b /= 255;
		var max = Math.max(r, g, b),
			min = Math.min(r, g, b);
		var h, s, l = (max + min) / 2;
		if (max == min) {
			h = s = 0;
		} else {
			var d = max - min;
			s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
			switch (max) {
				case r:
					h = (g - b) / d + (g < b ? 6 : 0);
					break;
				case g:
					h = (b - r) / d + 2;
					break;
				case b:
					h = (r - g) / d + 4;
					break;
			}
			h /= 6;
		}
		return l;
	}
	
	
	// accordion
	
	$('.collapse').on('shown.bs.collapse', function(){
		$(this).parent().find(".fa-plus").removeClass("fa-plus").addClass("fa-minus");
		}).on('hidden.bs.collapse', function(){
		$(this).parent().find(".fa-minus").removeClass("fa-minus").addClass("fa-plus");
	});


	 // This button will increment the value
	$('.qtyplus').click(function(e){
		// Stop acting like a button
		e.preventDefault();
		// Get the field name
		fieldName = $(this).attr('field');
		// Get its current value
		var currentVal = parseInt($('input[name='+fieldName+']').val());
		// If is not undefined
		if (!isNaN(currentVal)) {
			// Increment
			$('input[name='+fieldName+']').val(currentVal + 1);
		} else {
			// Otherwise put a 0 there
			$('input[name='+fieldName+']').val(0);
		}
	});
	// This button will decrement the value till 0
	$(".qtyminus").click(function(e) {
		// Stop acting like a button
		e.preventDefault();
		// Get the field name
		fieldName = $(this).attr('field');
		// Get its current value
		var currentVal = parseInt($('input[name='+fieldName+']').val());
		// If it isn't undefined or its greater than 0
		if (!isNaN(currentVal) && currentVal > 0) {
			// Decrement one
			$('input[name='+fieldName+']').val(currentVal - 1);
		} else {
			// Otherwise put a 0 there
			$('input[name='+fieldName+']').val(0);
		}
	});

	 // This button will increment the value
	$('.qtyplus2').click(function(e){
		// Stop acting like a button
		e.preventDefault();
		// Get the field name
		fieldName = $(this).attr('field');
		// Get its current value
		var currentVal = parseInt($('input[name='+fieldName+']').val());
		// If is not undefined
		if (!isNaN(currentVal)) {
			// Increment
			$('input[name='+fieldName+']').val(currentVal + 1);
		} else {
			// Otherwise put a 0 there
			$('input[name='+fieldName+']').val(0);
		}
	});
	// This button will decrement the value till 0
	$(".qtyminus2").click(function(e) {
		// Stop acting like a button
		e.preventDefault();
		// Get the field name
		fieldName = $(this).attr('field');
		// Get its current value
		var currentVal = parseInt($('input[name='+fieldName+']').val());
		// If it isn't undefined or its greater than 0
		if (!isNaN(currentVal) && currentVal > 0) {
			// Decrement one
			$('input[name='+fieldName+']').val(currentVal - 1);
		} else {
			// Otherwise put a 0 there
			$('input[name='+fieldName+']').val(0);
		}
	});

	$('.qtyplus, .qtyminus').attr('field','quantity');
	$('.qtyplus2, .qtyminus2').attr('field','quantity');

	//Owl carousel
	$('.owl-carousel').owlCarousel({
			autoplay:100,
			loop:true,
			margin:0,
			nav:true,
			responsive:{
				0:{
					items:1
				},
				600:{
					items:2
				},
				1000:{
					items:4
				}
			}
		})
	

});


// Preloader js
jQuery(window).load(function(){
	
	var $ = jQuery;
	$('body, html').removeClass('fix');
	
	$(".preloader_wrapper").fadeOut(1000);
	
});


jQuery(document).ready(function($) {

	$('#contactform').submit(function(){

		var action = $(this).attr('action');

		$("#message").slideUp(750,function() {
		$('#message').hide();

		$('button#submit').attr('disabled','disabled');
		$('img.loader').css('visibility', 'visible');

		$.post(action, {
			contact_name: $('#contact_name').val(),
			contact_email: $('#contact_email').val(),
			contact_phone: $('#contact_phone').val(),
			contact_message: $('#contact_message').val(),
			verify: $('#verify').val()
		},
			function(data){
				document.getElementById('message').innerHTML = data;
				$('#message').slideDown('slow');
				$('#contactform img.loader').css('visibility', 'hidden' );
				
				$('#submit').removeAttr('disabled');
				if(data.match('success') != null) $('#contactform').slideUp('slow');

			}
		);

		});

		return false;

	});

	$('#loginform').on('submit', function(e){
		e.preventDefault();

		var data = $(this).serializeArray();
		
		var form_action = $(this).attr('action');
		var submit_btn = $('button[type=submit]', $(this) );

		var submit_btn_txt = submit_btn.text();
		submit_btn.html('<i class="fa fa-spinner fa-spin"></i>');


		$.ajax({
			url: form_action,
			type: 'POST',
			data: data,
			dataType: 'json',
			success: function(res) {

				if( res.type == 'success' ) {
					window.location = window.location;
				}

				if( res.type == 'error' ) {
					$('#topbar-messages').html(res.msg);
				}
				submit_btn.html(submit_btn_txt);
			}

		});

		return false;
	});


	$('#registerform').on('submit', function(e){
		e.preventDefault();

		var data = $(this).serializeArray();
		
		var form_action = $(this).attr('action');
		var submit_btn = $('button[type=submit]', $(this) );

		var submit_btn_txt = submit_btn.text();
		submit_btn.html('<i class="fa fa-spinner fa-spin"></i>');


		$.ajax({
			url: form_action,
			type: 'POST',
			data: data,
			dataType: 'json',
			success: function(res) {

				if( res.type == 'success' ) {
					//window.location = window.location;
					$('#topbar-messages-register').html(res.msg);
					//submit_btn.html(submit_btn_txt);
					$('#registerform').css('display', 'none');
				}

				if( res.type == 'error' ) {
					$('#topbar-messages-register').html(res.msg);
				}
				submit_btn.html(submit_btn_txt);
			}
			
		});

		return false;
	});

		
});



