<?php

/** Include the TGM_Plugin_Activation class. */
require_once get_template_directory() . '/includes/thirdparty/tgm-plugin-activation/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'wooland_theme_register_required_plugins' );

/**
 * [my_theme_register_required_plugins description]
 *
 * @return void [description]
 */
function wooland_theme_register_required_plugins() {

    $plugins = array(
					array(
					    'name' => 'Contact form 7',
					    'slug' => 'contact-form-7',
					    'required' => true,
					),
					array(
					    'name' => 'Theme Support',
					    'slug' => 'theme_support_wooland',
					    'source' => get_template_directory() . '/includes/thirdparty/tgm-plugin-activation/plugins/theme_support_wooland.zip',
					    'required' => true,
					    'version' => '1.0.1',
					    'force_activation' => false,
					    'force_deactivation' => false,
					    'external_url' => get_template_directory_uri() . '/includes/thirdparty/tgm-plugin-activation/plugins/theme_support_wooland.zip',
					    'file_path' => ABSPATH . 'wp-content/plugins/theme_support_wooland/theme_support.php'
					),
					array(
				        'name'                  => esc_html__('Envato Market Plugin', 'wooland' ),
				        'slug'                  => 'envato-market',
				        'source'                => 'http://envato.github.io/wp-envato-market/dist/envato-market.zip',
				        'required'              => true
				     ),
					array(
					    'name' => 'WPBakery Visual Composer',
					    'slug' => 'js_composer',
					    'source' => wooland_WOW_THEMES_ROOT . '/includes/thirdparty/tgm-plugin-activation/plugins/js_composer.zip',
					    'required' => true,
					    'version' => '5.0.1',
					    'force_activation' => false,
					    'force_deactivation' => false,
					    'external_url' => wooland_WOW_THEMES_URL . '/includes/thirdparty/tgm-plugin-activation/plugins/js_composer.zip',
					    'file_path' => ABSPATH . 'wp-content/plugins/js_composer/js_composer.php'
					),
					array(
					    'name' => 'Revolution Slider',
					    'slug' => 'revslider',
					    'source' => wooland_WOW_THEMES_ROOT . '/includes/thirdparty/tgm-plugin-activation/plugins/revslider.zip',
					    'required' => true,
					    'version' => '5.3.0.2',
					    'force_activation' => false,
					    'force_deactivation' => false,
					    'external_url' => wooland_WOW_THEMES_URL . '/includes/thirdparty/tgm-plugin-activation/plugins/revslider.zip',
					    'file_path' => ABSPATH . 'wp-content/plugins/revslider/revslider.php'
					),
					array(
					    'name' => 'Woocommerce',
					    'slug' => 'woocommerce',
					    'required' => true,
					),
    );

    // Change this to your theme text domain, used for internationalising strings
    $theme_text_domain = 'wooland';

    $config = array(
        'domain' => $theme_text_domain, // Text domain - likely want to be the same as your theme.
        'default_path' => '', // Default absolute path to pre-packaged plugins
        //'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
        //'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
        'menu' => 'install-required-plugins', // Menu slug
        'has_notices' => true, // Show admin notices or not
        'is_automatic' => true, // Automatically activate plugins after installation or not
        'message' => '', // Message to output right before the plugins table
    );

    tgmpa($plugins, $config);
}
