<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options      = array();


// -----------------------------------------
// Post Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_sh_single_post_options',
  'title'     => esc_html__('Extra Post Options', 'wooland'),
  'post_type' => 'post',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'header_settings',
      'fields' => array(

        array(
          'id'        => 'layout',
          'type'      => 'image_select',
          'title'     => esc_html__('Post Layout', 'wooland' ),
          'options'   => array(
            'left' => get_template_directory_uri().'/images/2cl.png',
            'full' => get_template_directory_uri().'/images/1col.png',
            'right' => get_template_directory_uri().'/images/2cr.png',
            
          ),
          'radio'        => true,
          'default'     => 'full'
        ),
          array(
          'id'    => 'banner',
          'type'  => 'upload',
          'title' => esc_html__('Header Background Image', 'wooland' ),
          'label' => esc_html__('Choose the header background image', 'wooland'),
          'attributes' => array(
                        'style' => 'width: 80%;'
                    ),
        ),
        array(
          'id'    => 'header_title',
          'type'  => 'text',
          'title' => esc_html__('Header Title', 'wooland' ),
          'label' => esc_html__('Enter header title', 'wooland' ),
          'attributes' => array(
                        'style' => 'width: 90%;'
                    ),
        ),
        array(
          'id'    => 'header_sub_title',
          'type'  => 'text',
          'title' => esc_html__('Header Sub Title', 'wooland' ),
          'label' => esc_html__('Enter header Sub title', 'wooland' ),
          'attributes' => array(
                        'style' => 'width: 90%;'
                    ),
        ),
             array(
          'id'    => 'section_1_switcher',
          'type'  => 'checkbox',
          'title' => esc_html__('Show/Hide breadcrumb on VC page', 'wooland' ),
          'label' => esc_html__('Only work with VC Page template', 'wooland' )
        ),
        array(
          'id'    => 'sidebar',
          'type'  => 'select',
          'title' => esc_html__('Sidebar', 'wooland' ),
          'options' => wooland_wow_themes_get_sidebars(),
          'default' => 'default-sidebar'
        ),
        array(
          'id'           => 'post_sidebar',
          'type'         => 'select',
          'options'        => array(
            'primary'      => 'Primary Option',
            'secondary'    => 'Secondry Option',
            'tertiary'     => 'Tertiary Option',
          ),
          'title'      => esc_html__('Choose Sidebar', 'wooland' ),
          'dependency'   => array( 'layout', '!=', 'full' ),
        ),
        array(
          'id'          => 'gallery_2',
          'type'        => 'gallery',
          'title'       => esc_html__('Gallery post format', 'wooland' ),
          'add_title'   => esc_html__('Choose Images', 'wooland' ),
          'edit_title'  => esc_html__('Edit Images', 'wooland' ),
          'clear_title' => esc_html__('Remove Images', 'wooland' ),
          'help'    => esc_html__('Choose image from media uploader only if the post format is Gallery', 'wooland' )
        ),

        array(
          'id'       => 'video',
          'type'     => 'wysiwyg',
          'title'    =>  esc_html__('Video Embed Code', 'wooland' ),
          'help'    => esc_html__('Fill only if post format is video', 'wooland' ),
          'settings' => array(
            'textarea_rows' => 5,
            'tinymce'       => false,
            'media_buttons' => false,
          )
        ),
        array(
          'id'       => 'audio_embed',
          'type'     => 'wysiwyg',
          'title'    =>  esc_html__('Audio Embed Code', 'wooland' ),
          'help'    => esc_html__('Fill only if post format is audio', 'wooland' ),
          'settings' => array(
            'textarea_rows' => 5,
            'tinymce'       => false,
            'media_buttons' => false,
          )
        ),

        array(
          'id'    => 'quote',
          'type'  => 'wysiwyg',
          'title' => esc_html__('Quote post format', 'wooland' ),
          'help'    => esc_html__('Fill only if post format is quote', 'wooland' )
        ),
        array(
          'id'      => 'hover_title',
          'type'    => 'text',
          'title'   => 'Hover Title',
          'description' => 'Enter the Hover Title of Image.',
        ),

        array(
          'id'          => 'sub_title',
          'type'        => 'text',
          'title'       => 'Sub Title',
          'description' => 'Enter the Hover Sub Title of Image.',
        )

      ),
    ),


    

  ),
);




// -----------------------------------------
// shop Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_sh_team_post_options',
  'title'     => esc_html__('Team Post Options', 'wooland'),
  'post_type' => 'sh_team',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'team_settings',
      'fields' => array(
          
          array(
          'id'    => 'desig',
          'type'  => 'text',
          'title' => 'Designation',
          ),
          array(
			  'id'              => 'social_media',
			  'type'            => 'group',
			  'title'           => 'Social Media',
			  'desc'            => 'This section is used to add Social Media.',
			  'button_title'    => 'Add More Social Media',
			  'accordion_title' => 'Social Media',
			  'fields'          => array(
			  
			  	/*array(
				  'id'      => 'hover_color',
				  'type'    => 'color_picker',
				  'title'   => 'Social media hover colour',
				  'desc'    => 'Choose the Custom color for social media hover.',
				  'default' => '#f4c212',
				),

				array(
				  'id'          => 'social_title',
				  'type'        => 'text',
				  'title'       => 'Title',
				  'description' => 'Enter the title of the social media.',
				),*/
				array(
				  'id'          => 'social_link',
				  'type'        => 'text',
				  'title'       => 'Link',
				  'description' => 'Enter the Link for Social Media.',
				  'default' => '#',
				),
				array(
				  'id'      => 'social_icon',
				  'type'    => 'icon',
				  'title'   => 'Icon',
				  'desc'    => 'Choose Icon for Social Media.',
				),

          )
        ),

      ),
    ),

  ),
);

// -----------------------------------------
// Team Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_sh_shop_post_options',
  'title'     => esc_html__('Shop Post Options', 'wooland'),
  'post_type' => 'sh_shop',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'shop_settings',
      'fields' => array(
           array(
          'id'    => 'num',
          'type'  => 'column_select',
            'options'        => array(
            'primary'      => 'Primary Option',
            'secondary'    => 'Secondry Option',
            'tertiary'     => 'Tertiary Option',
          ),
        ),
         

      ),
    ),

  ),
);





// -----------------------------------------
// Page Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_sh_header_settings',
  'title'     => 'Page Options',
  'post_type' => 'page',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    // begin: a section
    array(
      'name'  => 'wp_page_section',
      
      'icon'  => 'fa fa-cog',
      // begin: fields
      'fields' => array(
        array(
          'id'    => 'header_title',
          'type'  => 'text',
          'title' => esc_html__('Header Title', 'wooland' ),
          'label' => esc_html__('Enter header title', 'wooland' ),
          'attributes' => array(
                        'style' => 'width: 90%;'
                    ),
        ),
        array(
          'id'    => 'header_sub_title',
          'type'  => 'text',
          'title' => esc_html__('Header Sub Title', 'wooland' ),
          'label' => esc_html__('Enter header Sub title', 'wooland' ),
          'attributes' => array(
                        'style' => 'width: 90%;'
                    ),
        ),
        // end: a field
        array(
          'id'    => 'banner',
          'type'  => 'upload',
          'title' => esc_html__('Header Background Image', 'wooland' ),
          'label' => esc_html__('Choose the header background image', 'wooland'),
          'attributes' => array(
                        'style' => 'width: 80%;'
                    ),
        ),

        array(
          'id'    => 'section_1_switcher',
          'type'  => 'checkbox',
          'title' => esc_html__('Show/Hide breadcrumb on VC page', 'wooland' ),
          'label' => esc_html__('Only work with VC Page template', 'wooland' )
        ),

     
   

     

        
      ), // end: fields
    ), // end: a section

    

  ),
);

$options[]    = array(
  'id'        => '_sh_layout_settings',
  'title'     => 'Page Options',
  'post_type' => 'page',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(
    array(
      'name'  => 'wp_page_section',
      'icon'  => 'fa fa-cog',
      // begin: fields
      'fields' => array(
      array(
          'type'  => 'heading',
          'content' => esc_html__('Layout Settings', 'wooland' )
        ),
      array(
          'id'    => 'layout',
          'type'  => 'image_select',
          'title' => esc_html__('Page Layout', 'wooland' ),
          'options'   => array(
            'left'    => get_template_directory_uri() .'/images/2cl.png',
            'right'   => get_template_directory_uri() .'/images/2cr.png',
            'full' => get_template_directory_uri() .'/images/1col.png',
          ),
        ),
        // end: a field
      array(
          'id'    => 'sidebar',
          'type'  => 'select',
          'title' => esc_html__('Sidebar', 'wooland' ),
          'options' => wooland_wow_themes_get_sidebars(),
          'default' => 'default-sidebar'
        ),
      ),
      ),
    ),
  );


// -----------------------------------------
// Product Metabox Options                    -
// -----------------------------------------
$options[]    = array(
  'id'        => '_sh_single_product_options',
  'title'     => esc_html__('Extra Product Options', 'wooland'),
  'post_type' => 'product',
  'context'   => 'normal',
  'priority'  => 'default',
  'sections'  => array(

    array(
      'name'   => 'header_settings',
      'fields' => array(

     array(
          'id'    => 'banner',
          'type'  => 'upload',
          'title' => esc_html__('Header Background Image', 'wooland' ),
          'label' => esc_html__('Choose the header background image', 'wooland'),
          'attributes' => array(
                        'style' => 'width: 80%;'
                    ),
        ),
        array(
          'id'    => 'header_title',
          'type'  => 'text',
          'title' => esc_html__('Header Title', 'wooland' ),
          'label' => esc_html__('Enter header title', 'wooland' ),
          'attributes' => array(
                        'style' => 'width: 90%;'
                    ),
        ),
        array(
          'id'    => 'header_sub_title',
          'type'  => 'text',
          'title' => esc_html__('Header Sub Title', 'wooland' ),
          'label' => esc_html__('Enter header Sub title', 'wooland' ),
          'attributes' => array(
                        'style' => 'width: 90%;'
                    ),
        ), 
          array(
          'id'    => 'badge',
          'type'  => 'text',
          'title' => esc_html__('badge text', 'wooland' ),
          'label' => esc_html__('Enter Badge Text', 'wooland' ),
       
        ),     
      array(
     'id'              => 'product_color',
     'type'            => 'group',
     'title'           => 'Product Color',
     'desc'            => 'This section is used to add Product Colors.',
     'button_title'    => 'Add More Product Colors',
     'accordion_title' => 'Product Color',
     'fields'          => array(
     
          array(
          'id'      => 'prod_color',
          'type'    => 'color_picker',
          'title'   => 'Product Color',
          'desc'    => 'Choose the Custom color for Products.',
          'default' => '#000',
        ),
          )
        ),

      ),
    ),

  ),
);
CSFramework_Metabox::instance( $options );
