<?php

if (!defined('ABSPATH')) {
    die;
}
// Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings = array(
    'menu_title' => esc_html__('Theme Options', 'wooland'),
    'menu_type' => 'add_theme_page',
    'menu_slug' => wooland_WOW_THEMES_NAME . '_options',
    'ajax_save' => false,
);

// =====================================================Blog=========================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options = array();


// ------------------------------
// GENERAL SETTINGS   -
// ------------------------------
$options[] = array(
    'name' => 'gen_settings',
    'title' => 'GENERAL SETTINGS',
    'icon' => 'fa fa-cogs',
    'sections' => array(
        // -----------------------------
        // begin: General Settings         -
        // -----------------------------
        array(
            'name' => 'general_settings',
            'title' => 'General Settings',
            'icon' => 'fa fa-cog',
            // begin: fields
            'fields' => array( 
                array(
                    'type' => 'heading',
                    'content' => 'upload logo',
                ),

             array(
          'id'      => 'site_logo',
          'type'    => 'upload',
          'title'   => 'Logo',
          'desc'    => 'Upload the Logo.',
        ),
                // begin: color scheme heading
                array(
                    'type' => 'heading',
                    'content' => 'Color Scheme',
                ),
                array(
                    'id' => 'color_schemes',
                    'type' => 'color_picker',
                    'title' => 'Color Scheme',
                    'desc' => 'Choose the Custom color scheme for the theme.',
                    'default' => 'rgba(0, 0, 255, 0.25)',
                ),
                // begin: Boxed Version Settings
               /* array(
                    'type' => 'heading',
                    'content' => 'Boxed Version Settings',
                ),*/
               /* array(
                    'id' => 'boxed_version_settings',
                    'type' => 'switcher',
                    'title' => 'Boxed Version Settings',
                    'desc' => 'This section contain the information about boxed version settings.',
                    'label' => 'Yes, Please do it.',
                ),*/
                // begin: color Twitter Settings
             
                // begin: Purchase Information
                array(
                    'type' => 'heading',
                    'content' => 'Purchase Information',
                ),
                array(
                    'id' => 'purchase_information',
                    'type' => 'text',
                    'title' => 'Purchase Information',
                    'desc' => 'To get the auto theme updates provide purchase information.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'sh_purchase_code',
                    'type' => 'text',
                    'title' => 'Purchase Code',
                    'desc' => 'To find the purchase code to TF downloads tab click on Download then choose "License and Purchase code.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
            ), // end: fields
        ), // end: General Settings
        // -----------------------------
        // begin: Header Settings     -
        // -----------------------------
        array(
            'name' => 'header_settings',
            'title' => 'Header Settings',
            'icon' => 'fa fa-hand-o-right',
            'fields' => array(
                // begin: Favicon

                array(
                    'type' => 'heading',
                    'content' => 'Header Settings',
                ),
                                    array(
                    'id' => 'shopping_cart_settings',
                    'type' => 'switcher',
                    'title' => 'Shopping Cart',
                     'default'=> true,
                    'desc' => 'This section contain the information about show or hide shopping cart.',
                    'label' => 'Yes, Please do it.',
                ),
       
                 array(
                    'id' => 'currency_dropdown_settings',
                    'type' => 'switcher',
                    'title' => 'Currency Dropdown',
                    'desc' => 'This section contain the information about Currency Dropdown.',
                    'default'=> true,
                    'label' => 'Yes, Please do it.',
                    
                ),
                 array(
                    'id' => 'social_icons_settings',
                    'type' => 'switcher',
                    'title' => 'Social icons',
                    'default'=> true,
                    'desc' => 'This section contain the information about social icons.',
                    'label' => 'Yes, Please do it.',
                ),
                   array(
                    'id' => 'login_register_popup_settings',
                    'type' => 'switcher',
                    'title' => 'Login Register Popup',
                    'desc' => 'This section contain the information about Login Register Popup.',
                    'default'=> true,
                    'label' => 'Yes, Please do it.',
                ),
                     array(
                    'id' => 'pre_loader_settings',
                    'type' => 'switcher',
                    'title' => 'Pre Loader',
                    'default'=> false,
                    'desc' => 'This section contain the information about Pre loader setting.',
                    'label' => 'Yes, Please do it.',
                ),
              /*
                array(
                    'id' => 'site_logo',
                    'type' => 'upload',
                    'title' => 'Upload the Logo',
                    'attributes' => array(
                        'style' => 'width: 502px;'
                    ),
                    'settings' => array(
                        'button_title' => 'Upload Logo',
                        'frame_title' => 'Choose a image',
                        'insert_title' => 'Use this image',
                    ),
                ),*/
             
                /* 		array(
                  'id'    => 'searchbox',
                  'type'  => 'switcher',
                  'title' => 'Show Search Box',
                  'desc'  => 'Show or hide search box in header.',
                  'label' => 'Yes, Please do it.',
                  ), */
                array(
                    'id' => 'header_css',
                    'type' => 'textarea',
                    'title' => 'Header CSS',
                    'desc' => 'Write your custom css to include in header.',
                    'default' => '',
                ),
            ),
        ), // end: header settings
        // -----------------------------
        // begin: Footer Settings     -
        // -----------------------------
        array(
            'name' => 'footer_settings',
            'title' => 'Footer Settings',
            'icon' => 'fa fa-hand-o-right',
            'fields' => array(
                // begin: Footer Settings

                array(
                    'type' => 'heading',
                    'content' => 'Footer Settings',
                ),
                array(
                    'id' => 'show_footer',
                    'type' => 'switcher',
                    'title' => 'Show/Hide whole footer',
                    'default'=> true,
                    'desc' => 'Show or hide whole footer.',
                    'label' => 'Yes, Please do it.',
                ),
                /* 		array(
                  'id'      => 'footer_bg',
                  'attributes' => array(
                  'style'    => 'width: 536px;'
                  ),
                  'type'    => 'upload',
                  'title'   => 'Footer Background',
                  'desc'    => 'choose the Footer Background.',
                  'help'    => 'choose the Footer Background.',
                  ), 
                array(
                    'id' => 'footer_address',
                    'type' => 'textarea',
                    'title' => 'Footer Address',
                    'desc' => 'Enter Address to show on footer.',
                    'default' => '123 South corner street, Melbourne.',
                ),
                array(
                    'id' => 'footer_phone',
                    'type' => 'text',
                    'title' => 'Footer Phone',
                    'desc' => 'Enter Phone to show on footer.',
                    'default' => '+61 012 345 6789',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'footer_email',
                    'type' => 'text',
                    'title' => 'Footer Email',
                    'desc' => 'Enter Email to show on footer.',
                    'default' => 'info@agile.com',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),*/
                array(
                    'id' => 'copy_right',
                    'type' => 'textarea',
                    'title' => 'Copy Right Text',
                    'desc' => 'Enter the Copy Right Text.',
                    'default' => 'All Rights Reserved by <a href="http://wow-themes.com/wordpress/wooland/">Wooland Shoping.</a>',
                ),
                array(
            'id' => 'payment_method',
            'type' => 'group',
            'title' => 'Payment Methods',
            'button_title' => 'Add Payment Method',
            'desc' => 'This section is used to add Payment Method.',
            'accordion_title' => 'Payment Method',
            'fields' => array(
                array(
                    'id' => 'payment_title',
                    'type' => 'text',
                    'title' => 'Title',
                    'desc' => 'Enter the title of Payment.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'payment_link',
                    'type' => 'text',
                    'title' => 'Link',
                    'desc' => 'Enter the Link for Payment.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                  array(
                    'id' => 'payment_type',
                    'type' => 'upload',
                    'title' => 'Upload the image',
                    'attributes' => array(
                        'style' => 'width: 502px;'
                    ),
                    'settings' => array(
                        'button_title' => 'Upload Image',
                        'frame_title' => 'Choose a image',
                        'insert_title' => 'Use this image',
                    ),
                ),
              
            )
        ),
            ),
        ), // end: footer settings
        // -----------------------------
        // begin: Permalinks Settings       -
    
    )
);

// ------------------------------
// a seperator                  -
// ------------------------------
// ------------------------------
// GENERAL SETTINGS   -
// ------------------------------
$options[] = array(
    'name' => 'page_settings',
    'title' => 'Page Settings',
    'icon' => 'fa fa-file',
    'sections' => array(
        // -----------------------------
        // begin: Blog Page Settings         -
        // -----------------------------
        array(
            'name' => 'single_post_settings',
            'title' => 'Single Post Page',
            'icon' => 'fa fa-cog',
            // begin: fields
            'fields' => array(
                // begin: color scheme heading
                array(
                    'type' => 'heading',
                    'content' => 'Post Detail Page Settings',
                ),
                array(
                    'id' => 'single_post_related',
                    'type' => 'switcher',
                    'default'=> true,
                    'title' => 'Enable Related Posts',
                    'desc' => 'Enable to show Related Posts on post detail page',
                    'label' => '',
                ),
                array(
                    'id' => 'single_post_author',
                    'type' => 'switcher',
                    'title' => 'Enable Post Author',
                    'default'=> true,
                    'desc' => 'Enable to show post author on post detail page',
                    'label' => '',
                ),
             
                array(
                    'id' => 'single_post_comment',
                    'type' => 'switcher',
                    'title' => 'Enable Post Commnets Counter',
                    'default'=> true,
                    'desc' => 'Enable to show post comments counter on post detail page',
                    'label' => '',
                ),
                array(
                    'id' => 'single_post_tags',
                    'type' => 'switcher',
                    'title' => 'Enable Post Tags',
                    'default'=> true,
                    'desc' => 'Enable to show post tags on post detail page',
                    'label' => '',
                ),
                array(
                    'id' => 'single_post_navigation',
                    'type' => 'switcher',
                    'title' => 'Enable Post Navigation',
                    'default'=> true,
                    'desc' => 'Enable to show post navigation on post detail page',
                    'label' => '',
                ),

               // end: group options
            ), // end: fields
        ), // end: General Settings
        // -----------------------------
        // begin: Blog Page Settings         -
        // -----------------------------
        array(
            'name' => 'blog_page_settings',
            'title' => 'Blog Page',
            'icon' => 'fa fa-cog',
            // begin: fields
            'fields' => array(
                // begin: color scheme heading
                array(
                    'type' => 'heading',
                    'content' => 'Blog Page Settings',
                ),
                array(
                    'id' => 'blog_page_title',
                    'type' => 'text',
                    'title' => 'Blog Page Title',
                    'desc' => 'Enter the Title you want to show on blog page.',
                    'default' => 'Blog',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'blog_page_sub_title',
                    'type' => 'text',
                    'title' => 'Blog Page Sub-Title',
                    'desc' => 'Enter the sub Title you want to show on blog page.',
                    'default' => 'COOLEST COLLECTION OF THE SEASON IS ON',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'blog_banner',
                    'type' => 'upload',
                    'title' => 'Banner Image',
                    'desc' => 'Upload Image for archive Page.',
                    'attributes' => array(
                        'style' => 'width: 81.9%;'
                    ),
                ),    
                array(
                    'id' => 'blog_page_sidebar',
                    'type' => 'select',
                    'title' => 'Select with Chosen',
                    'options' => wooland_wow_themes_get_sidebars()
                ),
                array(
                    'id' => 'blog_page_layout',
                    'type' => 'image_select',
                    'title' => 'Page Layout',
                    'options' => array(
                        'left' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cl.png',
                        'right' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cr.png',
                        'full' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/1col.png',
                    ),
                    'radio' => true,
                    'default' => 'full'
                ),
              
             
            ), // end: fields
        ), // end: General Settings
         // -----------------------------
        // begin: Search Page Settings         -
        // -----------------------------
     
        // -----------------------------
        // begin: Archive Page Settings     -
        // -----------------------------
        array(
            'name' => 'archive_page_settings',
            'title' => 'Archive Page',
            'icon' => 'fa fa-archive',
            'fields' => array(
                // begin: Favicon

                array(
                    'type' => 'heading',
                    'content' => 'Archive Page Settings',
                ),
                array(
                    'id' => 'archive_page_title',
                    'type' => 'text',
                    'title' => 'Archive Page Title',
                    'desc' => 'Enter the Title you want to show on blog archive page.',
                    'default' => 'Archive Page',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                 array(
                    'id' => 'archive_page_title_sub',
                    'type' => 'text',
                    'title' => 'Archive Page Sub Title',
                    'desc' => 'Enter the Sub Title you want to show on blog archive page.',
                    'default' => 'Archive Page',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                  array(
                    'id' => 'archive_banner',
                    'type' => 'upload',
                    'title' => 'Banner Image',
                    'desc' => 'Upload Image for archive Page.',
                    'attributes' => array(
                        'style' => 'width: 81.9%;'
                    ),
                ),    
                array(
                    'id' => 'archive_page_sidebar',
                    'type' => 'select',
                    'title' => 'Select with Chosen',
                    'options' => wooland_wow_themes_get_sidebars()
                ),
                array(
                    'id' => 'archive_page_layout',
                    'type' => 'image_select',
                    'title' => 'Page Layout',
                    'options' => array(
                        'left' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cl.png',
                        'right' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cr.png',
                        'full' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/1col.png',
                    ),
                    'radio' => true,
                    'default' => 'full'
                ),
            ),
        ), // end: Archive Page settings
        // -----------------------------
    // begin: Author Page Settings     -
        // -----------------------------
        array(
            'name' => 'author_page_settings',
            'title' => 'Author Page',
            'icon' => 'fa fa-user',
            'fields' => array(
                // begin: Footer Settings

                array(
                    'type' => 'heading',
                    'content' => 'Author Page Settings',
                ),
                array(
                    'id' => 'author_page_title',
                    'type' => 'text',
                    'title' => 'Author Page Title',
                    'desc' => 'Enter the Title you want to show on author page.',
                    'default' => 'Author Page',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'author_page_sidebar',
                    'type' => 'select',
                    'title' => 'Select with Chosen',
                    'options' => wooland_wow_themes_get_sidebars()
                ),
                array(
                    'id' => 'author_page_layout',
                    'type' => 'image_select',
                    'title' => 'Page Layout',
                    'options' => array(
                        'left' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cl.png',
                        'right' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cr.png',
                        'full' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/1col.png',
                    ),
                    'radio' => true,
                    'default' => 'full'
                ),
                array(
                      'id'    => 'section_1_switcher_author',
                      'type'  => 'checkbox',
                      'title' => esc_html__('Show/Hide breadcrumb on VC page', 'wooland' ),
                      'default'=> true,
                      'label' => esc_html__('Check to show breadcrumb', 'wooland' )
                    ),
                array(
                      'id'    => 'header_title',
                      'type'  => 'text',
                      'title' => esc_html__('Header Sub Title', 'wooland' ),
                      'label' => esc_html__('Enter header sub title', 'wooland' ),
                      
                      'attributes' => array(
                                    'style' => 'width: 512px;'
                                ),
                    ),
                    // end: a field
                array(
                  'id'    => 'banner_author',
                  'type'  => 'upload',
                  'title' => esc_html__('Header Background Image', 'wooland' ),
                  'label' => esc_html__('Choose the header background image', 'wooland'),
                  
                  'attributes' => array(
                                'style' => 'width: 445px;'
                            ),
                ),

             
            ),
        ), // end: Author Page settings
        // begin: Category Page Settings         -
            // begin: Category Page Settings         -
        // -----------------------------
        array(
            'name' => 'category_page_settings',
            'title' => 'Category Page',
            'icon' => 'fa fa-cog',
            'fields' => array(
                // begin: Footer Settings

                array(
                    'type' => 'heading',
                    'content' => 'Category Settings',
                ),
                array(
                    'id' => 'category_page_title',
                    'type' => 'text',
                    'title' => 'Category  Page Title',
                    'desc' => 'Enter the Title you want to show on Category  page.',
                    'default' => 'Category  Page',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'category_page_sidebar',
                    'type' => 'select',
                    'title' => 'Select with Chosen',
                    'options' => wooland_wow_themes_get_sidebars()
                ),
                array(
                    'id' => 'category_page_layout',
                    'type' => 'image_select',
                    'title' => 'Page Layout',
                    'options' => array(
                        'left' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cl.png',
                        'right' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cr.png',
                        'full' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/1col.png',
                    ),
                    'radio' => true,
                    'default' => 'full'
                ),
                array(
                      'id'    => 'section_1_switcher_category',
                      'type'  => 'checkbox',
                      'default'=> true,
                      'title' => esc_html__('Show/Hide breadcrumb on VC page', 'wooland' ),
                      'label' => esc_html__('Check to show breadcrumb', 'wooland' )
                    ),
                array(
                      'id'    => 'header_title_category',
                      'type'  => 'text',
                      'title' => esc_html__('Header Sub Title', 'wooland' ),
                      'label' => esc_html__('Enter header sub title', 'wooland' ),
                      'attributes' => array(
                                    'style' => 'width: 512px;'
                                ),
                    ),
                    // end: a field
                array(
                  'id'    => 'banner_category',
                  'type'  => 'upload',
                  'title' => esc_html__('Header Background Image', 'wooland' ),
                  'label' => esc_html__('Choose the header background image', 'wooland'),
                  'attributes' => array(
                                'style' => 'width: 445px;'
                            ),
                ),

             
            ),
        ), // end: General Settings
        // ----------------------------- // end: General Settings
        // -----------------------------
        // begin: Tag Page Settings         -
         array(
            'name' => 'tags_page_settings',
            'title' => 'Tags Page',
            'icon' => 'fa fa-cog',
            'fields' => array(
                // begin: Footer Settings

                array(
                    'type' => 'heading',
                    'content' => 'Tags Settings',
                ),
                array(
                    'id' => 'tags_page_title',
                    'type' => 'text',
                    'title' => 'Tags Page Title',
                    'desc' => 'Enter the Title you want to show on Tags page.',
                    'default' => 'Tags Page',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'tags_page_sidebar',
                    'type' => 'select',
                    'title' => 'Select with Chosen',
                    'options' => wooland_wow_themes_get_sidebars()
                ),
                array(
                    'id' => 'tags_page_layout',
                    'type' => 'image_select',
                    'title' => 'Page Layout',
                    'options' => array(
                        'left' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cl.png',
                        'right' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/2cr.png',
                        'full' => wooland_WOW_THEMES_URL . '/includes/thirdparty/framework/assets/images/1col.png',
                    ),
                    'radio' => true,
                    'default' => 'full'
                ),
                array(
                      'id'    => 'section_1_switcher_tags',
                      'type'  => 'checkbox',
                      'title' => esc_html__('Show/Hide breadcrumb on VC page', 'wooland' ),
                      'default'=> true,
                      'label' => esc_html__('Check to show breadcrumb', 'wooland' )
                    ),
                array(
                      'id'    => 'header_title_tags',
                      'type'  => 'text',
                      'title' => esc_html__('Header Sub Title', 'wooland' ),
                      'label' => esc_html__('Enter header sub title', 'wooland' ),
                      'attributes' => array(
                                    'style' => 'width: 512px;'
                                ),
                    ),
                    // end: a field
                array(
                  'id'    => 'banner_tags',
                  'type'  => 'upload',
                  'title' => esc_html__('Header Background Image', 'wooland' ),
                  'label' => esc_html__('Choose the header background image', 'wooland'),
                  'attributes' => array(
                                'style' => 'width: 445px;'
                            ),
                ),

             
            ),
        ),
         // end: General Settings
        //
            // -----------------------------
        // begin: 404 page Settings       -
        // -----------------------------
        array(
            'name' => '404_page_settings',
            'title' => '404 Page Settings',
            'icon' => 'fa fa-exclamation-triangle',
            'fields' => array(
                array(
                    'type' => 'heading',
                    'content' => '404 Page Settings',
                ),
                array(
                  'id'    => '404_banner_title',
                  'type'  => 'text',
                  'title' => esc_html__('Page Title', 'wooland' ),
                  'label' => esc_html__('Enter the Title you want to show on 404 page.', 'wooland' ),
                  'attributes' => array(
                                'style' => 'width: 100%;'
                            ),
                ),
                array(
                  'id'    => '404_banner_sub_title',
                  'type'  => 'text',
                  'title' => esc_html__('Page sub-Title', 'wooland' ),
                  'label' => esc_html__('Enter the sub-Title you want to show on 404 page.', 'wooland' ),
                  'attributes' => array(
                                'style' => 'width: 100%;'
                            ),
                ),
             
                // end: a field
                array(
                  'id'    => 'banner_404',
                  'type'  => 'upload',
                  'title' => esc_html__('Page Background Image', 'wooland' ),
                  'label' => esc_html__('Choose the page background image', 'wooland'),
                  'attributes' => array(
                                'style' => 'width: 81.9%;'
                            ),
                ),

                 array(
                      'id'    => 'section_1_switcher_404',
                      'type'  => 'checkbox',
                      'title' => esc_html__('Show/Hide breadcrumb on VC page', 'wooland' ),
                      'default'=> true,
                      'label' => esc_html__('Check to show breadcrumb', 'wooland' )
                    ),
              
                     array(
                    'id' => '404_page_title1',
                    'type' => 'text',
                    'title' => '404 Title',
                    'desc' => 'Enter the Heading Text 2 you want to show on 404 page.',
                    'default' => '',
                    'attributes' => array(
                                'style' => 'width: 100%;'
                            ),
                ),
             
                array(
                    'id' => '404_page_text',
                    'type' => 'textarea',
                    'title' => '404 Page Text',
                    'desc' => 'Enter the Text you want to show on 404 page.',
                    'default' => '',
                ),


               
            ),
        ), // end: other options
        // end: other options
    )
);



// ------------------------------
// GENERAL SETTINGS   -
// ------------------------------
$options[] = array(
    'name' => 'sidebar_settings',
    'title' => 'Sidebar Settings',
    'icon' => 'fa fa-bars',
    'fields' => array(
        array(
            'type' => 'heading',
            'content' => 'Add Sidebar'
        ),
        array(
            'id' => 'dynamic_sidebar',
            'type' => 'group',
            'title' => 'Dynamic Sidebar',
            'button_title' => 'Add Dynamic Sidebar',
            'desc' => 'This section is used to add more dynamic sidebars.',
            'accordion_title' => 'Add New Field',
            'fields' => array(
                array(
                    'id' => 'sidebar_name',
                    'type' => 'text',
                    'title' => 'Sidebar Name',
                    'desc' => 'Add Sidebar From Here.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
            )
        ), // end: group options
    ),
);



$options[] = array(
    'name' => 'social_media',
    'title' => 'Social Media',
    'icon' => 'fa fa-share-square',
    'fields' => array(
        array(
            'type' => 'heading',
            'content' => 'Add Social Media'
        ),
        array(
            'id' => 'social_media',
            'type' => 'group',
            'title' => 'Social Media',
            'button_title' => 'Add Social Media',
            'desc' => 'This section is used to add social media.',
            'accordion_title' => 'Social Media',
            'fields' => array(
                array(
                    'id' => 'hover_color',
                    'type' => 'color_picker',
                    'title' => 'Social media hover colour',
                    'desc' => 'Choose the Custom color for social media hover..',
                    'default' => 'rgba(0, 0, 255, 0.25)',
                ),
                array(
                    'id' => 'social_title',
                    'type' => 'text',
                    'title' => 'Title',
                    'desc' => 'Enter the title of the social media.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'social_link',
                    'type' => 'text',
                    'title' => 'Link',
                    'desc' => 'Enter the Link for Social Media.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'social_icon',
                    'type' => 'icon',
                    'title' => 'Icon',
                    'desc' => 'Choose Icon for Social Media.',
                ),
            )
        ), // end: group options
        
        array(
            'id' => 'social_media_widget',
            'type' => 'group',
            'title' => 'Social Media for Widget',
            'button_title' => 'Add Social Media',
            'desc' => 'This section is used to add social media to show in follow us widget.',
            'accordion_title' => 'Widget Social Media',
            'fields' => array(
                array(
                    'id' => 'hover_color',
                    'type' => 'color_picker',
                    'title' => 'Social media BG color',
                    'desc' => 'Choose the Custom color for social media background..',
                    'default' => 'rgba(0, 0, 255, 0.25)',
                ),
                array(
                    'id' => 'social_title',
                    'type' => 'text',
                    'title' => 'Title',
                    'desc' => 'Enter the title of the social media.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'social_link',
                    'type' => 'text',
                    'title' => 'Link',
                    'desc' => 'Enter the Link for Social Media.',
                    'attributes' => array(
                        'style' => 'width: 100%; height: 40px;'
                    ),
                ),
                array(
                    'id' => 'social_icon',
                    'type' => 'icon',
                    'title' => 'Icon',
                    'desc' => 'Choose Icon for Social Media.',
                ),
            )
        ), // end: group options
    ),
);



// ------------------------------
// Font Settings section with tabs   -
// ------------------------------
/*$options[]   = array(
  'name'     => 'font_settings',
  'title'    => 'Font Settings',
  'icon'     => 'fa fa-font',
  'sections' => array(

    // -----------------------------
    // begin: Heading Font options         -
    // -----------------------------
    array(
      'name'      => 'heading_font_settings',
      'title'     => 'Heading Font',
      'icon'      => 'fa fa-text-height',

      // begin: fields
      'fields'    => array(
	  
	  	array(
          'type'    => 'heading',
          'content' => 'Heading Font',
        ),
		
		// begin: a switcher
        array(
          'id'    => 'use_custom_font',
          'type'  => 'switcher',
          'title' => 'Use Custom Font',
		  'desc'  => 'Use custom font or not',
        ),
        // end: a switcher
		
		// H1 Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'H1 Settings',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'h1_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc' =>	'Select the font family to use for h1',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'h1_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading h1',
		  'default' => '#98ed28',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		
		// H2 Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'H2 Settings',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'h2_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc' =>	'Select the font family to use for h2',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'h2_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading h2',
		  'default' => '#98ed28',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		
		// H3 Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'H3 Settings',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'h3_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc' =>	'Select the font family to use for h3',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'h3_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading h3',
		  'default' => '#98ed28',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		
		// H4 Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'H4 Settings',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'h4_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc' =>	'Select the font family to use for h4',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'h4_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading h4',
		  'default' => '#98ed28',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		
		// H5 Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'H5 Settings',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'h5_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc' =>	'Select the font family to use for h5',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'h5_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading h5',
		  'default' => '#98ed28',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		
		// H6 Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'H6 Settings',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'h6_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc' =>	'Select the font family to use for h6',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'h6_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading h6',
		  'default' => '#98ed28',
		  'dependency'   => array( 'use_custom_font', '==', 'true' ),
		),
		

      ), // end: fields

    ), // end: Heading Fonts options
	
    // -----------------------------
    // begin: Body Font options         -
    // -----------------------------
    array(
      'name'      => 'body_font_settings',
      'title'     => 'Body Font',
      'icon'      => 'fa fa-text-width',

      // begin: fields
      'fields'    => array(
	  
	  	array(
          'type'    => 'heading',
          'content' => 'Body Font',
        ),
		
		// begin: a switcher
        array(
          'id'    => 'body_custom_font',
          'type'  => 'switcher',
          'title' => 'Use Custom Font',
		  'desc'  => 'Use custom font or not',
        ),
        // end: a switcher
		
		// Body Fonts Settings
		array(
		  'type'    => 'subheading',
		  'content' => 'Body Font Settings',
		  'dependency'   => array( 'body_custom_font', '==', 'true' ),
		),
		array(
          'id'        => 'body_font_family',
          'type'      => 'typography',
          'title'     => 'Font Family',
          'default'   => array(
            'family'  => 'Arial',
            'font'    => 'websafe',
          ),
          'chosen'    => false,
		  'desc'	  => 'Select the font family to use for body',
		  'dependency'=> array( 'body_custom_font', '==', 'true' ),
        ),
		array(
		  'id'      => 'body_font_color',
		  'type'    => 'color_picker',
		  'title'   => 'Font Color',
		  'desc'    => 'Choose the font color for heading body',
		  'default' => '#686868',
		  'dependency'   => array( 'body_custom_font', '==', 'true' ),
		),
		
      ), // end: fields

    ), // end: Body Fonts options
	
  )
);
*/






/*
$options[] = array(
    'name' => 'gallery_widget',
    'title' => 'Gallery Widget',
    'icon' => 'fa fa-gallery',
    'fields' => array(
        array(
            'type' => 'heading',
            'content' => 'Gallery Widget Settings'
        ),
        array(
          'id'          => 'gallery_widget_images',
          'type'        => 'gallery',
          'title'       => esc_html__('Choose Images', 'wooland' ),
          'add_title'   => esc_html__('Add Images', 'wooland' ),
          'edit_title'  => esc_html__('Edit Images', 'wooland' ),
          'clear_title' => esc_html__('Remove Images', 'wooland' )
        ),
        
    ),
);
*/


// ------------------------------
// backup                       -
// ------------------------------
$options[] = array(
    'name' => 'backup_section',
    'title' => 'Backup',
    'icon' => 'fa fa-shield',
    'fields' => array(
        array(
            'type' => 'notice',
            'class' => 'warning',
            'content' => 'You can save your current options. Download a Backup and Import.',
        ),
        array(
            'type' => 'backup',
        ),
    )
);

CSFramework::instance($settings, $options);
