<?php
/**
 * Related Posts
 *
 * @author 		WowThemes
 * @package 	Includes/Templates
 * @version     1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$meta = wooland_WSH()->get_meta('_sh_single_post_options');
$sub_title = wooland_wow_themes_set($meta, 'sub_title');
$hover_title = wooland_wow_themes_set($meta, 'hover_title');


$args = apply_filters( 'wooland_wow_themes_related_posts_args', array(
	'post_type'            => 'post',
	'ignore_sticky_posts'  => 1,
	'no_found_rows'        => 1,
	'posts_per_page'       => 3,
	'orderby'              => 'date',
	//'post__in'             => $related,
	'post__not_in'         => array( get_the_id() )
) );

$posts = new WP_Query( $args );
$columns = 3;
if ( $posts->have_posts() ) : ?>
	
		
	<div class="related_post">
			<h2><?php esc_html_e( 'realted Post', 'wooland' ); ?></h2>
		
		
		<?php //woocommerce_product_loop_start(); ?>
			<div class="row">
				<?php while ( $posts->have_posts() ) : $posts->the_post(); ?>
					<div class="col-md-4">
						<div class="single_r_post">
							<div class="r_img_hover">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('wooland_wow_themes_263x155'); ?></a>
								<div class="br_hover_box">
									<h4><?php echo balanceTags($hover_title); ?></h4>
									<p><?php echo balanceTags($sub_title); ?></p>
								</div>
							</div>
							<a href="<?php the_permalink(); ?>"><h5><?php echo the_title(); ?></h5></a>
						</div>
					</div>
				<?php endwhile; // end of the loop. ?>
				<?php //woocommerce_product_loop_end(); ?>
	
			</div>
	</div>
<?php endif;
wp_reset_postdata();


